/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.project.client.editor;

import com.google.gwt.user.client.ui.IsWidget;
import elemental2.dom.DomGlobal;
import elemental2.dom.HTMLElement;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.guvnor.common.services.shared.metadata.model.Overview;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.ui.ElementWrapperWidget;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.kie.workbench.common.dmn.api.qualifiers.DMNEditor;
import org.kie.workbench.common.dmn.client.commands.general.NavigateToExpressionEditorCommand;
import org.kie.workbench.common.dmn.client.docks.navigator.DecisionNavigatorDock;
import org.kie.workbench.common.dmn.client.editors.expressions.ExpressionEditorView;
import org.kie.workbench.common.dmn.client.editors.included.IncludedModelsPage;
import org.kie.workbench.common.dmn.client.editors.included.imports.IncludedModelsPageStateProviderImpl;
import org.kie.workbench.common.dmn.client.editors.search.DMNEditorSearchIndex;
import org.kie.workbench.common.dmn.client.editors.search.DMNSearchableElement;
import org.kie.workbench.common.dmn.client.editors.toolbar.ToolbarStateHandler;
import org.kie.workbench.common.dmn.client.editors.types.DataTypePageTabActiveEvent;
import org.kie.workbench.common.dmn.client.editors.types.DataTypesPage;
import org.kie.workbench.common.dmn.client.editors.types.listview.common.DataTypeEditModeToggleEvent;
import org.kie.workbench.common.dmn.client.events.EditExpressionEvent;
import org.kie.workbench.common.dmn.client.session.DMNSession;
import org.kie.workbench.common.dmn.client.widgets.codecompletion.MonacoFEELInitializer;
import org.kie.workbench.common.dmn.project.client.editor.DMNEditorMenuSessionItems;
import org.kie.workbench.common.dmn.project.client.editor.DMNProjectToolbarStateHandler;
import org.kie.workbench.common.dmn.project.client.type.DMNDiagramResourceType;
import org.kie.workbench.common.stunner.client.widgets.presenters.session.impl.SessionEditorPresenter;
import org.kie.workbench.common.stunner.client.widgets.presenters.session.impl.SessionViewerPresenter;
import org.kie.workbench.common.stunner.core.client.annotation.DiagramEditor;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.core.client.components.layout.LayoutHelper;
import org.kie.workbench.common.stunner.core.client.components.layout.OpenDiagramLayoutExecutor;
import org.kie.workbench.common.stunner.core.client.error.DiagramClientErrorHandler;
import org.kie.workbench.common.stunner.core.client.i18n.ClientTranslationService;
import org.kie.workbench.common.stunner.core.client.session.command.ClientSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.impl.EditorSession;
import org.kie.workbench.common.stunner.core.client.session.impl.ViewerSession;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.DiagramParsingException;
import org.kie.workbench.common.stunner.core.documentation.DocumentationView;
import org.kie.workbench.common.stunner.core.graph.processing.layout.LayoutExecutor;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;
import org.kie.workbench.common.stunner.core.validation.DiagramElementViolation;
import org.kie.workbench.common.stunner.forms.client.event.RefreshFormPropertiesEvent;
import org.kie.workbench.common.stunner.kogito.client.editor.AbstractDiagramEditorMenuSessionItems;
import org.kie.workbench.common.stunner.kogito.client.editor.event.OnDiagramFocusEvent;
import org.kie.workbench.common.stunner.kogito.client.editor.event.OnDiagramLoseFocusEvent;
import org.kie.workbench.common.stunner.project.client.editor.AbstractProjectDiagramEditor;
import org.kie.workbench.common.stunner.project.client.editor.AbstractProjectDiagramEditorCore;
import org.kie.workbench.common.stunner.project.client.editor.ProjectDiagramEditorProxy;
import org.kie.workbench.common.stunner.project.client.screens.ProjectMessagesListener;
import org.kie.workbench.common.stunner.project.client.service.ClientProjectDiagramService;
import org.kie.workbench.common.stunner.project.diagram.ProjectDiagram;
import org.kie.workbench.common.stunner.project.diagram.ProjectMetadata;
import org.kie.workbench.common.stunner.project.diagram.editor.ProjectDiagramResource;
import org.kie.workbench.common.stunner.project.service.ProjectDiagramResourceService;
import org.kie.workbench.common.widgets.client.search.common.EditorSearchIndex;
import org.kie.workbench.common.widgets.client.search.component.SearchBarComponent;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.client.annotations.WorkbenchEditor;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartTitleDecoration;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.views.pfly.multipage.MultiPageEditorSelectedPageEvent;
import org.uberfire.client.workbench.type.ClientResourceType;
import org.uberfire.client.workbench.widgets.common.ErrorPopupPresenter;
import org.uberfire.client.workbench.widgets.multipage.Page;
import org.uberfire.ext.editor.commons.client.menu.MenuItems;
import org.uberfire.ext.widgets.core.client.editors.texteditor.TextEditorView;
import org.uberfire.lifecycle.OnClose;
import org.uberfire.lifecycle.OnFocus;
import org.uberfire.lifecycle.OnLostFocus;
import org.uberfire.lifecycle.OnMayClose;
import org.uberfire.lifecycle.OnOpen;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.events.NotificationEvent;
import org.uberfire.workbench.model.menu.Menus;

@Dependent
@DiagramEditor
@WorkbenchEditor(identifier="DMNDiagramEditor", supportedTypes={DMNDiagramResourceType.class})
public class DMNDiagramEditor
extends AbstractProjectDiagramEditor<DMNDiagramResourceType> {
    public static final String EDITOR_ID = "DMNDiagramEditor";
    protected static final int DATA_TYPES_PAGE_INDEX = 2;
    private final SessionManager sessionManager;
    private final SessionCommandManager<AbstractCanvasHandler> sessionCommandManager;
    private final Event<RefreshFormPropertiesEvent> refreshFormPropertiesEvent;
    private final DecisionNavigatorDock decisionNavigatorDock;
    private final LayoutHelper layoutHelper;
    private final OpenDiagramLayoutExecutor openDiagramLayoutExecutor;
    private final DataTypesPage dataTypesPage;
    private final IncludedModelsPage includedModelsPage;
    private final IncludedModelsPageStateProviderImpl importsPageProvider;
    private final DMNEditorSearchIndex editorSearchIndex;
    private final SearchBarComponent<DMNSearchableElement> searchBarComponent;
    private final MonacoFEELInitializer feelInitializer;

    @Inject
    public DMNDiagramEditor(AbstractProjectDiagramEditor.View view, TextEditorView xmlEditorView, ManagedInstance<SessionEditorPresenter<EditorSession>> editorSessionPresenterInstances, ManagedInstance<SessionViewerPresenter<ViewerSession>> viewerSessionPresenterInstances, Event<OnDiagramFocusEvent> onDiagramFocusEvent, Event<OnDiagramLoseFocusEvent> onDiagramLostFocusEvent, Event<NotificationEvent> notificationEvent, ErrorPopupPresenter errorPopupPresenter, DiagramClientErrorHandler diagramClientErrorHandler, @DMNEditor DocumentationView documentationView, DMNDiagramResourceType resourceType, DMNEditorMenuSessionItems menuSessionItems, ProjectMessagesListener projectMessagesListener, ClientTranslationService translationService, ClientProjectDiagramService projectDiagramServices, Caller<ProjectDiagramResourceService> projectDiagramResourceServiceCaller, SessionManager sessionManager, SessionCommandManager<AbstractCanvasHandler> sessionCommandManager, Event<RefreshFormPropertiesEvent> refreshFormPropertiesEvent, DecisionNavigatorDock decisionNavigatorDock, LayoutHelper layoutHelper, OpenDiagramLayoutExecutor openDiagramLayoutExecutor, DataTypesPage dataTypesPage, IncludedModelsPage includedModelsPage, IncludedModelsPageStateProviderImpl importsPageProvider, DMNEditorSearchIndex editorSearchIndex, SearchBarComponent<DMNSearchableElement> searchBarComponent, MonacoFEELInitializer feelInitializer) {
        super(view, xmlEditorView, editorSessionPresenterInstances, viewerSessionPresenterInstances, onDiagramFocusEvent, onDiagramLostFocusEvent, notificationEvent, errorPopupPresenter, diagramClientErrorHandler, documentationView, (ClientResourceType)resourceType, (AbstractDiagramEditorMenuSessionItems)menuSessionItems, projectMessagesListener, translationService, projectDiagramServices, projectDiagramResourceServiceCaller);
        this.sessionManager = sessionManager;
        this.sessionCommandManager = sessionCommandManager;
        this.refreshFormPropertiesEvent = refreshFormPropertiesEvent;
        this.decisionNavigatorDock = decisionNavigatorDock;
        this.layoutHelper = layoutHelper;
        this.openDiagramLayoutExecutor = openDiagramLayoutExecutor;
        this.dataTypesPage = dataTypesPage;
        this.includedModelsPage = includedModelsPage;
        this.importsPageProvider = importsPageProvider;
        this.editorSearchIndex = editorSearchIndex;
        this.searchBarComponent = searchBarComponent;
        this.feelInitializer = feelInitializer;
    }

    @PostConstruct
    public void init() {
        super.init();
        this.getMenuSessionItems().setErrorConsumer(e -> this.hideLoadingViews());
        this.editorSearchIndex.setCurrentAssetHashcodeSupplier(this.getGetCurrentContentHashSupplier());
        this.editorSearchIndex.setIsDataTypesTabActiveSupplier(this.getIsDataTypesTabActiveSupplier());
        this.feelInitializer.initializeFEELEditor();
    }

    protected AbstractProjectDiagramEditorCore<ProjectMetadata, ProjectDiagram, ProjectDiagramResource, ProjectDiagramEditorProxy<ProjectDiagramResource>> makeCore(AbstractProjectDiagramEditor.View view, TextEditorView xmlEditorView, Event<NotificationEvent> notificationEvent, ManagedInstance<SessionEditorPresenter<EditorSession>> editorSessionPresenterInstances, ManagedInstance<SessionViewerPresenter<ViewerSession>> viewerSessionPresenterInstances, AbstractDiagramEditorMenuSessionItems<?> menuSessionItems, ErrorPopupPresenter errorPopupPresenter, DiagramClientErrorHandler diagramClientErrorHandler, ClientTranslationService translationService) {
        return new AbstractProjectDiagramEditor.ProjectDiagramEditorCore(view, xmlEditorView, notificationEvent, editorSessionPresenterInstances, viewerSessionPresenterInstances, menuSessionItems, errorPopupPresenter, diagramClientErrorHandler, translationService){

            protected ClientSessionCommand.Callback<Collection<DiagramElementViolation<RuleViolation>>> getSaveAfterValidationCallback(final Command continueSaveOnceValid) {
                return new ClientSessionCommand.Callback<Collection<DiagramElementViolation<RuleViolation>>>(){

                    public void onSuccess() {
                        continueSaveOnceValid.execute();
                    }

                    public void onError(Collection<DiagramElementViolation<RuleViolation>> violations) {
                        continueSaveOnceValid.execute();
                    }
                };
            }
        };
    }

    @OnStartup
    public void onStartup(ObservablePath path, PlaceRequest place) {
        this.superDoStartUp(path, place);
        this.decisionNavigatorDock.init("LibraryPerspective");
    }

    protected String getDiagramParsingErrorMessage(DiagramParsingException e) {
        return this.getTranslationService().getValue("DMNDiagramParsingErrorMessage");
    }

    public void initialiseKieEditorForSession(ProjectDiagram diagram) {
        this.superInitialiseKieEditorForSession(diagram);
        this.kieView.getMultiPage().addPage((Page)this.dataTypesPage);
        this.kieView.getMultiPage().addPage((Page)this.includedModelsPage);
        this.kieView.addOverviewPage(this.overviewWidget, () -> this.overviewWidget.refresh(this.versionRecordManager.getVersion()));
        this.setupSearchComponent();
    }

    void superInitialiseKieEditorForSession(ProjectDiagram diagram) {
        super.initialiseKieEditorForSession(diagram);
    }

    protected void resetEditorPages(Overview overview) {
        this.overviewWidget.setContent(overview, this.versionRecordManager.getPathToLatest());
        this.resetMetadata(overview);
        this.kieView.clear();
        this.kieView.addMainEditorPage((IsWidget)this.baseView);
    }

    protected void resetEditorPagesOnLoadError(Overview overview) {
        super.resetEditorPages(overview);
    }

    public void showDocks() {
        super.showDocks();
        this.decisionNavigatorDock.open();
    }

    public Annotation[] getDockQualifiers() {
        return new Annotation[]{new Annotation(){

            @Override
            public Class<? extends Annotation> annotationType() {
                return DMNEditor.class;
            }
        }};
    }

    public void hideDocks() {
        super.hideDocks();
        this.decisionNavigatorDock.close();
        this.decisionNavigatorDock.resetContent();
    }

    public void onMultiPageEditorSelectedPageEvent(@Observes MultiPageEditorSelectedPageEvent event) {
        if (this.isSameSession()) {
            this.searchBarComponent.disableSearch();
        }
    }

    public void onRefreshFormPropertiesEvent(@Observes RefreshFormPropertiesEvent event) {
        this.searchBarComponent.disableSearch();
    }

    Supplier<Boolean> getIsDataTypesTabActiveSupplier() {
        return () -> {
            int selectedPageIndex = this.kieView.getMultiPage().selectedPage();
            return selectedPageIndex == 2;
        };
    }

    Supplier<Integer> getGetCurrentContentHashSupplier() {
        return () -> ((DMNDiagramEditor)this).getCurrentContentHash();
    }

    void setupSearchComponent() {
        HTMLElement element = this.searchBarComponent.getView().getElement();
        this.searchBarComponent.init((EditorSearchIndex)this.editorSearchIndex);
        this.kieView.getMultiPage().addTabBarWidget(this.getWidget(element));
    }

    public void onDataTypePageNavTabActiveEvent(@Observes DataTypePageTabActiveEvent event) {
        this.kieView.getMultiPage().selectPage(2);
    }

    public void open(ProjectDiagram diagram) {
        this.layoutHelper.applyLayout((Diagram)diagram, (LayoutExecutor)this.openDiagramLayoutExecutor);
        super.open(diagram);
    }

    @OnOpen
    public void onOpen() {
        super.doOpen();
    }

    @OnClose
    public void onClose() {
        this.superDoClose();
        this.dataTypesPage.disableShortcuts();
        super.onClose();
    }

    public void onDiagramLoad() {
        Optional<CanvasHandler> canvasHandler = Optional.ofNullable(this.getCanvasHandler());
        canvasHandler.ifPresent(c -> {
            ExpressionEditorView.Presenter expressionEditor = ((DMNSession)this.sessionManager.getCurrentSession()).getExpressionEditor();
            expressionEditor.setToolbarStateHandler((ToolbarStateHandler)new DMNProjectToolbarStateHandler(this.getMenuSessionItems()));
            this.decisionNavigatorDock.setupCanvasHandler(c);
            this.dataTypesPage.reload();
            this.includedModelsPage.setup(this.importsPageProvider.withDiagram(c.getDiagram()));
        });
    }

    @OnFocus
    public void onFocus() {
        this.superDoFocus();
        this.onDiagramLoad();
        this.dataTypesPage.onFocus();
        this.dataTypesPage.enableShortcuts();
    }

    @OnLostFocus
    public void onLostFocus() {
        super.doLostFocus();
        this.dataTypesPage.onLostFocus();
    }

    @WorkbenchPartTitleDecoration
    public IsWidget getTitle() {
        return super.getTitle();
    }

    @WorkbenchPartTitle
    public String getTitleText() {
        return super.getTitleText();
    }

    @WorkbenchMenu
    public void getMenus(Consumer<Menus> menusConsumer) {
        super.getMenus(menusConsumer);
    }

    @WorkbenchPartView
    public IsWidget getWidget() {
        return super.getWidget();
    }

    @OnMayClose
    public boolean onMayClose() {
        return super.mayClose(Integer.valueOf(this.getCurrentDiagramHash()));
    }

    public String getEditorIdentifier() {
        return EDITOR_ID;
    }

    public void onDataTypeEditModeToggle(@Observes DataTypeEditModeToggleEvent event) {
        DomGlobal.setTimeout((DomGlobal.SetTimeoutCallbackFn)this.getOnDataTypeEditModeToggleCallback(event), (double)250.0, (Object[])new Object[0]);
    }

    DomGlobal.SetTimeoutCallbackFn getOnDataTypeEditModeToggleCallback(DataTypeEditModeToggleEvent event) {
        return e -> {
            if (event.isEditModeEnabled()) {
                this.disableMenuItem(MenuItems.SAVE);
            } else {
                this.enableMenuItem(MenuItems.SAVE);
            }
        };
    }

    void onEditExpressionEvent(@Observes EditExpressionEvent event) {
        this.searchBarComponent.disableSearch();
        if (this.isSameSession(event.getSession())) {
            DMNSession session = (DMNSession)this.sessionManager.getCurrentSession();
            ExpressionEditorView.Presenter expressionEditor = session.getExpressionEditor();
            this.sessionCommandManager.execute((Object)session.getCanvasHandler(), (org.kie.workbench.common.stunner.core.command.Command)new NavigateToExpressionEditorCommand(expressionEditor, this.getSessionPresenter(), this.sessionManager, this.sessionCommandManager, this.refreshFormPropertiesEvent, event.getNodeUUID(), event.getHasExpression(), event.getHasName(), event.isOnlyVisualChangeAllowed()));
        }
    }

    void superDoFocus() {
        super.doFocus();
    }

    void superDoClose() {
        super.doClose();
    }

    void superDoStartUp(ObservablePath path, PlaceRequest place) {
        super.doStartUp(path, place);
    }

    ElementWrapperWidget<?> getWidget(HTMLElement element) {
        return ElementWrapperWidget.getWidget((HTMLElement)element);
    }

    private boolean isSameSession() {
        return this.isSameSession(this.sessionManager.getCurrentSession());
    }
}

