/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.project.client.editor;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.widgets.toolbar.DMNPerformAutomaticLayoutCommand;
import org.kie.workbench.common.dmn.project.client.editor.DMNEditorMenuItemsBuilder;
import org.kie.workbench.common.dmn.project.client.editor.DMNEditorMenuSessionItems;
import org.kie.workbench.common.dmn.project.client.session.DMNEditorSessionCommands;
import org.kie.workbench.common.stunner.core.client.session.command.impl.ClearSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.impl.CopySelectionSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.impl.CutSelectionSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.impl.DeleteSelectionSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.impl.ExportToJpgSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.impl.ExportToPdfSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.impl.ExportToPngSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.impl.ExportToRawFormatSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.impl.ExportToSvgSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.impl.PasteSelectionSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.impl.RedoSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.impl.SwitchGridSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.impl.UndoSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.impl.ValidateSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.impl.VisitGraphSessionCommand;
import org.kie.workbench.common.widgets.client.menu.FileMenuBuilder;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.workbench.model.menu.MenuItem;

@RunWith(value=GwtMockitoTestRunner.class)
public class DMNEditorMenuSessionItemsTest {
    @Mock
    private FileMenuBuilder fileMenuBuilder;
    @Mock
    private DMNEditorMenuItemsBuilder builder;
    @Mock
    private DMNEditorSessionCommands sessionCommands;
    @Mock
    private PlaceManager placeManager;

    @Test
    public void testPopulateMenu() {
        DMNEditorMenuSessionItems menuItems = (DMNEditorMenuSessionItems)Mockito.spy((Object)new DMNEditorMenuSessionItems(this.builder, this.sessionCommands, this.placeManager));
        MenuItem menuItem = (MenuItem)Mockito.mock(MenuItem.class);
        ((DMNEditorMenuSessionItems)Mockito.doNothing().when((Object)menuItems)).superPopulateMenu((FileMenuBuilder)Matchers.any());
        ((DMNEditorMenuSessionItems)Mockito.doReturn((Object)menuItem).when((Object)menuItems)).newPerformAutomaticLayout();
        menuItems.populateMenu(this.fileMenuBuilder);
        ((DMNEditorMenuSessionItems)Mockito.verify((Object)menuItems)).addPerformAutomaticLayout((FileMenuBuilder)Matchers.any());
    }

    @Test
    public void testEnableMenu() {
        this.testMenu(true);
    }

    @Test
    public void testDisableMenu() {
        this.testMenu(false);
    }

    private void testMenu(boolean enabled) {
        DMNEditorMenuSessionItems menuItems = (DMNEditorMenuSessionItems)Mockito.spy((Object)new DMNEditorMenuSessionItems(this.builder, this.sessionCommands, this.placeManager));
        menuItems.setEnabled(enabled);
        ((DMNEditorMenuSessionItems)Mockito.verify((Object)menuItems)).setItemEnabled(ClearSessionCommand.class, enabled);
        ((DMNEditorMenuSessionItems)Mockito.verify((Object)menuItems)).setItemEnabled(VisitGraphSessionCommand.class, enabled);
        ((DMNEditorMenuSessionItems)Mockito.verify((Object)menuItems)).setItemEnabled(SwitchGridSessionCommand.class, enabled);
        ((DMNEditorMenuSessionItems)Mockito.verify((Object)menuItems)).setItemEnabled(ValidateSessionCommand.class, enabled);
        ((DMNEditorMenuSessionItems)Mockito.verify((Object)menuItems)).setItemEnabled(ExportToJpgSessionCommand.class, enabled);
        ((DMNEditorMenuSessionItems)Mockito.verify((Object)menuItems)).setItemEnabled(ExportToPngSessionCommand.class, enabled);
        ((DMNEditorMenuSessionItems)Mockito.verify((Object)menuItems)).setItemEnabled(ExportToSvgSessionCommand.class, enabled);
        ((DMNEditorMenuSessionItems)Mockito.verify((Object)menuItems)).setItemEnabled(ExportToPdfSessionCommand.class, enabled);
        ((DMNEditorMenuSessionItems)Mockito.verify((Object)menuItems)).setItemEnabled(ExportToRawFormatSessionCommand.class, enabled);
        ((DMNEditorMenuSessionItems)Mockito.verify((Object)menuItems)).setItemEnabled(DeleteSelectionSessionCommand.class, false);
        ((DMNEditorMenuSessionItems)Mockito.verify((Object)menuItems)).setItemEnabled(UndoSessionCommand.class, false);
        ((DMNEditorMenuSessionItems)Mockito.verify((Object)menuItems)).setItemEnabled(RedoSessionCommand.class, false);
        ((DMNEditorMenuSessionItems)Mockito.verify((Object)menuItems)).setItemEnabled(CopySelectionSessionCommand.class, false);
        ((DMNEditorMenuSessionItems)Mockito.verify((Object)menuItems)).setItemEnabled(CutSelectionSessionCommand.class, false);
        ((DMNEditorMenuSessionItems)Mockito.verify((Object)menuItems)).setItemEnabled(PasteSelectionSessionCommand.class, false);
        ((DMNEditorMenuSessionItems)Mockito.verify((Object)menuItems)).setItemEnabled(DMNPerformAutomaticLayoutCommand.class, enabled);
    }
}

