/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.project.client.editor;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Collection;
import java.util.HashSet;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.project.client.editor.DMNEditorMenuItemsBuilder;
import org.kie.workbench.common.dmn.project.client.editor.DMNEditorMenuSessionItems;
import org.kie.workbench.common.dmn.project.client.session.DMNEditorSessionCommands;
import org.kie.workbench.common.stunner.core.client.session.command.ClientSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.impl.ValidateSessionCommand;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;
import org.kie.workbench.common.stunner.core.validation.DiagramElementViolation;
import org.kie.workbench.common.widgets.client.menu.FileMenuBuilder;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.model.menu.MenuItem;

@RunWith(value=GwtMockitoTestRunner.class)
public class DMNEditorMenuSessionItemsValidateTest {
    @Mock
    private DMNEditorMenuItemsBuilder builder;
    @Mock
    private DMNEditorSessionCommands sessionCommands;
    @Mock
    private ValidateSessionCommand validateSessionCommand;
    @Mock
    private PlaceManager placeManager;
    @Captor
    private ArgumentCaptor<Command> validateItemArgumentCaptor;
    @Captor
    private ArgumentCaptor<ClientSessionCommand.Callback<Collection<DiagramElementViolation<RuleViolation>>>> violationsArgumentCapture;
    private DMNEditorMenuSessionItems menuItems;

    @Before
    public void setUp() {
        this.menuItems = new DMNEditorMenuSessionItems(this.builder, this.sessionCommands, this.placeManager){

            MenuItem newPerformAutomaticLayout() {
                return (MenuItem)Mockito.mock(MenuItem.class);
            }
        };
        FileMenuBuilder fileMenuBuilder = (FileMenuBuilder)Mockito.mock(FileMenuBuilder.class);
        ((FileMenuBuilder)Mockito.doReturn((Object)fileMenuBuilder).when((Object)fileMenuBuilder)).addNewTopLevelMenu((MenuItem)Matchers.any());
        this.menuItems.populateMenu(fileMenuBuilder);
        ((DMNEditorMenuItemsBuilder)Mockito.verify((Object)this.builder)).newValidateItem((Command)this.validateItemArgumentCaptor.capture());
        ((DMNEditorSessionCommands)Mockito.doReturn((Object)this.validateSessionCommand).when((Object)this.sessionCommands)).getValidateSessionCommand();
        ((Command)this.validateItemArgumentCaptor.getValue()).execute();
        ((ValidateSessionCommand)Mockito.verify((Object)this.validateSessionCommand)).execute((ClientSessionCommand.Callback)this.violationsArgumentCapture.capture());
    }

    @Test
    public void openAlertsPanelAfterSuccess() {
        ((PlaceManager)Mockito.verify((Object)this.placeManager, (VerificationMode)Mockito.never())).goTo("org.kie.workbench.common.screens.messageconsole.MessageConsole");
        ((ClientSessionCommand.Callback)this.violationsArgumentCapture.getValue()).onSuccess();
        ((PlaceManager)Mockito.verify((Object)this.placeManager)).goTo("org.kie.workbench.common.screens.messageconsole.MessageConsole");
    }

    @Test
    public void openAlertsPanelAfterFailure() {
        ((PlaceManager)Mockito.verify((Object)this.placeManager, (VerificationMode)Mockito.never())).goTo("org.kie.workbench.common.screens.messageconsole.MessageConsole");
        ((ClientSessionCommand.Callback)this.violationsArgumentCapture.getValue()).onError(new HashSet());
        ((PlaceManager)Mockito.verify((Object)this.placeManager)).goTo("org.kie.workbench.common.screens.messageconsole.MessageConsole");
    }
}

