/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.project.client.docks;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Collection;
import java.util.Iterator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.project.client.docks.DMNDockSupplierImpl;
import org.kie.workbench.common.workbench.client.resources.i18n.DefaultWorkbenchConstants;
import org.uberfire.client.workbench.docks.UberfireDock;
import org.uberfire.client.workbench.docks.UberfireDockPosition;

@RunWith(value=GwtMockitoTestRunner.class)
public class DMNDockSupplierImplTest {
    private static final String PERSPECTIVE_ID = "perspectiveId";
    private DMNDockSupplierImpl supplier;

    @Before
    public void setup() {
        this.supplier = new DMNDockSupplierImpl();
    }

    @Test
    public void testDocks() {
        Collection docks = this.supplier.getDocks(PERSPECTIVE_ID);
        Assert.assertEquals((long)2L, (long)docks.size());
        Iterator docksIterator = docks.iterator();
        UberfireDock dock1 = (UberfireDock)docksIterator.next();
        UberfireDock dock2 = (UberfireDock)docksIterator.next();
        this.assertDock(dock1, "PENCIL_SQUARE_O", "DiagramEditorPropertiesScreen", DefaultWorkbenchConstants.INSTANCE.DocksStunnerPropertiesTitle());
        this.assertDock(dock2, "EYE", "DMNProjectDiagramExplorerScreen", DefaultWorkbenchConstants.INSTANCE.DocksStunnerExplorerTitle());
    }

    private void assertDock(UberfireDock dock, String iconType, String identifier, String label) {
        Assert.assertEquals((Object)UberfireDockPosition.EAST, (Object)dock.getDockPosition());
        Assert.assertEquals((Object)iconType, (Object)dock.getIconType());
        Assert.assertEquals((Object)identifier, (Object)dock.getPlaceRequest().getIdentifier());
        Assert.assertEquals((Object)PERSPECTIVE_ID, (Object)dock.getAssociatedPerspective());
        Assert.assertEquals((Object)label, (Object)dock.getLabel());
    }
}

