/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.project.client.editor;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import com.google.gwtmockito.WithClassesToStub;
import elemental2.dom.HTMLElement;
import java.lang.annotation.Annotation;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.enterprise.event.Event;
import org.guvnor.common.services.shared.metadata.model.Overview;
import org.jboss.errai.common.client.ui.ElementWrapperWidget;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.qualifiers.DMNEditor;
import org.kie.workbench.common.dmn.client.commands.general.NavigateToExpressionEditorCommand;
import org.kie.workbench.common.dmn.client.docks.navigator.DecisionNavigatorDock;
import org.kie.workbench.common.dmn.client.docks.navigator.common.LazyCanvasFocusUtils;
import org.kie.workbench.common.dmn.client.docks.navigator.drds.DMNDiagramsSession;
import org.kie.workbench.common.dmn.client.editors.drd.DRDNameChanger;
import org.kie.workbench.common.dmn.client.editors.expressions.ExpressionEditorView;
import org.kie.workbench.common.dmn.client.editors.included.IncludedModelsPage;
import org.kie.workbench.common.dmn.client.editors.search.DMNEditorSearchIndex;
import org.kie.workbench.common.dmn.client.editors.search.DMNSearchableElement;
import org.kie.workbench.common.dmn.client.editors.toolbar.ToolbarStateHandler;
import org.kie.workbench.common.dmn.client.editors.types.DataTypePageTabActiveEvent;
import org.kie.workbench.common.dmn.client.editors.types.DataTypesPage;
import org.kie.workbench.common.dmn.client.editors.types.listview.common.DataTypeEditModeToggleEvent;
import org.kie.workbench.common.dmn.client.events.EditExpressionEvent;
import org.kie.workbench.common.dmn.client.session.DMNEditorSession;
import org.kie.workbench.common.dmn.client.widgets.codecompletion.MonacoFEELInitializer;
import org.kie.workbench.common.dmn.project.client.editor.DMNDiagramEditor;
import org.kie.workbench.common.dmn.project.client.editor.DMNEditorMenuSessionItems;
import org.kie.workbench.common.dmn.project.client.editor.DMNProjectToolbarStateHandler;
import org.kie.workbench.common.dmn.project.client.type.DMNDiagramResourceType;
import org.kie.workbench.common.stunner.client.widgets.presenters.session.SessionPresenter;
import org.kie.workbench.common.stunner.client.widgets.presenters.session.impl.SessionEditorPresenter;
import org.kie.workbench.common.stunner.client.widgets.presenters.session.impl.SessionViewerPresenter;
import org.kie.workbench.common.stunner.core.client.ReadOnlyProvider;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.core.client.components.layout.LayoutHelper;
import org.kie.workbench.common.stunner.core.client.components.layout.OpenDiagramLayoutExecutor;
import org.kie.workbench.common.stunner.core.client.error.DiagramClientErrorHandler;
import org.kie.workbench.common.stunner.core.client.i18n.ClientTranslationService;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;
import org.kie.workbench.common.stunner.core.client.session.impl.EditorSession;
import org.kie.workbench.common.stunner.core.client.session.impl.ViewerSession;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.documentation.DocumentationPage;
import org.kie.workbench.common.stunner.core.graph.processing.layout.LayoutExecutor;
import org.kie.workbench.common.stunner.forms.client.event.RefreshFormPropertiesEvent;
import org.kie.workbench.common.stunner.kogito.client.editor.AbstractDiagramEditorMenuSessionItems;
import org.kie.workbench.common.stunner.project.client.editor.AbstractProjectDiagramEditor;
import org.kie.workbench.common.stunner.project.client.editor.AbstractProjectDiagramEditorCore;
import org.kie.workbench.common.stunner.project.client.editor.AbstractProjectDiagramEditorTest;
import org.kie.workbench.common.stunner.project.client.editor.ProjectDiagramEditorProxy;
import org.kie.workbench.common.stunner.project.diagram.ProjectDiagram;
import org.kie.workbench.common.stunner.project.diagram.ProjectMetadata;
import org.kie.workbench.common.stunner.project.diagram.editor.ProjectDiagramResource;
import org.kie.workbench.common.widgets.client.docks.DefaultEditorDock;
import org.kie.workbench.common.widgets.client.search.common.EditorSearchIndex;
import org.kie.workbench.common.widgets.client.search.component.SearchBarComponent;
import org.kie.workbench.common.widgets.metadata.client.KieEditorWrapperView;
import org.kie.workbench.common.widgets.metadata.client.widget.OverviewWidgetPresenter;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.InOrder;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.views.pfly.multipage.MultiPageEditorSelectedPageEvent;
import org.uberfire.client.workbench.widgets.common.ErrorPopupPresenter;
import org.uberfire.client.workbench.widgets.multipage.MultiPageEditor;
import org.uberfire.client.workbench.widgets.multipage.Page;
import org.uberfire.ext.editor.commons.client.menu.MenuItems;
import org.uberfire.ext.widgets.core.client.editors.texteditor.TextEditorView;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.PathPlaceRequest;
import org.uberfire.workbench.events.NotificationEvent;

@RunWith(value=GwtMockitoTestRunner.class)
@WithClassesToStub(value={PathPlaceRequest.class})
public class DMNDiagramEditorTest
extends AbstractProjectDiagramEditorTest {
    @Mock
    private PlaceRequest currentPlace;
    @Mock
    private AbstractCanvasHandler canvasHandler;
    @Mock
    private SessionManager sessionManager;
    @Mock
    private DMNEditorSession dmnEditorSession;
    @Mock
    private DMNEditorSession defaultEditorSession;
    @Mock
    private SessionCommandManager<AbstractCanvasHandler> sessionCommandManager;
    @Mock
    private EventSourceMock<RefreshFormPropertiesEvent> refreshFormPropertiesEvent;
    @Mock
    private ExpressionEditorView.Presenter expressionEditor;
    @Mock
    private DecisionNavigatorDock decisionNavigatorDock;
    @Mock
    private EditExpressionEvent editExpressionEvent;
    @Mock
    private DMNEditorMenuSessionItems dmnProjectMenuSessionItems;
    @Mock
    private LayoutHelper layoutHelper;
    @Mock
    private OpenDiagramLayoutExecutor layoutExecutor;
    @Mock
    private DataTypesPage dataTypesPage;
    @Mock
    private IncludedModelsPage includedModelsPage;
    @Mock
    private MultiPageEditor multiPage;
    private DMNDiagramEditor diagramEditor;
    @Mock
    private DefaultEditorDock docks;
    @Mock
    private DMNEditorSearchIndex editorSearchIndex;
    @Mock
    private SearchBarComponent<DMNSearchableElement> searchBarComponent;
    @Mock
    private SearchBarComponent.View searchBarComponentView;
    @Mock
    private HTMLElement searchBarComponentViewElement;
    @Mock
    private MonacoFEELInitializer feelInitializer;
    @Mock
    private ElementWrapperWidget searchBarComponentWidget;
    @Mock
    private ReadOnlyProvider readOnlyProvider;
    @Mock
    private HTMLElement drdNameChangerElement;
    @Mock
    private DRDNameChanger drdNameChanger;
    @Mock
    private LazyCanvasFocusUtils lazyCanvasFocusUtils;
    @Mock
    private ElementWrapperWidget drdNameWidget;
    @Mock
    private DMNDiagramsSession dmnDiagramsSession;
    @Captor
    private ArgumentCaptor<Consumer<String>> errorConsumerCaptor;

    @Before
    public void before() {
        Mockito.when((Object)this.kieView.getMultiPage()).thenReturn((Object)this.multiPage);
    }

    public void setUp() {
        super.setUp();
        Mockito.when((Object)this.sessionManager.getCurrentSession()).thenReturn((Object)this.dmnEditorSession);
        Mockito.when((Object)this.sessionEditorPresenter.getInstance()).thenReturn((Object)this.dmnEditorSession);
        Mockito.when((Object)this.dmnEditorSession.getExpressionEditor()).thenReturn((Object)this.expressionEditor);
        Mockito.when((Object)this.dmnEditorSession.getCanvasHandler()).thenReturn((Object)this.canvasHandler);
        Mockito.when((Object)this.canvasHandler.getDiagram()).thenReturn((Object)this.diagram);
        Mockito.when((Object)this.searchBarComponent.getView()).thenReturn((Object)this.searchBarComponentView);
        Mockito.when((Object)this.searchBarComponentView.getElement()).thenReturn((Object)this.searchBarComponentViewElement);
        Mockito.when((Object)this.drdNameChanger.getElement()).thenReturn((Object)this.drdNameChangerElement);
        ((DMNDiagramEditor)Mockito.doReturn((Object)this.drdNameWidget).when((Object)this.diagramEditor)).getWidget(this.drdNameChangerElement);
    }

    protected DMNDiagramResourceType mockResourceType() {
        DMNDiagramResourceType resourceType = (DMNDiagramResourceType)Mockito.mock(DMNDiagramResourceType.class);
        Mockito.when((Object)resourceType.getSuffix()).thenReturn((Object)"dmn");
        Mockito.when((Object)resourceType.getShortName()).thenReturn((Object)"DMN");
        return resourceType;
    }

    protected AbstractProjectDiagramEditor createDiagramEditor() {
        this.diagramEditor = (DMNDiagramEditor)Mockito.spy((Object)new DMNDiagramEditor(this.view, this.xmlEditorView, this.sessionEditorPresenters, this.sessionViewerPresenters, (Event)this.onDiagramFocusEvent, (Event)this.onDiagramLostFocusEvent, (Event)this.notificationEvent, this.errorPopupPresenter, this.diagramClientErrorHandler, this.documentationView, (DMNDiagramResourceType)this.getResourceType(), (DMNEditorMenuSessionItems)this.getMenuSessionItems(), this.projectMessagesListener, this.translationService, this.clientProjectDiagramService, this.projectDiagramResourceServiceCaller, this.sessionManager, (SessionCommandManager)this.sessionCommandManager, (Event)this.refreshFormPropertiesEvent, this.decisionNavigatorDock, this.layoutHelper, this.layoutExecutor, this.dataTypesPage, this.includedModelsPage, this.editorSearchIndex, (SearchBarComponent)this.searchBarComponent, this.feelInitializer, this.readOnlyProvider, this.drdNameChanger, this.lazyCanvasFocusUtils, this.dmnDiagramsSession){
            {
                this.docks = DMNDiagramEditorTest.this.docks;
                this.fileMenuBuilder = DMNDiagramEditorTest.this.fileMenuBuilder;
                this.workbenchContext = DMNDiagramEditorTest.this.workbenchContext;
                this.projectController = DMNDiagramEditorTest.this.projectController;
                this.versionRecordManager = DMNDiagramEditorTest.this.versionRecordManager;
                DMNDiagramEditorTest.this.sessionEditorPresenters = DMNDiagramEditorTest.this.sessionEditorPresenters;
                this.alertsButtonMenuItemBuilder = DMNDiagramEditorTest.this.alertsButtonMenuItemBuilder;
                this.kieView = DMNDiagramEditorTest.this.kieView;
                this.overviewWidget = DMNDiagramEditorTest.this.overviewWidget;
                this.notification = DMNDiagramEditorTest.this.notificationEvent;
                this.placeManager = DMNDiagramEditorTest.this.placeManager;
                this.changeTitleNotification = DMNDiagramEditorTest.this.changeTitleNotificationEvent;
                this.savePopUpPresenter = DMNDiagramEditorTest.this.savePopUpPresenter;
            }

            protected AbstractProjectDiagramEditorCore<ProjectMetadata, ProjectDiagram, ProjectDiagramResource, ProjectDiagramEditorProxy<ProjectDiagramResource>> makeCore(AbstractProjectDiagramEditor.View view, TextEditorView xmlEditorView, Event<NotificationEvent> notificationEvent, ManagedInstance<SessionEditorPresenter<EditorSession>> editorSessionPresenterInstances, ManagedInstance<SessionViewerPresenter<ViewerSession>> viewerSessionPresenterInstances, AbstractDiagramEditorMenuSessionItems<?> menuSessionItems, ErrorPopupPresenter errorPopupPresenter, DiagramClientErrorHandler diagramClientErrorHandler, ClientTranslationService translationService) {
                DMNDiagramEditorTest.this.presenterCore = (AbstractProjectDiagramEditorCore)Mockito.spy((Object)super.makeCore(view, xmlEditorView, notificationEvent, editorSessionPresenterInstances, viewerSessionPresenterInstances, menuSessionItems, errorPopupPresenter, diagramClientErrorHandler, translationService));
                this.saveAndRenameCommandBuilder = DMNDiagramEditorTest.this.saveAndRenameCommandBuilderMock;
                return DMNDiagramEditorTest.this.presenterCore;
            }

            public boolean isReadOnly() {
                return DMNDiagramEditorTest.this.isReadOnly;
            }

            ElementWrapperWidget<?> getWidget(HTMLElement element) {
                return DMNDiagramEditorTest.this.searchBarComponentWidget;
            }

            public SessionPresenter<? extends ClientSession, ?, Diagram> getSessionPresenter() {
                return DMNDiagramEditorTest.this.sessionViewerPresenter;
            }
        });
        return this.diagramEditor;
    }

    protected AbstractDiagramEditorMenuSessionItems getMenuSessionItems() {
        return this.dmnProjectMenuSessionItems;
    }

    @Test
    public void testInit() {
        Supplier<Boolean> isDataTypesTabActiveSupplier = () -> true;
        Supplier<Integer> currentContentHashSupplier = () -> 123;
        ((DMNDiagramEditor)Mockito.doReturn(isDataTypesTabActiveSupplier).when((Object)this.diagramEditor)).getIsDataTypesTabActiveSupplier();
        ((DMNDiagramEditor)Mockito.doReturn(currentContentHashSupplier).when((Object)this.diagramEditor)).getGetCurrentContentHashSupplier();
        this.diagramEditor.init();
        ((DMNEditorMenuSessionItems)Mockito.verify((Object)this.dmnProjectMenuSessionItems, (VerificationMode)Mockito.atLeast((int)1))).setErrorConsumer((Consumer)this.errorConsumerCaptor.capture());
        ((Consumer)this.errorConsumerCaptor.getValue()).accept("ERROR");
        ((AbstractProjectDiagramEditor.View)Mockito.verify((Object)this.view)).hideBusyIndicator();
        ((ErrorPopupPresenter)Mockito.verify((Object)this.errorPopupPresenter, (VerificationMode)Mockito.never())).showMessage(Matchers.anyString());
        ((DMNEditorSearchIndex)Mockito.verify((Object)this.editorSearchIndex)).setIsDataTypesTabActiveSupplier(isDataTypesTabActiveSupplier);
        ((DMNEditorSearchIndex)Mockito.verify((Object)this.editorSearchIndex)).setCurrentAssetHashcodeSupplier(currentContentHashSupplier);
    }

    @Test
    public void testGetIsDataTypesTabActiveSupplierWhenDataTypesTabIsActive() {
        Mockito.when((Object)this.multiPage.selectedPage()).thenReturn((Object)2);
        Assert.assertTrue((boolean)((Boolean)this.diagramEditor.getIsDataTypesTabActiveSupplier().get()));
    }

    @Test
    public void testGetIsDataTypesTabActiveSupplierWhenDataTypesTabIsNotActive() {
        Mockito.when((Object)this.multiPage.selectedPage()).thenReturn((Object)3);
        Assert.assertFalse((boolean)((Boolean)this.diagramEditor.getIsDataTypesTabActiveSupplier().get()));
    }

    @Test
    public void testOnStartup() {
        ((DMNDiagramEditor)Mockito.doNothing().when((Object)this.diagramEditor)).superDoStartUp(this.filePath, this.currentPlace);
        this.diagramEditor.onStartup(this.filePath, this.currentPlace);
        ((DMNDiagramEditor)Mockito.verify((Object)this.diagramEditor)).superDoStartUp(this.filePath, this.currentPlace);
        ((DecisionNavigatorDock)Mockito.verify((Object)this.decisionNavigatorDock)).init("LibraryPerspective");
    }

    @Test
    public void testOnClose() {
        ((DMNDiagramEditor)Mockito.doNothing().when((Object)this.diagramEditor)).superDoClose();
        this.diagramEditor.onClose();
        ((DMNDiagramEditor)Mockito.verify((Object)this.diagramEditor)).superDoClose();
        ((DataTypesPage)Mockito.verify((Object)this.dataTypesPage)).disableShortcuts();
        ((KieEditorWrapperView)Mockito.verify((Object)this.kieView)).clear();
    }

    @Test
    public void testInitialiseKieEditorForSession() {
        ((DMNDiagramEditor)Mockito.doNothing().when((Object)this.diagramEditor)).superInitialiseKieEditorForSession((ProjectDiagram)Matchers.any());
        this.diagramEditor.initialiseKieEditorForSession(this.diagram);
        ((MultiPageEditor)Mockito.verify((Object)this.multiPage)).addPage((Page)this.dataTypesPage);
        ((MultiPageEditor)Mockito.verify((Object)this.multiPage)).addPage((Page)this.includedModelsPage);
        ((DMNDiagramEditor)Mockito.verify((Object)this.diagramEditor)).setupSearchComponent();
    }

    @Test
    public void testInitialiseKieEditorForSessionWhenInitializingKieEditorForSessionThenDiagramAlreadyLoaded() {
        ((DMNDiagramEditor)Mockito.doNothing().when((Object)this.diagramEditor)).superInitialiseKieEditorForSession((ProjectDiagram)Matchers.any());
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.diagramEditor});
        this.diagramEditor.initialiseKieEditorForSession(this.diagram);
        ((DMNDiagramEditor)inOrder.verify((Object)this.diagramEditor)).onDiagramLoad();
        ((DMNDiagramEditor)inOrder.verify((Object)this.diagramEditor)).superInitialiseKieEditorForSession((ProjectDiagram)Matchers.any());
    }

    @Test
    public void testSetupSearchComponent() {
        this.diagramEditor.setupSearchComponent();
        ((SearchBarComponent)Mockito.verify(this.searchBarComponent)).init((EditorSearchIndex)this.editorSearchIndex);
        ((MultiPageEditor)Mockito.verify((Object)this.multiPage)).addTabBarWidget((IsWidget)this.searchBarComponentWidget);
    }

    @Test
    public void testOnDiagramLoadWhenCanvasHandlerIsNotNull() {
        Mockito.when((Object)this.sessionManager.getCurrentSession()).thenReturn((Object)this.dmnEditorSession);
        Mockito.when((Object)this.dmnEditorSession.getCanvasHandler()).thenReturn((Object)this.canvasHandler);
        Mockito.when((Object)this.canvasHandler.getDiagram()).thenReturn((Object)this.diagram);
        this.open();
        ((DecisionNavigatorDock)Mockito.verify((Object)this.decisionNavigatorDock, (VerificationMode)Mockito.atLeast((int)1))).reload();
        ((ExpressionEditorView.Presenter)Mockito.verify((Object)this.expressionEditor, (VerificationMode)Mockito.atLeast((int)1))).setToolbarStateHandler((ToolbarStateHandler)Matchers.any(DMNProjectToolbarStateHandler.class));
        ((DataTypesPage)Mockito.verify((Object)this.dataTypesPage, (VerificationMode)Mockito.atLeast((int)1))).reload();
        ((LayoutHelper)Mockito.verify((Object)this.layoutHelper)).applyLayout((Diagram)this.diagram, (LayoutExecutor)this.layoutExecutor);
        ((IncludedModelsPage)Mockito.verify((Object)this.includedModelsPage, (VerificationMode)Mockito.atLeast((int)1))).reload();
        ((LazyCanvasFocusUtils)Mockito.verify((Object)this.lazyCanvasFocusUtils, (VerificationMode)Mockito.atLeast((int)1))).releaseFocus();
    }

    @Test
    public void testOnDiagramLoadWhenCanvasHandlerIsNull() {
        this.diagramEditor.onDiagramLoad();
        ((ExpressionEditorView.Presenter)Mockito.verify((Object)this.expressionEditor, (VerificationMode)Mockito.never())).setToolbarStateHandler((ToolbarStateHandler)Matchers.any(DMNProjectToolbarStateHandler.class));
        ((DecisionNavigatorDock)Mockito.verify((Object)this.decisionNavigatorDock, (VerificationMode)Mockito.never())).reload();
        ((DecisionNavigatorDock)Mockito.verify((Object)this.decisionNavigatorDock, (VerificationMode)Mockito.never())).open();
        ((DataTypesPage)Mockito.verify((Object)this.dataTypesPage, (VerificationMode)Mockito.never())).reload();
        ((IncludedModelsPage)Mockito.verify((Object)this.includedModelsPage, (VerificationMode)Mockito.never())).reload();
        ((LazyCanvasFocusUtils)Mockito.verify((Object)this.lazyCanvasFocusUtils, (VerificationMode)Mockito.never())).releaseFocus();
    }

    @Test
    public void testOnFocus() {
        ((DMNDiagramEditor)Mockito.doNothing().when((Object)this.diagramEditor)).superDoFocus();
        this.diagramEditor.onFocus();
        ((DMNDiagramEditor)Mockito.verify((Object)this.diagramEditor)).superDoFocus();
        ((DMNDiagramEditor)Mockito.verify((Object)this.diagramEditor)).onDiagramLoad();
        ((DataTypesPage)Mockito.verify((Object)this.dataTypesPage)).onFocus();
        ((DataTypesPage)Mockito.verify((Object)this.dataTypesPage)).enableShortcuts();
    }

    @Test
    public void testOnLostFocus() {
        this.diagramEditor.onLostFocus();
        ((DataTypesPage)Mockito.verify((Object)this.dataTypesPage)).onLostFocus();
    }

    @Test
    public void testOnEditExpressionEvent() {
        Mockito.when((Object)this.editExpressionEvent.getSession()).thenReturn((Object)this.dmnEditorSession);
        Mockito.when((Object)this.sessionManager.getCurrentSession()).thenReturn((Object)this.dmnEditorSession);
        Mockito.when((Object)this.dmnEditorSession.getCanvasHandler()).thenReturn((Object)this.canvasHandler);
        this.open();
        this.diagramEditor.onEditExpressionEvent(this.editExpressionEvent);
        ((SearchBarComponent)Mockito.verify(this.searchBarComponent)).disableSearch();
        ((SessionCommandManager)Mockito.verify(this.sessionCommandManager)).execute(Matchers.eq((Object)this.canvasHandler), (Command)Matchers.any(NavigateToExpressionEditorCommand.class));
    }

    @Test
    public void testOnDataTypePageNavTabActiveEvent() {
        this.diagramEditor.onDataTypePageNavTabActiveEvent((DataTypePageTabActiveEvent)Mockito.mock(DataTypePageTabActiveEvent.class));
        ((MultiPageEditor)Mockito.verify((Object)this.multiPage)).selectPage(2);
    }

    @Test
    public void testOnDataTypeEditModeToggleWhenEditModeIsEnabled() {
        DataTypeEditModeToggleEvent editModeToggleEvent = (DataTypeEditModeToggleEvent)Mockito.mock(DataTypeEditModeToggleEvent.class);
        ((DMNDiagramEditor)Mockito.doNothing().when((Object)this.diagramEditor)).disableMenuItem((MenuItems)Matchers.any());
        Mockito.when((Object)editModeToggleEvent.isEditModeEnabled()).thenReturn((Object)true);
        this.diagramEditor.getOnDataTypeEditModeToggleCallback(editModeToggleEvent).onInvoke(new Object[0]);
        ((DMNDiagramEditor)Mockito.verify((Object)this.diagramEditor)).disableMenuItem(MenuItems.SAVE);
    }

    @Test
    public void testOnDataTypeEditModeToggleWhenEditModeIsNotEnabled() {
        DataTypeEditModeToggleEvent editModeToggleEvent = (DataTypeEditModeToggleEvent)Mockito.mock(DataTypeEditModeToggleEvent.class);
        ((DMNDiagramEditor)Mockito.doNothing().when((Object)this.diagramEditor)).enableMenuItem((MenuItems)Matchers.any());
        Mockito.when((Object)editModeToggleEvent.isEditModeEnabled()).thenReturn((Object)false);
        this.diagramEditor.getOnDataTypeEditModeToggleCallback(editModeToggleEvent).onInvoke(new Object[0]);
        ((DMNDiagramEditor)Mockito.verify((Object)this.diagramEditor)).enableMenuItem(MenuItems.SAVE);
    }

    @Test
    public void testShowDocks() {
        this.diagramEditor.showDocks();
        ((DecisionNavigatorDock)Mockito.verify((Object)this.decisionNavigatorDock)).open();
        ((DefaultEditorDock)Mockito.verify((Object)this.docks)).show();
    }

    @Test
    public void testHideDocks() {
        this.diagramEditor.hideDocks();
        ((DecisionNavigatorDock)Mockito.verify((Object)this.decisionNavigatorDock)).close();
        ((DecisionNavigatorDock)Mockito.verify((Object)this.decisionNavigatorDock)).resetContent();
        ((DefaultEditorDock)Mockito.verify((Object)this.docks)).hide();
    }

    public void testDocksQualifiers() {
        Annotation[] qualifiers = this.presenter.getDockQualifiers();
        Assert.assertEquals((long)1L, (long)qualifiers.length);
        Assert.assertEquals(DMNEditor.class, qualifiers[0].annotationType());
    }

    @Test
    public void testParsingErrorMessage() {
        ((ClientTranslationService)Mockito.doAnswer(i -> i.getArguments()[0]).when((Object)this.translationService)).getValue(Matchers.anyString());
        String xml = "xml";
        this.openInvalidFile("xml");
        ArgumentCaptor notificationEventCaptor = ArgumentCaptor.forClass(NotificationEvent.class);
        ((EventSourceMock)Mockito.verify((Object)this.notificationEvent)).fire(notificationEventCaptor.capture());
        NotificationEvent notificationEvent = (NotificationEvent)notificationEventCaptor.getValue();
        Assert.assertEquals((Object)"DMNDiagramParsingErrorMessage", (Object)notificationEvent.getNotification());
    }

    @Test
    public void testStunnerSave_ValidationUnsuccessful() {
        Overview overview = this.assertBasicStunnerSaveOperation(false);
        this.assertSaveOperation(overview);
    }

    @Test
    public void testOnMultiPageEditorSelectedPageEvent() {
        SessionPresenter sessionPresenter = (SessionPresenter)Mockito.mock(SessionPresenter.class);
        ((DMNDiagramEditor)Mockito.doReturn((Object)sessionPresenter).when((Object)this.diagramEditor)).getSessionPresenter();
        Mockito.when((Object)sessionPresenter.getInstance()).thenReturn((Object)this.dmnEditorSession);
        Mockito.when((Object)sessionPresenter.getView()).thenReturn((Object)this.sessionPresenterView);
        Mockito.when((Object)this.sessionManager.getCurrentSession()).thenReturn((Object)this.dmnEditorSession);
        this.open();
        this.diagramEditor.onMultiPageEditorSelectedPageEvent((MultiPageEditorSelectedPageEvent)Mockito.mock(MultiPageEditorSelectedPageEvent.class));
        ((SearchBarComponent)Mockito.verify(this.searchBarComponent)).disableSearch();
    }

    @Test
    public void testOnMultiPageEditorSelectedPageEventWhenEditorIsNotInTheSameSession() {
        SessionPresenter sessionPresenter = (SessionPresenter)Mockito.mock(SessionPresenter.class);
        ((DMNDiagramEditor)Mockito.doReturn((Object)sessionPresenter).when((Object)this.diagramEditor)).getSessionPresenter();
        Mockito.when((Object)sessionPresenter.getInstance()).thenReturn((Object)this.dmnEditorSession);
        Mockito.when((Object)sessionPresenter.getView()).thenReturn((Object)this.sessionPresenterView);
        Mockito.when((Object)this.sessionManager.getCurrentSession()).thenReturn((Object)this.defaultEditorSession);
        Mockito.when((Object)this.defaultEditorSession.getExpressionEditor()).thenReturn((Object)this.expressionEditor);
        this.open();
        this.diagramEditor.onMultiPageEditorSelectedPageEvent((MultiPageEditorSelectedPageEvent)Mockito.mock(MultiPageEditorSelectedPageEvent.class));
        ((SearchBarComponent)Mockito.verify(this.searchBarComponent, (VerificationMode)Mockito.never())).disableSearch();
    }

    @Test
    public void testOnRefreshFormPropertiesEvent() {
        this.diagramEditor.onRefreshFormPropertiesEvent((RefreshFormPropertiesEvent)Mockito.mock(RefreshFormPropertiesEvent.class));
        ((SearchBarComponent)Mockito.verify(this.searchBarComponent)).disableSearch();
    }

    @Test
    public void testTabContentOrdering() {
        Mockito.when((Object)this.documentationView.isEnabled()).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)this.documentationView.initialize((Diagram)this.diagram)).thenReturn((Object)this.documentationView);
        Mockito.when((Object)this.kieView.getMultiPage()).thenReturn((Object)this.multiPage);
        this.open();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.kieView, this.multiPage});
        ((KieEditorWrapperView)inOrder.verify((Object)this.kieView)).addMainEditorPage((IsWidget)this.view);
        ((KieEditorWrapperView)inOrder.verify((Object)this.kieView)).addPage((Page)Matchers.any(DocumentationPage.class));
        ((MultiPageEditor)inOrder.verify((Object)this.multiPage)).addPage((Page)this.dataTypesPage);
        ((MultiPageEditor)inOrder.verify((Object)this.multiPage)).addPage((Page)this.includedModelsPage);
        ((KieEditorWrapperView)inOrder.verify((Object)this.kieView)).addOverviewPage((OverviewWidgetPresenter)Matchers.eq((Object)this.overviewWidget), (com.google.gwt.user.client.Command)Matchers.any(com.google.gwt.user.client.Command.class));
    }

    @Test
    public void testLoadContentWithValidFile() {
        super.testLoadContentWithValidFile();
        ((LayoutHelper)Mockito.verify((Object)this.layoutHelper)).applyLayout((Diagram)Matchers.eq((Object)this.diagram), (LayoutExecutor)Matchers.eq((Object)this.layoutExecutor));
        ((MonacoFEELInitializer)Mockito.verify((Object)this.feelInitializer)).initializeFEELEditor();
    }

    @Test
    public void testLoadContentWithInvalidFile() {
        super.testLoadContentWithInvalidFile();
        ((MonacoFEELInitializer)Mockito.verify((Object)this.feelInitializer, (VerificationMode)Mockito.never())).initializeFEELEditor();
    }

    @Test
    public void testUpdateOriginalHash() {
        Integer currentHash = 27;
        Integer previousSetHash = 5;
        ((DMNDiagramEditor)Mockito.doReturn((Object)currentHash).when((Object)this.diagramEditor)).getCurrentDiagramHash();
        this.diagramEditor.setOriginalHash(Integer.valueOf(0));
        this.diagramEditor.updateOriginalHash();
        Assert.assertEquals((Object)currentHash, (Object)this.diagramEditor.getOriginalHash());
        this.diagramEditor.setOriginalHash(previousSetHash);
        this.diagramEditor.updateOriginalHash();
        Assert.assertEquals((Object)previousSetHash, (Object)this.diagramEditor.getOriginalHash());
    }
}

