/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.project.client.editor;

import elemental2.dom.DomGlobal;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.kie.workbench.common.dmn.api.DMNContentResource;
import org.kie.workbench.common.dmn.api.DMNContentService;
import org.kie.workbench.common.dmn.api.DMNDefinitionSet;
import org.kie.workbench.common.dmn.api.qualifiers.DMNEditor;
import org.kie.workbench.common.dmn.client.marshaller.DMNMarshallerService;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.api.ShapeManager;
import org.kie.workbench.common.stunner.core.client.service.ClientRuntimeError;
import org.kie.workbench.common.stunner.core.client.service.ServiceCallback;
import org.kie.workbench.common.stunner.core.client.session.event.SessionDiagramSavedEvent;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableAdapterUtils;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.service.DiagramLookupService;
import org.kie.workbench.common.stunner.core.util.StringUtils;
import org.kie.workbench.common.stunner.project.client.service.ClientProjectDiagramService;
import org.kie.workbench.common.stunner.project.diagram.ProjectDiagram;
import org.kie.workbench.common.stunner.project.diagram.ProjectMetadata;
import org.kie.workbench.common.stunner.project.diagram.impl.ProjectDiagramImpl;
import org.kie.workbench.common.stunner.project.service.ProjectDiagramService;
import org.uberfire.backend.vfs.Path;

@DMNEditor
public class DMNClientProjectDiagramService
extends ClientProjectDiagramService {
    private final Caller<DMNContentService> dmnContentServiceCaller;
    private final DMNMarshallerService dmnMarshallerService;

    @Inject
    public DMNClientProjectDiagramService(ShapeManager shapeManager, SessionManager sessionManager, Caller<ProjectDiagramService> diagramServiceCaller, Caller<DiagramLookupService> diagramLookupServiceCaller, Event<SessionDiagramSavedEvent> saveEvent, Caller<DMNContentService> dmnContentServiceCaller, DMNMarshallerService dmnMarshallerService) {
        super(shapeManager, sessionManager, diagramServiceCaller, diagramLookupServiceCaller, saveEvent);
        this.dmnContentServiceCaller = dmnContentServiceCaller;
        this.dmnMarshallerService = dmnMarshallerService;
    }

    public void getByPath(Path path, ServiceCallback<ProjectDiagram> callback) {
        String defSetId = BindableAdapterUtils.getDefinitionSetId(DMNDefinitionSet.class);
        ((DMNContentService)this.dmnContentServiceCaller.call(this.onProjectContent(callback))).getProjectContent(path, defSetId);
    }

    RemoteCallback<DMNContentResource> onProjectContent(ServiceCallback<ProjectDiagram> callback) {
        return resource -> this.dmnMarshallerService.unmarshall(resource.getMetadata(), resource.getContent(), this.getMarshallerCallback((DMNContentResource)resource, callback));
    }

    ServiceCallback<Diagram> getMarshallerCallback(final DMNContentResource resource, final ServiceCallback<ProjectDiagram> callback) {
        return new ServiceCallback<Diagram>(){

            public void onSuccess(Diagram diagram) {
                callback.onSuccess((Object)DMNClientProjectDiagramService.this.asProjectDiagramImpl(diagram, resource));
            }

            public void onError(ClientRuntimeError error) {
                callback.onError(error);
            }
        };
    }

    ProjectDiagramImpl asProjectDiagramImpl(Diagram diagram, DMNContentResource resource) {
        String name = this.removeExtension(diagram.getName());
        Graph graph = diagram.getGraph();
        ProjectMetadata metadata = (ProjectMetadata)resource.getMetadata();
        return new ProjectDiagramImpl(name, graph, metadata);
    }

    public void saveOrUpdate(final Path path, final ProjectDiagram diagram, final Metadata metadata, final String comment, final ServiceCallback<ProjectDiagram> callback) {
        this.dmnMarshallerService.marshall((Diagram)diagram, (ServiceCallback)new ServiceCallback<String>(){

            public void onSuccess(String xml) {
                DMNClientProjectDiagramService.this.saveAsXml(path, xml, metadata, comment, DMNClientProjectDiagramService.this.onSaveAsXmlComplete(diagram, (ServiceCallback<ProjectDiagram>)callback));
            }

            public void onError(ClientRuntimeError error) {
                callback.onError(error);
            }
        });
    }

    ServiceCallback<String> onSaveAsXmlComplete(final ProjectDiagram diagram, final ServiceCallback<ProjectDiagram> callback) {
        return new ServiceCallback<String>(){

            public void onSuccess(String xml) {
                callback.onSuccess((Object)diagram);
            }

            public void onError(ClientRuntimeError e) {
                DomGlobal.console.error(new Object[]{e.getMessage(), e});
            }
        };
    }

    private String removeExtension(String filename) {
        if (StringUtils.isEmpty((String)filename)) {
            return "";
        }
        int index = filename.lastIndexOf(".");
        if (index == -1) {
            return filename;
        }
        return filename.substring(0, index);
    }
}

