/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.project.client.validation;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.validation.DMNDomainValidator;
import org.kie.workbench.common.dmn.client.marshaller.DMNMarshallerService;
import org.kie.workbench.common.dmn.project.client.validation.DMNClientDiagramValidator;
import org.kie.workbench.common.stunner.core.api.DefinitionManager;
import org.kie.workbench.common.stunner.core.client.service.ClientRuntimeError;
import org.kie.workbench.common.stunner.core.client.service.ServiceCallback;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.graph.processing.traverse.tree.TreeWalkTraverseProcessor;
import org.kie.workbench.common.stunner.core.marshaller.MarshallingMessage;
import org.kie.workbench.common.stunner.core.rule.RuleManager;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;
import org.kie.workbench.common.stunner.core.validation.DiagramElementViolation;
import org.kie.workbench.common.stunner.core.validation.DomainValidator;
import org.kie.workbench.common.stunner.core.validation.DomainViolation;
import org.kie.workbench.common.stunner.core.validation.ModelValidator;
import org.kie.workbench.common.stunner.core.validation.impl.ElementViolationImpl;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.CallerMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class DMNClientDiagramValidatorTest {
    @Mock
    private DefinitionManager definitionManager;
    @Mock
    private RuleManager ruleManager;
    @Mock
    private TreeWalkTraverseProcessor treeWalkTraverseProcessor;
    @Mock
    private ModelValidator modelValidator;
    @Mock
    private ManagedInstance<DomainValidator> validators;
    @Mock
    private Diagram diagram;
    @Mock
    private Consumer<Collection<DiagramElementViolation<RuleViolation>>> violationsConsumer;
    @Mock
    private Collection<DiagramElementViolation<RuleViolation>> violations;
    @Mock
    private ServiceCallback<String> diagramXmlServiceCallback;
    @Mock
    private CallerMock<DMNDomainValidator> dmnDomainValidatorCaller;
    @Mock
    private DMNDomainValidator dmnDomainValidator;
    @Mock
    private DMNMarshallerService dmnMarshallerService;
    @Mock
    private RemoteCallback<Collection<DomainViolation>> callback;
    @Mock
    private ErrorCallback<Object> errorCallback;
    private DMNClientDiagramValidator validator;

    @Before
    public void setup() {
        Mockito.when((Object)((DMNDomainValidator)this.dmnDomainValidatorCaller.call((RemoteCallback)ArgumentMatchers.any(RemoteCallback.class), (ErrorCallback)ArgumentMatchers.any(ErrorCallback.class)))).thenReturn((Object)this.dmnDomainValidator);
        this.validator = (DMNClientDiagramValidator)Mockito.spy((Object)new DMNClientDiagramValidator(this.definitionManager, this.ruleManager, this.treeWalkTraverseProcessor, this.modelValidator, this.validators, this.dmnDomainValidatorCaller, this.dmnMarshallerService));
    }

    @Test
    public void testValidate() {
        Consumer<Collection> consumer = e -> {};
        ((DMNClientDiagramValidator)Mockito.doReturn(consumer).when((Object)this.validator)).getCollectionConsumer(this.diagram, this.violationsConsumer);
        ((DMNClientDiagramValidator)Mockito.doNothing().when((Object)this.validator)).superValidate((Diagram)ArgumentMatchers.any(), (Consumer)ArgumentMatchers.any());
        this.validator.validate(this.diagram, this.violationsConsumer);
        ((DMNClientDiagramValidator)Mockito.verify((Object)this.validator)).superValidate(this.diagram, consumer);
    }

    @Test
    public void testGetCollectionConsumer() {
        ((DMNClientDiagramValidator)Mockito.doReturn(this.diagramXmlServiceCallback).when((Object)this.validator)).getContentServiceCallback(this.diagram, this.violationsConsumer, this.violations);
        this.validator.getCollectionConsumer(this.diagram, this.violationsConsumer).accept(this.violations);
        ((DMNMarshallerService)Mockito.verify((Object)this.dmnMarshallerService)).marshall(this.diagram, this.diagramXmlServiceCallback);
    }

    @Test
    public void testGetContentServiceCallbackOnSuccess() {
        String diagramXml = "<xml />";
        ((DMNClientDiagramValidator)Mockito.doReturn(this.callback).when((Object)this.validator)).onValidatorSuccess(this.violations, this.violationsConsumer);
        ((DMNClientDiagramValidator)Mockito.doReturn(this.errorCallback).when((Object)this.validator)).onValidatorError();
        this.validator.getContentServiceCallback(this.diagram, this.violationsConsumer, this.violations).onSuccess((Object)"<xml />");
        ((CallerMock)Mockito.verify(this.dmnDomainValidatorCaller)).call(this.callback, this.errorCallback);
        ((DMNDomainValidator)Mockito.verify((Object)this.dmnDomainValidator)).validate(this.diagram, "<xml />");
    }

    @Test
    public void testOnValidatorSuccess() {
        ElementViolationImpl elementViolation = new ElementViolationImpl.Builder().build();
        MarshallingMessage marshallingMessage = MarshallingMessage.builder().build();
        List<ElementViolationImpl> diagramElementViolations = Collections.singletonList(elementViolation);
        List<MarshallingMessage> response = Collections.singletonList(marshallingMessage);
        Consumer<Collection> resultConsumer = collection -> Assert.assertEquals((long)1L, (long)collection.size());
        this.validator.onValidatorSuccess(diagramElementViolations, resultConsumer).callback(response);
    }

    @Test
    public void testOnValidatorError() {
        ((DMNClientDiagramValidator)Mockito.doNothing().when((Object)this.validator)).logError((String)Mockito.any());
        this.validator.onValidatorError().error(null, null);
        ((DMNClientDiagramValidator)Mockito.verify((Object)this.validator)).logError("Validation service error");
    }

    @Test
    public void testGetContentServiceCallbackError() {
        ClientRuntimeError error = (ClientRuntimeError)Mockito.mock(ClientRuntimeError.class);
        ((DMNClientDiagramValidator)Mockito.doNothing().when((Object)this.validator)).logError((String)Mockito.any());
        this.validator.getContentServiceCallback(this.diagram, this.violationsConsumer, this.violations).onError(error);
        ((DMNDomainValidator)Mockito.verify((Object)this.dmnDomainValidator, (VerificationMode)Mockito.never())).validate((Diagram)ArgumentMatchers.any(), (String)Mockito.any());
        ((DMNClientDiagramValidator)Mockito.verify((Object)this.validator)).logError("Marshaller service error");
    }
}

