/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.webapp.common.client.docks.preview;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.uberfire.client.workbench.docks.UberfireDock;
import org.uberfire.client.workbench.docks.UberfireDockPosition;
import org.uberfire.client.workbench.docks.UberfireDocks;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;

@ApplicationScoped
public class PreviewDiagramDock {
    static final double DOCK_SIZE = 400.0;
    private UberfireDocks uberfireDocks;
    private TranslationService translationService;
    private UberfireDock uberfireDock;
    private boolean isOpened = false;
    private String owningPerspectiveId;

    public PreviewDiagramDock() {
    }

    @Inject
    public PreviewDiagramDock(UberfireDocks uberfireDocks, TranslationService translationService) {
        this.uberfireDocks = uberfireDocks;
        this.translationService = translationService;
    }

    public void init(String owningPerspectiveId) {
        this.owningPerspectiveId = owningPerspectiveId;
        this.uberfireDock = this.makeUberfireDock();
    }

    public void open() {
        if (this.isOpened()) {
            return;
        }
        this.isOpened = true;
        this.uberfireDocks.add(new UberfireDock[]{this.getUberfireDock()});
        this.uberfireDocks.show(this.position(), this.owningPerspectiveId());
        this.uberfireDocks.open(this.getUberfireDock());
    }

    public void close() {
        if (!this.isOpened()) {
            return;
        }
        this.isOpened = false;
        this.uberfireDocks.close(this.getUberfireDock());
        this.uberfireDocks.remove(new UberfireDock[]{this.getUberfireDock()});
    }

    boolean isOpened() {
        return this.isOpened;
    }

    UberfireDock makeUberfireDock() {
        UberfireDock uberfireDock = new UberfireDock(this.position(), this.icon(), (PlaceRequest)this.placeRequest(), this.owningPerspectiveId());
        return uberfireDock.withSize(400.0).withLabel(this.dockLabel());
    }

    UberfireDockPosition position() {
        return UberfireDockPosition.EAST;
    }

    private String icon() {
        return IconType.EYE.toString();
    }

    private DefaultPlaceRequest placeRequest() {
        return new DefaultPlaceRequest("DMNProjectDiagramExplorerScreen");
    }

    String owningPerspectiveId() {
        return this.owningPerspectiveId;
    }

    UberfireDock getUberfireDock() {
        return this.uberfireDock;
    }

    private String dockLabel() {
        return this.translationService.getTranslation("DMNPreviewDiagramDock.Title");
    }
}

