/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.webapp.kogito.common.client.docks;

import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.docks.navigator.DecisionNavigatorPresenter;
import org.kie.workbench.common.stunner.kogito.api.docks.DiagramEditorDock;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.workbench.docks.UberfireDock;
import org.uberfire.client.workbench.docks.UberfireDockPosition;
import org.uberfire.client.workbench.docks.UberfireDocks;

@RunWith(value=MockitoJUnitRunner.class)
public abstract class BaseKogitoDockTest {
    private static final String PERSPECTIVE_ID = "perspectiveId";
    @Mock
    protected UberfireDocks uberfireDocks;
    @Mock
    protected DecisionNavigatorPresenter decisionNavigatorPresenter;
    @Mock
    protected TranslationService translationService;
    @Captor
    private ArgumentCaptor<UberfireDock> dockArgumentCaptor;
    private DiagramEditorDock dock;

    @Before
    public void setup() {
        this.dock = this.makeDock();
        this.dock.init(PERSPECTIVE_ID);
    }

    protected abstract DiagramEditorDock makeDock();

    protected abstract UberfireDockPosition position();

    protected abstract String screen();

    @Test
    public void testInit() {
        ((UberfireDocks)Mockito.verify((Object)this.uberfireDocks)).add(new UberfireDock[]{(UberfireDock)this.dockArgumentCaptor.capture()});
        ((UberfireDocks)Mockito.verify((Object)this.uberfireDocks)).show((UberfireDockPosition)Matchers.eq((Object)this.position()), (String)Matchers.eq((Object)PERSPECTIVE_ID));
        Assert.assertEquals((Object)this.screen(), (Object)((UberfireDock)this.dockArgumentCaptor.getValue()).getIdentifier());
    }

    @Test
    public void testDestroy() {
        this.dock.destroy();
        ((UberfireDocks)Mockito.verify((Object)this.uberfireDocks)).remove(new UberfireDock[]{(UberfireDock)this.dockArgumentCaptor.capture()});
        Assert.assertEquals((Object)this.screen(), (Object)((UberfireDock)this.dockArgumentCaptor.getValue()).getIdentifier());
    }

    @Test
    public void testOpenWhenClosed() {
        this.dock.open();
        ((UberfireDocks)Mockito.verify((Object)this.uberfireDocks)).open((UberfireDock)this.dockArgumentCaptor.capture());
        Assert.assertEquals((Object)this.screen(), (Object)((UberfireDock)this.dockArgumentCaptor.getValue()).getIdentifier());
    }

    @Test
    public void testOpenWhenAlreadyOpen() {
        this.dock.open();
        Mockito.reset((Object[])new UberfireDocks[]{this.uberfireDocks});
        this.dock.open();
        ((UberfireDocks)Mockito.verify((Object)this.uberfireDocks, (VerificationMode)Mockito.never())).open((UberfireDock)Matchers.any(UberfireDock.class));
    }

    @Test
    public void testCloseWhenOpen() {
        this.dock.open();
        this.dock.close();
        ((UberfireDocks)Mockito.verify((Object)this.uberfireDocks)).close((UberfireDock)this.dockArgumentCaptor.capture());
        Assert.assertEquals((Object)this.screen(), (Object)((UberfireDock)this.dockArgumentCaptor.getValue()).getIdentifier());
    }

    @Test
    public void testCloseWhenAlreadyClosed() {
        this.dock.close();
        ((UberfireDocks)Mockito.verify((Object)this.uberfireDocks, (VerificationMode)Mockito.never())).close((UberfireDock)Matchers.any(UberfireDock.class));
    }
}

