/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.webapp.kogito.common.client.editor;

import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.dom.HTMLElement;
import java.util.function.Predicate;
import org.jboss.errai.common.client.ui.ElementWrapperWidget;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.DMNDefinitionSet;
import org.kie.workbench.common.dmn.client.commands.general.NavigateToExpressionEditorCommand;
import org.kie.workbench.common.dmn.client.docks.navigator.DecisionNavigatorDock;
import org.kie.workbench.common.dmn.client.editors.expressions.ExpressionEditorView;
import org.kie.workbench.common.dmn.client.editors.included.IncludedModelsPage;
import org.kie.workbench.common.dmn.client.editors.included.common.IncludedModelsPageStateProvider;
import org.kie.workbench.common.dmn.client.editors.included.imports.IncludedModelsPageStateProviderImpl;
import org.kie.workbench.common.dmn.client.editors.search.DMNEditorSearchIndex;
import org.kie.workbench.common.dmn.client.editors.search.DMNSearchableElement;
import org.kie.workbench.common.dmn.client.editors.types.DataTypePageTabActiveEvent;
import org.kie.workbench.common.dmn.client.editors.types.DataTypesPage;
import org.kie.workbench.common.dmn.client.editors.types.listview.common.DataTypeEditModeToggleEvent;
import org.kie.workbench.common.dmn.client.events.EditExpressionEvent;
import org.kie.workbench.common.dmn.client.session.DMNEditorSession;
import org.kie.workbench.common.dmn.webapp.common.client.docks.preview.PreviewDiagramDock;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.editor.BaseDMNDiagramEditor;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.editor.DMNEditorMenuSessionItems;
import org.kie.workbench.common.kogito.client.editor.MultiPageEditorContainerView;
import org.kie.workbench.common.stunner.client.widgets.presenters.session.SessionPresenter;
import org.kie.workbench.common.stunner.client.widgets.presenters.session.impl.SessionEditorPresenter;
import org.kie.workbench.common.stunner.client.widgets.presenters.session.impl.SessionViewerPresenter;
import org.kie.workbench.common.stunner.core.client.ManagedInstanceStub;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.core.client.components.layout.LayoutHelper;
import org.kie.workbench.common.stunner.core.client.components.layout.OpenDiagramLayoutExecutor;
import org.kie.workbench.common.stunner.core.client.error.DiagramClientErrorHandler;
import org.kie.workbench.common.stunner.core.client.i18n.ClientTranslationService;
import org.kie.workbench.common.stunner.core.client.session.impl.EditorSession;
import org.kie.workbench.common.stunner.core.client.session.impl.ViewerSession;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.DiagramImpl;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.diagram.MetadataImpl;
import org.kie.workbench.common.stunner.core.documentation.DocumentationView;
import org.kie.workbench.common.stunner.forms.client.event.RefreshFormPropertiesEvent;
import org.kie.workbench.common.stunner.kogito.client.docks.DiagramEditorPropertiesDock;
import org.kie.workbench.common.stunner.kogito.client.editor.DiagramEditorCore;
import org.kie.workbench.common.stunner.kogito.client.editor.event.OnDiagramFocusEvent;
import org.kie.workbench.common.stunner.kogito.client.service.KogitoClientDiagramService;
import org.kie.workbench.common.widgets.client.menu.FileMenuBuilder;
import org.kie.workbench.common.widgets.client.search.component.SearchBarComponent;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.views.pfly.multipage.MultiPageEditorSelectedPageEvent;
import org.uberfire.client.workbench.events.ChangeTitleWidgetEvent;
import org.uberfire.client.workbench.widgets.common.ErrorPopupPresenter;
import org.uberfire.client.workbench.widgets.multipage.MultiPageEditor;
import org.uberfire.ext.editor.commons.client.menu.MenuItems;
import org.uberfire.ext.widgets.core.client.editors.texteditor.TextEditorView;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.workbench.events.NotificationEvent;

@RunWith(value=GwtMockitoTestRunner.class)
public abstract class BaseDMNDiagramEditorTest {
    protected static final String ROOT = "default://master@system/stunner/diagrams";
    @Mock
    protected AbstractCanvasHandler canvasHandler;
    @Mock
    protected DiagramEditorCore.View view;
    @Mock
    protected FileMenuBuilder fileMenuBuilder;
    @Mock
    protected PlaceManager placeManager;
    @Mock
    protected MultiPageEditorContainerView multiPageEditorContainerView;
    @Mock
    protected MultiPageEditor multiPageEditor;
    @Mock
    protected EventSourceMock<ChangeTitleWidgetEvent> changeTitleWidgetEventSourceMock;
    @Mock
    protected EventSourceMock<NotificationEvent> notificationEventSourceMock;
    @Mock
    protected EventSourceMock<OnDiagramFocusEvent> onDiagramFocusEventSourceMock;
    @Mock
    protected TextEditorView xmlEditorView;
    protected ManagedInstanceStub<SessionEditorPresenter<EditorSession>> sessionEditorPresenters;
    protected ManagedInstanceStub<SessionViewerPresenter<ViewerSession>> sessionViewerPresenters;
    @Mock
    protected DMNEditorMenuSessionItems dmnEditorMenuSessionItems;
    @Mock
    protected ErrorPopupPresenter errorPopupPresenter;
    @Mock
    protected DiagramClientErrorHandler diagramClientErrorHandler;
    @Mock
    protected ClientTranslationService clientTranslationService;
    @Mock
    protected DocumentationView<Diagram> documentationView;
    @Mock
    protected DMNEditorSearchIndex editorSearchIndex;
    @Mock
    protected SearchBarComponent<DMNSearchableElement> searchBarComponent;
    @Mock
    protected SessionManager sessionManager;
    @Mock
    protected SessionCommandManager<AbstractCanvasHandler> sessionCommandManager;
    @Mock
    protected EventSourceMock<RefreshFormPropertiesEvent> refreshFormPropertiesEventSourceMock;
    @Mock
    protected DecisionNavigatorDock decisionNavigatorDock;
    @Mock
    protected DiagramEditorPropertiesDock diagramPropertiesDock;
    @Mock
    protected PreviewDiagramDock diagramPreviewDock;
    @Mock
    protected LayoutHelper layoutHelper;
    @Mock
    protected OpenDiagramLayoutExecutor layoutExecutor;
    @Mock
    protected DataTypesPage dataTypesPage;
    @Mock
    protected IncludedModelsPage includedModelsPage;
    @Mock
    protected IncludedModelsPageStateProviderImpl importsPageProvider;
    @Mock
    protected KogitoClientDiagramService clientDiagramService;
    @Mock
    protected SessionEditorPresenter<EditorSession> editorPresenter;
    @Mock
    protected SessionViewerPresenter<ViewerSession> viewerPresenter;
    @Mock
    protected ExpressionEditorView.Presenter expressionEditor;
    @Mock
    protected DMNEditorSession session;
    @Mock
    protected SearchBarComponent.View searchBarComponentView;
    @Mock
    protected HTMLElement searchBarComponentViewElement;
    @Mock
    protected ElementWrapperWidget searchBarComponentWidget;
    @Mock
    protected DataTypePageTabActiveEvent dataTypePageTabActiveEvent;
    @Mock
    protected DataTypeEditModeToggleEvent dataTypeEditModeToggleEvent;
    @Mock
    protected EditExpressionEvent editExpressionEvent;
    @Mock
    protected MultiPageEditorSelectedPageEvent multiPageEditorSelectedPageEvent;
    @Mock
    protected RefreshFormPropertiesEvent refreshFormPropertiesEvent;
    @Mock
    protected Path root;
    protected Diagram diagram;
    protected Metadata metadata;
    protected BaseDMNDiagramEditor editor;
    protected PlaceRequest place = new DefaultPlaceRequest();

    @Before
    public void setup() {
        this.metadata = new MetadataImpl.MetadataImplBuilder(DMNDefinitionSet.class.getName()).setTitle("dmn").setRoot(this.root).build();
        this.diagram = new DiagramImpl("dmn", this.metadata);
        this.sessionEditorPresenters = new ManagedInstanceStub((Object[])new SessionEditorPresenter[]{this.editorPresenter});
        this.sessionViewerPresenters = new ManagedInstanceStub((Object[])new SessionViewerPresenter[]{this.viewerPresenter});
        Mockito.when((Object)this.searchBarComponent.getView()).thenReturn((Object)this.searchBarComponentView);
        Mockito.when((Object)this.searchBarComponentView.getElement()).thenReturn((Object)this.searchBarComponentViewElement);
        Mockito.when((Object)this.multiPageEditorContainerView.getMultiPage()).thenReturn((Object)this.multiPageEditor);
        Mockito.when((Object)this.editorPresenter.withToolbar(Matchers.anyBoolean())).thenReturn(this.editorPresenter);
        Mockito.when((Object)this.editorPresenter.withPalette(Matchers.anyBoolean())).thenReturn(this.editorPresenter);
        Mockito.when((Object)this.editorPresenter.displayNotifications((Predicate)Matchers.any())).thenReturn(this.editorPresenter);
        Mockito.when((Object)this.sessionManager.getCurrentSession()).thenReturn((Object)this.session);
        Mockito.when((Object)this.session.getExpressionEditor()).thenReturn((Object)this.expressionEditor);
        Mockito.when((Object)this.root.toURI()).thenReturn((Object)ROOT);
        ((SessionEditorPresenter)Mockito.doAnswer(invocation -> {
            Diagram diagram = (Diagram)invocation.getArguments()[0];
            SessionPresenter.SessionPresenterCallback callback = (SessionPresenter.SessionPresenterCallback)invocation.getArguments()[1];
            callback.onOpen(diagram);
            callback.afterCanvasInitialized();
            callback.afterSessionOpened();
            callback.onSuccess();
            return null;
        }).when(this.editorPresenter)).open((Diagram)Matchers.any(Diagram.class), (SessionPresenter.SessionPresenterCallback)Matchers.any(SessionPresenter.SessionPresenterCallback.class));
        this.editor = (BaseDMNDiagramEditor)Mockito.spy((Object)this.getEditor());
    }

    protected abstract BaseDMNDiagramEditor getEditor();

    @Test
    public void testOnStartup() {
        this.editor.onStartup(this.place);
        ((DecisionNavigatorDock)Mockito.verify((Object)this.decisionNavigatorDock)).init("AuthoringPerspective");
        ((PreviewDiagramDock)Mockito.verify((Object)this.diagramPreviewDock)).init("AuthoringPerspective");
        ((DiagramEditorPropertiesDock)Mockito.verify((Object)this.diagramPropertiesDock)).init("AuthoringPerspective");
        ((DMNEditorMenuSessionItems)Mockito.verify((Object)this.dmnEditorMenuSessionItems)).populateMenu(this.fileMenuBuilder);
        ((FileMenuBuilder)Mockito.verify((Object)this.fileMenuBuilder)).build();
        ((MultiPageEditorContainerView)Mockito.verify((Object)this.multiPageEditorContainerView)).init(Matchers.eq((Object)this.editor));
    }

    @Test
    public void testOnDataTypePageNavTabActiveEvent() {
        this.editor.onDataTypePageNavTabActiveEvent(this.dataTypePageTabActiveEvent);
        ((MultiPageEditor)Mockito.verify((Object)this.multiPageEditor)).selectPage(2);
    }

    @Test
    public void testOnDataTypeEditModeToggleEnabled() {
        this.openDiagram();
        Mockito.when((Object)this.dataTypeEditModeToggleEvent.isEditModeEnabled()).thenReturn((Object)true);
        this.editor.onDataTypeEditModeToggle(this.dataTypeEditModeToggleEvent);
        ((BaseDMNDiagramEditor)Mockito.verify((Object)this.editor)).disableMenuItem((MenuItems)Matchers.eq((Object)MenuItems.SAVE));
    }

    @Test
    public void testOnDataTypeEditModeToggleDisabled() {
        this.openDiagram();
        Mockito.when((Object)this.dataTypeEditModeToggleEvent.isEditModeEnabled()).thenReturn((Object)false);
        this.editor.onDataTypeEditModeToggle(this.dataTypeEditModeToggleEvent);
        ((BaseDMNDiagramEditor)Mockito.verify((Object)this.editor)).enableMenuItem((MenuItems)Matchers.eq((Object)MenuItems.SAVE));
    }

    @Test
    public void testOnEditExpressionEventWhenSameSession() {
        Mockito.when((Object)this.editExpressionEvent.getSession()).thenReturn((Object)this.session);
        this.openDiagram();
        Mockito.when((Object)this.editorPresenter.getInstance()).thenReturn((Object)this.session);
        this.editor.onEditExpressionEvent(this.editExpressionEvent);
        ((SearchBarComponent)Mockito.verify(this.searchBarComponent)).disableSearch();
        ((SessionCommandManager)Mockito.verify(this.sessionCommandManager)).execute(Matchers.eq((Object)this.canvasHandler), (Command)Matchers.any(NavigateToExpressionEditorCommand.class));
    }

    @Test
    public void testOnEditExpressionEventWhenDifferentSession() {
        this.editor.onEditExpressionEvent(this.editExpressionEvent);
        ((SearchBarComponent)Mockito.verify(this.searchBarComponent)).disableSearch();
        ((SessionCommandManager)Mockito.verify(this.sessionCommandManager, (VerificationMode)Mockito.never())).execute(Matchers.any(AbstractCanvasHandler.class), (Command)Matchers.any(Command.class));
    }

    @Test
    public void testOnMultiPageEditorSelectedPageEvent() {
        this.editor.onMultiPageEditorSelectedPageEvent(this.multiPageEditorSelectedPageEvent);
        ((SearchBarComponent)Mockito.verify(this.searchBarComponent)).disableSearch();
    }

    @Test
    public void testOnRefreshFormPropertiesEvent() {
        this.editor.onRefreshFormPropertiesEvent(this.refreshFormPropertiesEvent);
        ((SearchBarComponent)Mockito.verify(this.searchBarComponent)).disableSearch();
    }

    protected void openDiagram() {
        this.editor.onStartup(this.place);
        Mockito.when((Object)this.importsPageProvider.withDiagram(this.diagram)).thenReturn((Object)this.importsPageProvider);
        Mockito.when((Object)this.session.getCanvasHandler()).thenReturn((Object)this.canvasHandler);
        Mockito.when((Object)this.editorPresenter.getInstance()).thenReturn((Object)this.session);
        Mockito.when((Object)this.canvasHandler.getDiagram()).thenReturn((Object)this.diagram);
        this.editor.open(this.diagram);
        ((DecisionNavigatorDock)Mockito.verify((Object)this.decisionNavigatorDock)).setupCanvasHandler((CanvasHandler)this.canvasHandler);
        ((DataTypesPage)Mockito.verify((Object)this.dataTypesPage)).reload();
        ((IncludedModelsPage)Mockito.verify((Object)this.includedModelsPage)).setup((IncludedModelsPageStateProvider)this.importsPageProvider);
    }
}

