/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.webapp.kogito.common.client.services;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Fail;
import org.junit.Before;
import org.junit.Test;
import org.kie.workbench.common.dmn.api.editors.types.RangeValue;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.services.DMNClientServicesProxyImpl;
import org.kie.workbench.common.stunner.core.client.service.ClientRuntimeError;
import org.kie.workbench.common.stunner.core.client.service.ServiceCallback;

public class DMNClientServicesProxyImplTest {
    private DMNClientServicesProxyImpl service;

    @Before
    public void setup() {
        this.service = new DMNClientServicesProxyImpl();
    }

    @Test
    public void testParseRangeValue() {
        ServiceCallback<RangeValue> callback = new ServiceCallback<RangeValue>(){

            public void onSuccess(RangeValue actual) {
                Assertions.assertThat((boolean)actual.getIncludeStartValue()).isTrue();
                Assertions.assertThat((boolean)actual.getIncludeEndValue()).isTrue();
                Assertions.assertThat((String)actual.getStartValue()).isEqualTo((Object)"1");
                Assertions.assertThat((String)actual.getEndValue()).isEqualTo((Object)"2");
            }

            public void onError(ClientRuntimeError error) {
                Fail.fail((String)error.getMessage());
            }
        };
        this.service.parseRangeValue("[1..2]", (ServiceCallback)callback);
    }

    @Test
    public void testParseFEELList() {
        ServiceCallback<List<String>> callback = new ServiceCallback<List<String>>(){

            public void onSuccess(List<String> actual) {
                Assertions.assertThat(actual).containsExactly((Object[])new String[]{"one", "two"});
            }

            public void onError(ClientRuntimeError error) {
                Fail.fail((String)error.getMessage());
            }
        };
        this.service.parseFEELList("one,two", (ServiceCallback)callback);
    }
}

