/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.webapp.kogito.common.client.services;

import java.util.Arrays;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.workbench.common.dmn.api.editors.types.RangeValue;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.services.FEELRangeParser;

@RunWith(value=Parameterized.class)
public class FEELRangeParserTest {
    private String input;
    private RangeValue expected;

    @Parameterized.Parameters(name="{index}: input={0}, expected={1}")
    public static Iterable<Object[]> data() {
        return Arrays.asList({null, new RangeValue()}, {"", new RangeValue()}, {".", new RangeValue()}, {"..", new RangeValue()}, {"1..2", new RangeValue()}, {"[1..2", new RangeValue()}, {"1..2]", new RangeValue()}, {"(1..2", new RangeValue()}, {"1..2)", new RangeValue()}, {"[1..2]", new RangeValueBuilder().includeStartValue().includeEndValue().startValue("1").endValue("2").build()}, {"(1..2)", new RangeValueBuilder().startValue("1").endValue("2").build()}, {"[1..2)", new RangeValueBuilder().includeStartValue().startValue("1").endValue("2").build()}, {"(1..2]", new RangeValueBuilder().includeEndValue().startValue("1").endValue("2").build()}, {"( 1..2 )", new RangeValueBuilder().startValue("1").endValue("2").build()}, {"( 1 .. 2 )", new RangeValueBuilder().startValue("1").endValue("2").build()}, {"( 1 . . 2 )", new RangeValue()}, {"[ 1 .. 2 ]", new RangeValueBuilder().includeStartValue().startValue("1").includeEndValue().endValue("2").build()}, {"[ 1.1 .. 2.2 ]", new RangeValueBuilder().includeStartValue().startValue("1.1").includeEndValue().endValue("2.2").build()}, {"[ \"a\" .. \"c\" ]", new RangeValueBuilder().includeStartValue().startValue("\"a\"").includeEndValue().endValue("\"c\"").build()}, {"(..2)", new RangeValue()}, {"(1..)", new RangeValue()}, {"(\"a\"..\"z\")", new RangeValueBuilder().startValue("\"a\"").endValue("\"z\"").build()}, {"(\"a..c\"..\"x..z\")", new RangeValueBuilder().startValue("\"a..c\"").endValue("\"x..z\"").build()}, {"( date ( \"2018-01-01\" ) .. date( \"2018-02-02\" ) )", new RangeValueBuilder().startValue("date ( \"2018-01-01\" )").endValue("date( \"2018-02-02\" )").build()});
    }

    public FEELRangeParserTest(String input, RangeValue expected) {
        this.input = input;
        this.expected = expected;
    }

    @Test
    public void testParsing() {
        RangeValue actual = FEELRangeParser.parse((String)this.input);
        Assertions.assertThat((Object)actual).isEqualTo((Object)this.expected);
    }

    private static class RangeValueBuilder {
        private boolean includeStartValue = false;
        private boolean includeEndValue = false;
        private String startValue = "";
        private String endValue = "";

        private RangeValueBuilder() {
        }

        RangeValueBuilder includeStartValue() {
            this.includeStartValue = true;
            return this;
        }

        RangeValueBuilder includeEndValue() {
            this.includeEndValue = true;
            return this;
        }

        RangeValueBuilder startValue(String value) {
            this.startValue = value;
            return this;
        }

        RangeValueBuilder endValue(String value) {
            this.endValue = value;
            return this;
        }

        RangeValue build() {
            RangeValue rangeValue = new RangeValue();
            rangeValue.setIncludeStartValue(this.includeStartValue);
            rangeValue.setIncludeEndValue(this.includeEndValue);
            rangeValue.setStartValue(this.startValue);
            rangeValue.setEndValue(this.endValue);
            return rangeValue;
        }
    }
}

