/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.webapp.kogito.common.client.editor;

import com.google.gwt.user.client.ui.IsWidget;
import elemental2.dom.DomGlobal;
import elemental2.dom.HTMLElement;
import elemental2.promise.Promise;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.enterprise.event.Event;
import org.jboss.errai.common.client.ui.ElementWrapperWidget;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.kie.workbench.common.dmn.client.commands.general.NavigateToExpressionEditorCommand;
import org.kie.workbench.common.dmn.client.docks.navigator.DecisionNavigatorDock;
import org.kie.workbench.common.dmn.client.editors.expressions.ExpressionEditorView;
import org.kie.workbench.common.dmn.client.editors.included.IncludedModelsPage;
import org.kie.workbench.common.dmn.client.editors.included.imports.IncludedModelsPageStateProviderImpl;
import org.kie.workbench.common.dmn.client.editors.search.DMNEditorSearchIndex;
import org.kie.workbench.common.dmn.client.editors.search.DMNSearchableElement;
import org.kie.workbench.common.dmn.client.editors.types.DataTypePageTabActiveEvent;
import org.kie.workbench.common.dmn.client.editors.types.DataTypesPage;
import org.kie.workbench.common.dmn.client.editors.types.listview.common.DataTypeEditModeToggleEvent;
import org.kie.workbench.common.dmn.client.events.EditExpressionEvent;
import org.kie.workbench.common.dmn.client.session.DMNSession;
import org.kie.workbench.common.dmn.webapp.common.client.docks.preview.PreviewDiagramDock;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.editor.DMNEditorMenuSessionItems;
import org.kie.workbench.common.kogito.client.editor.MultiPageEditorContainerView;
import org.kie.workbench.common.stunner.client.widgets.presenters.session.impl.SessionEditorPresenter;
import org.kie.workbench.common.stunner.client.widgets.presenters.session.impl.SessionViewerPresenter;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.core.client.components.layout.LayoutHelper;
import org.kie.workbench.common.stunner.core.client.components.layout.OpenDiagramLayoutExecutor;
import org.kie.workbench.common.stunner.core.client.error.DiagramClientErrorHandler;
import org.kie.workbench.common.stunner.core.client.i18n.ClientTranslationService;
import org.kie.workbench.common.stunner.core.client.service.ClientRuntimeError;
import org.kie.workbench.common.stunner.core.client.service.ServiceCallback;
import org.kie.workbench.common.stunner.core.client.session.impl.EditorSession;
import org.kie.workbench.common.stunner.core.client.session.impl.ViewerSession;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.documentation.DocumentationView;
import org.kie.workbench.common.stunner.core.graph.processing.layout.LayoutExecutor;
import org.kie.workbench.common.stunner.forms.client.event.RefreshFormPropertiesEvent;
import org.kie.workbench.common.stunner.kogito.api.editor.impl.KogitoDiagramResourceImpl;
import org.kie.workbench.common.stunner.kogito.client.docks.DiagramEditorPropertiesDock;
import org.kie.workbench.common.stunner.kogito.client.editor.AbstractDiagramEditor;
import org.kie.workbench.common.stunner.kogito.client.editor.AbstractDiagramEditorMenuSessionItems;
import org.kie.workbench.common.stunner.kogito.client.editor.DiagramEditorCore;
import org.kie.workbench.common.stunner.kogito.client.editor.event.OnDiagramFocusEvent;
import org.kie.workbench.common.stunner.kogito.client.service.KogitoClientDiagramService;
import org.kie.workbench.common.widgets.client.menu.FileMenuBuilder;
import org.kie.workbench.common.widgets.client.search.common.EditorSearchIndex;
import org.kie.workbench.common.widgets.client.search.component.SearchBarComponent;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartTitleDecoration;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.views.pfly.multipage.MultiPageEditorSelectedPageEvent;
import org.uberfire.client.workbench.events.ChangeTitleWidgetEvent;
import org.uberfire.client.workbench.widgets.common.ErrorPopupPresenter;
import org.uberfire.client.workbench.widgets.multipage.Page;
import org.uberfire.ext.editor.commons.client.menu.MenuItems;
import org.uberfire.ext.widgets.core.client.editors.texteditor.TextEditorView;
import org.uberfire.lifecycle.GetContent;
import org.uberfire.lifecycle.IsDirty;
import org.uberfire.lifecycle.OnClose;
import org.uberfire.lifecycle.OnFocus;
import org.uberfire.lifecycle.OnLostFocus;
import org.uberfire.lifecycle.OnMayClose;
import org.uberfire.lifecycle.OnOpen;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.lifecycle.SetContent;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.events.NotificationEvent;
import org.uberfire.workbench.model.menu.Menus;

public abstract class BaseDMNDiagramEditor
extends AbstractDiagramEditor {
    public static final String PERSPECTIVE_ID = "AuthoringPerspective";
    public static final String EDITOR_ID = "DMNDiagramEditor";
    public static final int DATA_TYPES_PAGE_INDEX = 2;
    protected final SessionManager sessionManager;
    protected final SessionCommandManager<AbstractCanvasHandler> sessionCommandManager;
    protected final Event<RefreshFormPropertiesEvent> refreshFormPropertiesEvent;
    protected final DecisionNavigatorDock decisionNavigatorDock;
    protected final DiagramEditorPropertiesDock diagramPropertiesDock;
    protected final PreviewDiagramDock diagramPreviewAndExplorerDock;
    protected final LayoutHelper layoutHelper;
    protected final OpenDiagramLayoutExecutor openDiagramLayoutExecutor;
    protected final DataTypesPage dataTypesPage;
    protected final IncludedModelsPage includedModelsPage;
    protected final IncludedModelsPageStateProviderImpl importsPageProvider;
    protected final DMNEditorSearchIndex editorSearchIndex;
    protected final SearchBarComponent<DMNSearchableElement> searchBarComponent;
    protected final KogitoClientDiagramService diagramServices;

    public BaseDMNDiagramEditor(DiagramEditorCore.View view, FileMenuBuilder fileMenuBuilder, PlaceManager placeManager, MultiPageEditorContainerView multiPageEditorContainerView, Event<ChangeTitleWidgetEvent> changeTitleNotificationEvent, Event<NotificationEvent> notificationEvent, Event<OnDiagramFocusEvent> onDiagramFocusEvent, TextEditorView xmlEditorView, ManagedInstance<SessionEditorPresenter<EditorSession>> editorSessionPresenterInstances, ManagedInstance<SessionViewerPresenter<ViewerSession>> viewerSessionPresenterInstances, DMNEditorMenuSessionItems menuSessionItems, ErrorPopupPresenter errorPopupPresenter, DiagramClientErrorHandler diagramClientErrorHandler, ClientTranslationService translationService, DocumentationView<Diagram> documentationView, DMNEditorSearchIndex editorSearchIndex, SearchBarComponent<DMNSearchableElement> searchBarComponent, SessionManager sessionManager, SessionCommandManager<AbstractCanvasHandler> sessionCommandManager, Event<RefreshFormPropertiesEvent> refreshFormPropertiesEvent, DecisionNavigatorDock decisionNavigatorDock, DiagramEditorPropertiesDock diagramPropertiesDock, PreviewDiagramDock diagramPreviewAndExplorerDock, LayoutHelper layoutHelper, OpenDiagramLayoutExecutor openDiagramLayoutExecutor, DataTypesPage dataTypesPage, IncludedModelsPage includedModelsPage, IncludedModelsPageStateProviderImpl importsPageProvider, KogitoClientDiagramService diagramServices) {
        super(view, fileMenuBuilder, placeManager, multiPageEditorContainerView, changeTitleNotificationEvent, notificationEvent, onDiagramFocusEvent, xmlEditorView, editorSessionPresenterInstances, viewerSessionPresenterInstances, (AbstractDiagramEditorMenuSessionItems)menuSessionItems, errorPopupPresenter, diagramClientErrorHandler, translationService, documentationView);
        this.sessionManager = sessionManager;
        this.sessionCommandManager = sessionCommandManager;
        this.refreshFormPropertiesEvent = refreshFormPropertiesEvent;
        this.decisionNavigatorDock = decisionNavigatorDock;
        this.diagramPropertiesDock = diagramPropertiesDock;
        this.diagramPreviewAndExplorerDock = diagramPreviewAndExplorerDock;
        this.layoutHelper = layoutHelper;
        this.openDiagramLayoutExecutor = openDiagramLayoutExecutor;
        this.dataTypesPage = dataTypesPage;
        this.includedModelsPage = includedModelsPage;
        this.importsPageProvider = importsPageProvider;
        this.editorSearchIndex = editorSearchIndex;
        this.searchBarComponent = searchBarComponent;
        this.diagramServices = diagramServices;
    }

    @OnStartup
    public void onStartup(PlaceRequest place) {
        this.superDoStartUp(place);
        this.decisionNavigatorDock.init(PERSPECTIVE_ID);
        this.diagramPropertiesDock.init(PERSPECTIVE_ID);
        this.diagramPreviewAndExplorerDock.init(PERSPECTIVE_ID);
    }

    void superDoStartUp(PlaceRequest place) {
        super.doStartUp(place);
    }

    public void initialiseKieEditorForSession(Diagram diagram) {
        this.superInitialiseKieEditorForSession(diagram);
        this.getWidget().getMultiPage().addPage((Page)this.dataTypesPage);
        this.getWidget().getMultiPage().addPage((Page)this.includedModelsPage);
        this.setupEditorSearchIndex();
        this.setupSearchComponent();
    }

    private void setupEditorSearchIndex() {
        this.editorSearchIndex.setCurrentAssetHashcodeSupplier(this.getHashcodeSupplier());
        this.editorSearchIndex.setIsDataTypesTabActiveSupplier(this.getIsDataTypesTabActiveSupplier());
    }

    Supplier<Integer> getHashcodeSupplier() {
        return () -> ((BaseDMNDiagramEditor)this).getCurrentDiagramHash();
    }

    Supplier<Boolean> getIsDataTypesTabActiveSupplier() {
        return () -> {
            int selectedPageIndex = this.getWidget().getMultiPage().selectedPage();
            return selectedPageIndex == 2;
        };
    }

    void setupSearchComponent() {
        HTMLElement element = this.searchBarComponent.getView().getElement();
        this.searchBarComponent.init((EditorSearchIndex)this.editorSearchIndex);
        this.getWidget().getMultiPage().addTabBarWidget(this.getWidget(element));
    }

    protected ElementWrapperWidget<?> getWidget(HTMLElement element) {
        return ElementWrapperWidget.getWidget((HTMLElement)element);
    }

    public void onDataTypePageNavTabActiveEvent(DataTypePageTabActiveEvent event) {
        this.getWidget().getMultiPage().selectPage(2);
    }

    void superInitialiseKieEditorForSession(Diagram diagram) {
        super.initialiseKieEditorForSession(diagram);
    }

    public void open(Diagram diagram) {
        this.layoutHelper.applyLayout(diagram, (LayoutExecutor)this.openDiagramLayoutExecutor);
        super.open(diagram);
    }

    @OnOpen
    public void onOpen() {
        super.doOpen();
    }

    @OnClose
    public void onClose() {
        this.superOnClose();
        this.decisionNavigatorDock.destroy();
        this.decisionNavigatorDock.resetContent();
        this.diagramPropertiesDock.destroy();
        this.diagramPreviewAndExplorerDock.destroy();
        this.dataTypesPage.disableShortcuts();
    }

    void superOnClose() {
        super.doClose();
    }

    @OnFocus
    public void onFocus() {
        this.superDoFocus();
        this.onDiagramLoad();
        this.dataTypesPage.onFocus();
        this.dataTypesPage.enableShortcuts();
    }

    void superDoFocus() {
        super.doFocus();
    }

    @OnLostFocus
    public void onLostFocus() {
        super.doLostFocus();
        this.dataTypesPage.onLostFocus();
    }

    @WorkbenchPartTitleDecoration
    public IsWidget getTitle() {
        return super.getTitle();
    }

    @WorkbenchPartTitle
    public String getTitleText() {
        return "";
    }

    @WorkbenchMenu
    public void getMenus(Consumer<Menus> menusConsumer) {
        menusConsumer.accept(super.getMenus());
    }

    protected void makeMenuBar() {
        if (!this.menuBarInitialized) {
            this.getMenuSessionItems().populateMenu(this.getFileMenuBuilder());
            this.makeAdditionalStunnerMenus(this.getFileMenuBuilder());
            this.menuBarInitialized = true;
        }
    }

    @WorkbenchPartView
    public IsWidget asWidget() {
        return super.asWidget();
    }

    @OnMayClose
    public boolean onMayClose() {
        return super.mayClose();
    }

    public String getEditorIdentifier() {
        return EDITOR_ID;
    }

    public void onDataTypeEditModeToggle(DataTypeEditModeToggleEvent event) {
        this.scheduleOnDataTypeEditModeToggleCallback(event);
    }

    protected void scheduleOnDataTypeEditModeToggleCallback(DataTypeEditModeToggleEvent event) {
        DomGlobal.setTimeout((DomGlobal.SetTimeoutCallbackFn)this.getOnDataTypeEditModeToggleCallback(event), (double)250.0, (Object[])new Object[0]);
    }

    protected DomGlobal.SetTimeoutCallbackFn getOnDataTypeEditModeToggleCallback(DataTypeEditModeToggleEvent event) {
        return e -> {
            if (event.isEditModeEnabled()) {
                this.disableMenuItem(MenuItems.SAVE);
            } else {
                this.enableMenuItem(MenuItems.SAVE);
            }
        };
    }

    protected void onMultiPageEditorSelectedPageEvent(MultiPageEditorSelectedPageEvent event) {
        this.searchBarComponent.disableSearch();
    }

    protected void onRefreshFormPropertiesEvent(RefreshFormPropertiesEvent event) {
        this.searchBarComponent.disableSearch();
    }

    protected void onEditExpressionEvent(EditExpressionEvent event) {
        this.searchBarComponent.disableSearch();
        if (this.isSameSession(event.getSession())) {
            DMNSession session = (DMNSession)this.sessionManager.getCurrentSession();
            ExpressionEditorView.Presenter expressionEditor = session.getExpressionEditor();
            this.sessionCommandManager.execute((Object)session.getCanvasHandler(), (Command)new NavigateToExpressionEditorCommand(expressionEditor, this.getSessionPresenter(), this.sessionManager, this.sessionCommandManager, this.refreshFormPropertiesEvent, event.getNodeUUID(), event.getHasExpression(), event.getHasName(), event.isOnlyVisualChangeAllowed()));
        }
    }

    @GetContent
    public Promise getContent() {
        return this.diagramServices.transform((KogitoDiagramResourceImpl)this.getEditor().getEditorProxy().getContentSupplier().get());
    }

    @IsDirty
    public boolean isDirty() {
        return super.isDirty();
    }

    @SetContent
    public void setContent(String value) {
        this.diagramServices.transform(value, (ServiceCallback)new ServiceCallback<Diagram>(){

            public void onSuccess(Diagram diagram) {
                BaseDMNDiagramEditor.this.getEditor().open(diagram);
            }

            public void onError(ClientRuntimeError error) {
                BaseDMNDiagramEditor.this.getEditor().onLoadError(error);
            }
        });
    }

    public void resetContentHash() {
        this.setOriginalContentHash(this.getCurrentDiagramHash());
    }
}

