/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.webapp.kogito.common.client.services;

import java.util.Objects;
import org.kie.workbench.common.dmn.api.editors.types.RangeValue;
import org.kie.workbench.common.stunner.core.util.StringUtils;

public class FEELRangeParser {
    private static final String SEPARATOR = "..";
    private static final int SEPARATOR_LENGTH = "..".length();
    private static final String INCLUDE_START = "[";
    private static final String EXCLUDE_START = "(";
    private static final String INCLUDE_END = "]";
    private static final String EXCLUDE_END = ")";

    public static RangeValue parse(String input) {
        RangeValue rangeValue = new RangeValue();
        if (Objects.isNull(input)) {
            return rangeValue;
        }
        String trimmedInput = input.trim();
        if (!trimmedInput.startsWith(INCLUDE_START) && !trimmedInput.startsWith(EXCLUDE_START)) {
            return rangeValue;
        }
        if (!trimmedInput.endsWith(INCLUDE_END) && !trimmedInput.endsWith(EXCLUDE_END)) {
            return rangeValue;
        }
        boolean inQuotes = false;
        boolean includeStartValue = trimmedInput.startsWith(INCLUDE_START);
        boolean includeEndValue = trimmedInput.endsWith(INCLUDE_END);
        String startValue = "";
        String endValue = "";
        for (int current = 0; current < trimmedInput.length(); ++current) {
            if (trimmedInput.charAt(current) == '\"') {
                boolean bl = inQuotes = !inQuotes;
            }
            if (!FEELRangeParser.isSeparator(current, inQuotes, trimmedInput)) continue;
            startValue = trimmedInput.substring(1, current).trim();
            endValue = trimmedInput.substring(current + SEPARATOR_LENGTH, trimmedInput.length() - 1).trim();
            break;
        }
        if (StringUtils.isEmpty((String)startValue) || StringUtils.isEmpty((String)endValue)) {
            return rangeValue;
        }
        rangeValue.setIncludeStartValue(includeStartValue);
        rangeValue.setStartValue(startValue);
        rangeValue.setIncludeEndValue(includeEndValue);
        rangeValue.setEndValue(endValue);
        return rangeValue;
    }

    private static boolean isSeparator(int current, boolean inQuotes, String trimmedInput) {
        if (inQuotes) {
            return false;
        }
        if (current > trimmedInput.length() - SEPARATOR_LENGTH) {
            return false;
        }
        return trimmedInput.substring(current, current + SEPARATOR_LENGTH).equals(SEPARATOR);
    }
}

