/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.webapp.kogito.common.client.services;

import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.services.FEELListParser;

@RunWith(value=Parameterized.class)
public class FEELListParserTest {
    protected String input;
    protected String[] expected;

    @Parameterized.Parameters(name="{index}: input={0}, expected={1}")
    public static Iterable<Object[]> data() {
        return Arrays.asList({null, new String[0]}, {"", new String[0]}, {"one", new String[]{"one"}}, {"one,two", new String[]{"one", "two"}}, {"\"one,two\"", new String[]{"\"one,two\""}}, {"one ,two", new String[]{"one", "two"}}, {"one, two", new String[]{"one", "two"}}, {"\"one\",two", new String[]{"\"one\"", "two"}}, {"\"one\",\"two\"", new String[]{"\"one\"", "\"two\""}}, {"\"\"one\"\",\"\"two\"\"", new String[]{"\"\"one\"\"", "\"\"two\"\""}}, {"\"one,two\",\"three\"", new String[]{"\"one,two\"", "\"three\""}}, {"\"one,two\",three", new String[]{"\"one,two\"", "three"}}, {"\"one\", \"two\", \"three\"", new String[]{"\"one\"", "\"two\"", "\"three\""}}, {"one, \"two\", three", new String[]{"one", "\"two\"", "three"}}, {"\"one\", two, \"three\"", new String[]{"\"one\"", "two", "\"three\""}}, {"\"one, two\", \"three\"", new String[]{"\"one, two\"", "\"three\""}}, {" one , two , three ", new String[]{"one", "two", "three"}}, {"\"NY, Long Street, 123\"", new String[]{"\"NY, Long Street, 123\""}});
    }

    public FEELListParserTest(String input, String[] expected) {
        this.input = input;
        this.expected = expected;
    }

    @Test
    public void testParsing() {
        List actual = FEELListParser.parse((String)this.input);
        Assertions.assertThat((int)actual.size()).isEqualTo(this.expected.length);
        Assertions.assertThat((List)actual).containsExactly((Object[])this.expected);
    }
}

