/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.webapp.kogito.common.client.services;

import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.services.FEELSyntaxLightValidator;

public class FEELSyntaxLightValidatorTest {
    @Test
    public void testValidationWhenVariableNameIsEmpty() {
        Assertions.assertThat((boolean)FEELSyntaxLightValidator.isVariableNameValid((String)"")).isFalse();
        Assertions.assertThat((boolean)FEELSyntaxLightValidator.isVariableNameValid(null)).isFalse();
    }

    @Test
    public void testValidationWhenVariableNameStartsWithValidSymbol() {
        Assertions.assertThat((boolean)FEELSyntaxLightValidator.isVariableNameValid((String)"_variable")).isTrue();
        Assertions.assertThat((boolean)FEELSyntaxLightValidator.isVariableNameValid((String)"?variable")).isTrue();
    }

    @Test
    public void testValidationWhenVariableNameStartsWithNumber() {
        Assertions.assertThat((boolean)FEELSyntaxLightValidator.isVariableNameValid((String)"2variable")).isFalse();
    }

    @Test
    public void testValidationWhenVariableNameStartsWithInvalidSymbol() {
        Assertions.assertThat((boolean)FEELSyntaxLightValidator.isVariableNameValid((String)"@variable")).isFalse();
    }

    @Test
    public void testValidationWhenVariableNameStartsWithReservedKeyword() {
        Assertions.assertThat((boolean)FEELSyntaxLightValidator.isVariableNameValid((String)"for variable")).isFalse();
        Assertions.assertThat((boolean)FEELSyntaxLightValidator.isVariableNameValid((String)"for-name")).isFalse();
        Assertions.assertThat((boolean)FEELSyntaxLightValidator.isVariableNameValid((String)"for.name")).isFalse();
        Assertions.assertThat((boolean)FEELSyntaxLightValidator.isVariableNameValid((String)"for/name")).isFalse();
        Assertions.assertThat((boolean)FEELSyntaxLightValidator.isVariableNameValid((String)"for'name")).isFalse();
        Assertions.assertThat((boolean)FEELSyntaxLightValidator.isVariableNameValid((String)"for*name")).isFalse();
        Assertions.assertThat((boolean)FEELSyntaxLightValidator.isVariableNameValid((String)"for+name")).isFalse();
    }

    @Test
    public void testValidationWhenVariableNameIsSimpleCharSequence() {
        Assertions.assertThat((boolean)FEELSyntaxLightValidator.isVariableNameValid((String)" valid variable name")).isTrue();
        Assertions.assertThat((boolean)FEELSyntaxLightValidator.isVariableNameValid((String)"valid variable name")).isTrue();
        Assertions.assertThat((boolean)FEELSyntaxLightValidator.isVariableNameValid((String)"for_name")).isTrue();
        Assertions.assertThat((boolean)FEELSyntaxLightValidator.isVariableNameValid((String)"form name")).isTrue();
    }

    @Test
    public void testValidationWhenVariableNameContainsValidSymbols() {
        Assertions.assertThat((boolean)FEELSyntaxLightValidator.isVariableNameValid((String)"?_873./-'+*valid")).isTrue();
    }

    @Test
    public void testValidationWhenVariableNameContainsStrangeButValidSymbols() {
        Assertions.assertThat((boolean)FEELSyntaxLightValidator.isVariableNameValid((String)"\ud83d\udc0e")).isTrue();
        Assertions.assertThat((boolean)FEELSyntaxLightValidator.isVariableNameValid((String)"\u7248")).isTrue();
    }

    @Test
    public void testValidationWhenVariableNameContainsReservedKeyword() {
        Assertions.assertThat((boolean)FEELSyntaxLightValidator.isVariableNameValid((String)"name for variable")).isTrue();
    }

    @Test
    public void testValidationWhenVariableNameIsReservedKeyword() {
        Assertions.assertThat((boolean)FEELSyntaxLightValidator.isVariableNameValid((String)"for")).isFalse();
        Assertions.assertThat((boolean)FEELSyntaxLightValidator.isVariableNameValid((String)"return")).isFalse();
        Assertions.assertThat((boolean)FEELSyntaxLightValidator.isVariableNameValid((String)"if")).isFalse();
        Assertions.assertThat((boolean)FEELSyntaxLightValidator.isVariableNameValid((String)"then")).isFalse();
        Assertions.assertThat((boolean)FEELSyntaxLightValidator.isVariableNameValid((String)"else")).isFalse();
        Assertions.assertThat((boolean)FEELSyntaxLightValidator.isVariableNameValid((String)"some")).isFalse();
        Assertions.assertThat((boolean)FEELSyntaxLightValidator.isVariableNameValid((String)"every")).isFalse();
        Assertions.assertThat((boolean)FEELSyntaxLightValidator.isVariableNameValid((String)"satisfies")).isFalse();
        Assertions.assertThat((boolean)FEELSyntaxLightValidator.isVariableNameValid((String)"instance")).isFalse();
        Assertions.assertThat((boolean)FEELSyntaxLightValidator.isVariableNameValid((String)"of")).isFalse();
        Assertions.assertThat((boolean)FEELSyntaxLightValidator.isVariableNameValid((String)"in")).isFalse();
        Assertions.assertThat((boolean)FEELSyntaxLightValidator.isVariableNameValid((String)"function")).isFalse();
        Assertions.assertThat((boolean)FEELSyntaxLightValidator.isVariableNameValid((String)"external")).isFalse();
        Assertions.assertThat((boolean)FEELSyntaxLightValidator.isVariableNameValid((String)"or")).isFalse();
        Assertions.assertThat((boolean)FEELSyntaxLightValidator.isVariableNameValid((String)"and")).isFalse();
        Assertions.assertThat((boolean)FEELSyntaxLightValidator.isVariableNameValid((String)"between")).isFalse();
        Assertions.assertThat((boolean)FEELSyntaxLightValidator.isVariableNameValid((String)"not")).isFalse();
        Assertions.assertThat((boolean)FEELSyntaxLightValidator.isVariableNameValid((String)"null")).isFalse();
        Assertions.assertThat((boolean)FEELSyntaxLightValidator.isVariableNameValid((String)"true")).isFalse();
        Assertions.assertThat((boolean)FEELSyntaxLightValidator.isVariableNameValid((String)"false")).isFalse();
    }

    @Test
    public void testValidationWhenVariableNameContainsInvalidCharacters() {
        Assertions.assertThat((boolean)FEELSyntaxLightValidator.isVariableNameValid((String)"variable ! name")).isFalse();
        Assertions.assertThat((boolean)FEELSyntaxLightValidator.isVariableNameValid((String)"variable @ name")).isFalse();
        Assertions.assertThat((boolean)FEELSyntaxLightValidator.isVariableNameValid((String)"variable # name")).isFalse();
        Assertions.assertThat((boolean)FEELSyntaxLightValidator.isVariableNameValid((String)"variable $ name")).isFalse();
        Assertions.assertThat((boolean)FEELSyntaxLightValidator.isVariableNameValid((String)"variable $ name")).isFalse();
        Assertions.assertThat((boolean)FEELSyntaxLightValidator.isVariableNameValid((String)"variable % name")).isFalse();
        Assertions.assertThat((boolean)FEELSyntaxLightValidator.isVariableNameValid((String)"variable & name")).isFalse();
        Assertions.assertThat((boolean)FEELSyntaxLightValidator.isVariableNameValid((String)"variable ^ name")).isFalse();
        Assertions.assertThat((boolean)FEELSyntaxLightValidator.isVariableNameValid((String)"variable ( name")).isFalse();
        Assertions.assertThat((boolean)FEELSyntaxLightValidator.isVariableNameValid((String)"variable ) name")).isFalse();
        Assertions.assertThat((boolean)FEELSyntaxLightValidator.isVariableNameValid((String)"variable \" name")).isFalse();
        Assertions.assertThat((boolean)FEELSyntaxLightValidator.isVariableNameValid((String)"variable \u00b0 name")).isFalse();
        Assertions.assertThat((boolean)FEELSyntaxLightValidator.isVariableNameValid((String)"variable \u00a7 name")).isFalse();
        Assertions.assertThat((boolean)FEELSyntaxLightValidator.isVariableNameValid((String)"variable \u2190 name")).isFalse();
        Assertions.assertThat((boolean)FEELSyntaxLightValidator.isVariableNameValid((String)"variable \u2192 name")).isFalse();
        Assertions.assertThat((boolean)FEELSyntaxLightValidator.isVariableNameValid((String)"variable \u2193 name")).isFalse();
        Assertions.assertThat((boolean)FEELSyntaxLightValidator.isVariableNameValid((String)"variable \u00a2 name")).isFalse();
        Assertions.assertThat((boolean)FEELSyntaxLightValidator.isVariableNameValid((String)"variable \u00b5 name")).isFalse();
        Assertions.assertThat((boolean)FEELSyntaxLightValidator.isVariableNameValid((String)"variable { name")).isFalse();
        Assertions.assertThat((boolean)FEELSyntaxLightValidator.isVariableNameValid((String)"variable } name")).isFalse();
        Assertions.assertThat((boolean)FEELSyntaxLightValidator.isVariableNameValid((String)"variable [ name")).isFalse();
        Assertions.assertThat((boolean)FEELSyntaxLightValidator.isVariableNameValid((String)"variable ] name")).isFalse();
        Assertions.assertThat((boolean)FEELSyntaxLightValidator.isVariableNameValid((String)"variable | name")).isFalse();
        Assertions.assertThat((boolean)FEELSyntaxLightValidator.isVariableNameValid((String)"variable \\ name")).isFalse();
        Assertions.assertThat((boolean)FEELSyntaxLightValidator.isVariableNameValid((String)"variable = name")).isFalse();
        Assertions.assertThat((boolean)FEELSyntaxLightValidator.isVariableNameValid((String)"variable < name")).isFalse();
        Assertions.assertThat((boolean)FEELSyntaxLightValidator.isVariableNameValid((String)"variable > name")).isFalse();
        Assertions.assertThat((boolean)FEELSyntaxLightValidator.isVariableNameValid((String)"variable ; name")).isFalse();
        Assertions.assertThat((boolean)FEELSyntaxLightValidator.isVariableNameValid((String)"variable : name")).isFalse();
        Assertions.assertThat((boolean)FEELSyntaxLightValidator.isVariableNameValid((String)"variable , name")).isFalse();
        Assertions.assertThat((boolean)FEELSyntaxLightValidator.isVariableNameValid((String)"variable \u00b6 name")).isFalse();
        Assertions.assertThat((boolean)FEELSyntaxLightValidator.isVariableNameValid((String)"variable \u00ab name")).isFalse();
        Assertions.assertThat((boolean)FEELSyntaxLightValidator.isVariableNameValid((String)"variable \u00bb name")).isFalse();
        Assertions.assertThat((boolean)FEELSyntaxLightValidator.isVariableNameValid((String)"variable \u201d name")).isFalse();
        Assertions.assertThat((boolean)FEELSyntaxLightValidator.isVariableNameValid((String)"variable \u201c name")).isFalse();
    }
}

