/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.Arrays;
import jsinterop.base.JsArrayLike;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.Import;
import org.kie.workbench.common.dmn.api.definition.model.ImportDMN;
import org.kie.workbench.common.dmn.api.definition.model.ImportPMML;
import org.kie.workbench.common.dmn.api.editors.included.DMNImportTypes;
import org.kie.workbench.common.dmn.api.editors.included.PMMLDocumentMetadata;
import org.kie.workbench.common.dmn.api.editors.included.PMMLModelMetadata;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model.ImportConverter;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITDRGElement;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITDefinitions;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITImport;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITItemDefinition;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class ImportConverterTest {
    private static final String LOCATION_URI = "test.uri";
    private static final String NAMESPACE = "test.namespace";
    private static final String NAME = "name";
    private static final String DESCRIPTION = "file description";
    private static final String DMN_IMPORT_TYPE = "http://www.omg.org/spec/DMN/20180521/MODEL/";
    private static final String PMML_IMPORT_TYPE = "http://www.dmg.org/PMML-4_3";
    @Mock
    private JSITImport jsitImportMock;
    @Mock
    private JSITDefinitions jsitDefinitionsMock;
    @Mock
    private JsArrayLike<JSITDRGElement> JSITDRGElementsMock;
    private PMMLDocumentMetadata pmmlDocumentMetadata;

    @Before
    public void setup() {
        Mockito.when((Object)this.jsitImportMock.getLocationURI()).thenReturn((Object)LOCATION_URI);
        Mockito.when((Object)this.jsitImportMock.getNamespace()).thenReturn((Object)NAMESPACE);
        Mockito.when((Object)this.jsitImportMock.getName()).thenReturn((Object)NAME);
        Mockito.when((Object)this.jsitImportMock.getDescription()).thenReturn((Object)DESCRIPTION);
        this.pmmlDocumentMetadata = new PMMLDocumentMetadata("test.pmml", DMNImportTypes.PMML.toString(), new ArrayList());
    }

    @Test
    public void wbFromDMN_DMNImport() {
        Mockito.when((Object)this.jsitImportMock.getImportType()).thenReturn((Object)DMN_IMPORT_TYPE);
        Mockito.when((Object)this.jsitDefinitionsMock.getDrgElement()).thenReturn(new ArrayList<JSITDRGElement>(Arrays.asList((JSITDRGElement)Mockito.mock(JSITDRGElement.class), (JSITDRGElement)Mockito.mock(JSITDRGElement.class))));
        Mockito.when((Object)this.jsitDefinitionsMock.getItemDefinition()).thenReturn(new ArrayList<JSITItemDefinition>(Arrays.asList((JSITItemDefinition)Mockito.mock(JSITItemDefinition.class))));
        Import resultImport = ImportConverter.wbFromDMN((JSITImport)this.jsitImportMock, (JSITDefinitions)this.jsitDefinitionsMock, null);
        Assert.assertTrue((boolean)(resultImport instanceof ImportDMN));
        Assert.assertEquals((Object)NAMESPACE, (Object)resultImport.getNamespace());
        Assert.assertEquals((Object)LOCATION_URI, (Object)resultImport.getLocationURI().getValue());
        Assert.assertEquals((Object)DESCRIPTION, (Object)resultImport.getDescription().getValue());
        Assert.assertEquals((Object)NAME, (Object)resultImport.getName().getValue());
        Assert.assertEquals((Object)DMN_IMPORT_TYPE, (Object)resultImport.getImportType());
        Assert.assertEquals((long)2L, (long)((ImportDMN)resultImport).getDrgElementsCount());
        Assert.assertEquals((long)1L, (long)((ImportDMN)resultImport).getItemDefinitionsCount());
    }

    @Test
    public void wbFromDMN_DMNImportNoDefinition() {
        Mockito.when((Object)this.jsitImportMock.getImportType()).thenReturn((Object)DMN_IMPORT_TYPE);
        Mockito.when((Object)this.jsitDefinitionsMock.getDrgElement()).thenReturn(new ArrayList<JSITDRGElement>(Arrays.asList((JSITDRGElement)Mockito.mock(JSITDRGElement.class), (JSITDRGElement)Mockito.mock(JSITDRGElement.class))));
        Mockito.when((Object)this.jsitDefinitionsMock.getItemDefinition()).thenReturn(new ArrayList<JSITItemDefinition>(Arrays.asList((JSITItemDefinition)Mockito.mock(JSITItemDefinition.class))));
        Import resultImport = ImportConverter.wbFromDMN((JSITImport)this.jsitImportMock, null, null);
        Assert.assertTrue((boolean)(resultImport instanceof ImportDMN));
        Assert.assertEquals((Object)NAMESPACE, (Object)resultImport.getNamespace());
        Assert.assertEquals((Object)LOCATION_URI, (Object)resultImport.getLocationURI().getValue());
        Assert.assertEquals((Object)DESCRIPTION, (Object)resultImport.getDescription().getValue());
        Assert.assertEquals((Object)NAME, (Object)resultImport.getName().getValue());
        Assert.assertEquals((Object)DMN_IMPORT_TYPE, (Object)resultImport.getImportType());
        Assert.assertEquals((long)0L, (long)((ImportDMN)resultImport).getDrgElementsCount());
        Assert.assertEquals((long)0L, (long)((ImportDMN)resultImport).getItemDefinitionsCount());
    }

    @Test
    public void wbFromDMN_PMMLImportNoModels() {
        Mockito.when((Object)this.jsitImportMock.getImportType()).thenReturn((Object)PMML_IMPORT_TYPE);
        Import resultImport = ImportConverter.wbFromDMN((JSITImport)this.jsitImportMock, null, (PMMLDocumentMetadata)this.pmmlDocumentMetadata);
        Assert.assertTrue((boolean)(resultImport instanceof ImportPMML));
        Assert.assertEquals((Object)LOCATION_URI, (Object)resultImport.getLocationURI().getValue());
        Assert.assertEquals((Object)NAME, (Object)resultImport.getNamespace());
        Assert.assertEquals((Object)DESCRIPTION, (Object)resultImport.getDescription().getValue());
        Assert.assertEquals((Object)NAME, (Object)resultImport.getName().getValue());
        Assert.assertEquals((Object)PMML_IMPORT_TYPE, (Object)resultImport.getImportType());
        Assert.assertNotNull((Object)resultImport.getId().getValue());
        Assert.assertEquals((long)0L, (long)((ImportPMML)resultImport).getModelCount());
    }

    @Test
    public void wbFromDMN_PMMLImportWithModels() {
        Mockito.when((Object)this.jsitImportMock.getImportType()).thenReturn((Object)PMML_IMPORT_TYPE);
        this.pmmlDocumentMetadata.getModels().add(new PMMLModelMetadata("modelName", null));
        Import resultImport = ImportConverter.wbFromDMN((JSITImport)this.jsitImportMock, null, (PMMLDocumentMetadata)this.pmmlDocumentMetadata);
        Assert.assertTrue((boolean)(resultImport instanceof ImportPMML));
        Assert.assertEquals((Object)LOCATION_URI, (Object)resultImport.getLocationURI().getValue());
        Assert.assertEquals((Object)NAME, (Object)resultImport.getNamespace());
        Assert.assertEquals((Object)DESCRIPTION, (Object)resultImport.getDescription().getValue());
        Assert.assertEquals((Object)NAME, (Object)resultImport.getName().getValue());
        Assert.assertEquals((Object)PMML_IMPORT_TYPE, (Object)resultImport.getImportType());
        Assert.assertNotNull((Object)resultImport.getId().getValue());
        Assert.assertEquals((long)1L, (long)((ImportPMML)resultImport).getModelCount());
    }

    @Test
    public void wbFromDMN_PMMLImportNoPmmlModelMetadata() {
        Mockito.when((Object)this.jsitImportMock.getImportType()).thenReturn((Object)PMML_IMPORT_TYPE);
        this.pmmlDocumentMetadata.getModels().add(new PMMLModelMetadata("modelName", null));
        Import resultImport = ImportConverter.wbFromDMN((JSITImport)this.jsitImportMock, null, null);
        Assert.assertTrue((boolean)(resultImport instanceof ImportPMML));
        Assert.assertEquals((Object)LOCATION_URI, (Object)resultImport.getLocationURI().getValue());
        Assert.assertEquals((Object)NAME, (Object)resultImport.getNamespace());
        Assert.assertEquals((Object)DESCRIPTION, (Object)resultImport.getDescription().getValue());
        Assert.assertEquals((Object)NAME, (Object)resultImport.getName().getValue());
        Assert.assertEquals((Object)PMML_IMPORT_TYPE, (Object)resultImport.getImportType());
        Assert.assertNotNull((Object)resultImport.getId().getValue());
        Assert.assertEquals((long)0L, (long)((ImportPMML)resultImport).getModelCount());
    }
}

