/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.webapp.kogito.common.client.converters;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.appformer.kogito.bridge.client.pmmleditor.marshaller.model.PMMLDocumentData;
import org.appformer.kogito.bridge.client.pmmleditor.marshaller.model.PMMLModelData;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.editors.included.PMMLDocumentMetadata;
import org.kie.workbench.common.dmn.api.editors.included.PMMLModelMetadata;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.PMMLMarshallerConverter;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={PMMLDocumentData.class, PMMLModelData.class})
public class PMMLMarshallerConverterTest {
    private static final String FILENAME = "fileName.pmml";
    private static final String PATH = "test/fileName.pmml";
    private static final String UNDEFINED = "undefined";

    @Test
    public void fromJSInteropToMetadata_EmptyModels() {
        PMMLDocumentData pmmlDocumentDataMock = (PMMLDocumentData)PowerMockito.mock(PMMLDocumentData.class);
        PowerMockito.when((Object)pmmlDocumentDataMock.getModels()).thenReturn(Collections.emptyList());
        PMMLDocumentMetadata metadata = PMMLMarshallerConverter.fromJSInteropToMetadata((String)PATH, (PMMLDocumentData)pmmlDocumentDataMock);
        Assert.assertEquals((Object)PATH, (Object)metadata.getPath());
        Assert.assertEquals((Object)UNDEFINED, (Object)metadata.getName());
        Assert.assertEquals((long)0L, (long)metadata.getModels().size());
    }

    @Test
    public void fromJSInteropToMetadata_WithModels() {
        String modelName = "LinearRegression";
        String[] fieldsNames = new String[]{"field1", "field2"};
        List<String> fields = Arrays.asList(fieldsNames);
        ArrayList<PMMLModelData> modelsData = new ArrayList<PMMLModelData>();
        PMMLModelData pmmlModelDataMock = (PMMLModelData)PowerMockito.mock(PMMLModelData.class);
        modelsData.add(pmmlModelDataMock);
        PowerMockito.when((Object)pmmlModelDataMock.getModelName()).thenReturn((Object)"LinearRegression");
        PowerMockito.when((Object)pmmlModelDataMock.getFields()).thenReturn(fields);
        PMMLDocumentData pmmlDocumentDataMock = (PMMLDocumentData)PowerMockito.mock(PMMLDocumentData.class);
        PowerMockito.when((Object)pmmlDocumentDataMock.getModels()).thenReturn(modelsData);
        PMMLDocumentMetadata metadata = PMMLMarshallerConverter.fromJSInteropToMetadata((String)PATH, (PMMLDocumentData)pmmlDocumentDataMock);
        Assert.assertEquals((Object)PATH, (Object)metadata.getPath());
        Assert.assertEquals((Object)UNDEFINED, (Object)metadata.getName());
        Assert.assertEquals((long)1L, (long)metadata.getModels().size());
        Assert.assertEquals((Object)"LinearRegression", (Object)((PMMLModelMetadata)metadata.getModels().get(0)).getName());
        Assert.assertEquals((long)fieldsNames.length, (long)((PMMLModelMetadata)metadata.getModels().get(0)).getInputParameters().size());
    }
}

