/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model;

import com.google.gwtmockito.GwtMock;
import com.google.gwtmockito.GwtMockitoTestRunner;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.model.ImportedValues;
import org.kie.workbench.common.dmn.api.definition.model.IsLiteralExpression;
import org.kie.workbench.common.dmn.api.definition.model.LiteralExpression;
import org.kie.workbench.common.dmn.api.property.dmn.Description;
import org.kie.workbench.common.dmn.api.property.dmn.ExpressionLanguage;
import org.kie.workbench.common.dmn.api.property.dmn.Id;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.api.property.dmn.Text;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model.LiteralExpressionPropertyConverter;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITImportedValues;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITLiteralExpression;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class LiteralExpressionPropertyConverterTest {
    private static final String UUID = "uuid";
    private static final String TEXT = "text";
    private static final String DESCRIPTION = "description";
    private static final String IMPORTED_ELEMENT = "imported-element";
    private static final String EXPRESSION_LANGUAGE = "expression-language";
    private static final String TYPE_REF = "type-ref";
    @GwtMock
    private JSITLiteralExpression dmn;
    @GwtMock
    private LiteralExpression wb;
    @GwtMock
    private JSITImportedValues jsitImportedValues;
    @GwtMock
    private ImportedValues importedValues;

    @Test
    public void testWBFromDMN() {
        Mockito.when((Object)this.dmn.getId()).thenReturn((Object)UUID);
        Mockito.when((Object)this.dmn.getDescription()).thenReturn((Object)DESCRIPTION);
        Mockito.when((Object)this.dmn.getTypeRef()).thenReturn((Object)TYPE_REF);
        Mockito.when((Object)this.dmn.getText()).thenReturn((Object)TEXT);
        Mockito.when((Object)this.dmn.getExpressionLanguage()).thenReturn((Object)EXPRESSION_LANGUAGE);
        Mockito.when((Object)this.dmn.getImportedValues()).thenReturn((Object)this.jsitImportedValues);
        Mockito.when((Object)this.jsitImportedValues.getImportedElement()).thenReturn((Object)IMPORTED_ELEMENT);
        LiteralExpression result = LiteralExpressionPropertyConverter.wbFromDMN((JSITLiteralExpression)this.dmn);
        Assertions.assertThat((String)result.getId().getValue()).isEqualTo(UUID);
        Assertions.assertThat((String)result.getDescription().getValue()).isEqualTo(DESCRIPTION);
        Assertions.assertThat((String)result.getTypeRef().getNamespaceURI()).isEmpty();
        Assertions.assertThat((String)result.getTypeRef().getLocalPart()).isEqualTo(TYPE_REF);
        Assertions.assertThat((String)result.getText().getValue()).isEqualTo(TEXT);
        Assertions.assertThat((String)result.getExpressionLanguage().getValue()).isEqualTo(EXPRESSION_LANGUAGE);
        Assertions.assertThat((String)result.getImportedValues().getImportedElement()).isEqualTo(IMPORTED_ELEMENT);
        Assertions.assertThat((Object)result.getImportedValues().getParent()).isEqualTo((Object)result);
    }

    @Test
    public void testDMNFromWB() {
        Mockito.when((Object)this.wb.getId()).thenReturn((Object)new Id(UUID));
        Mockito.when((Object)this.wb.getDescription()).thenReturn((Object)new Description(DESCRIPTION));
        Mockito.when((Object)this.wb.getTypeRef()).thenReturn((Object)new QName(DMNModelInstrumentedBase.Namespace.KIE.getUri(), TYPE_REF, DMNModelInstrumentedBase.Namespace.KIE.getPrefix()));
        Mockito.when((Object)this.wb.getText()).thenReturn((Object)new Text(TEXT));
        Mockito.when((Object)this.wb.getExpressionLanguage()).thenReturn((Object)new ExpressionLanguage(EXPRESSION_LANGUAGE));
        JSITLiteralExpression result = LiteralExpressionPropertyConverter.dmnFromWB((IsLiteralExpression)this.wb);
        ((JSITLiteralExpression)Mockito.verify((Object)result)).setId(UUID);
        ((JSITLiteralExpression)Mockito.verify((Object)result)).setDescription(DESCRIPTION);
        ((JSITLiteralExpression)Mockito.verify((Object)result)).setTypeRef("{" + DMNModelInstrumentedBase.Namespace.KIE.getUri() + "}" + TYPE_REF);
        ((JSITLiteralExpression)Mockito.verify((Object)result)).setText(TEXT);
        ((JSITLiteralExpression)Mockito.verify((Object)result)).setExpressionLanguage(EXPRESSION_LANGUAGE);
    }
}

