/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.webapp.kogito.common.client.services;

import elemental2.promise.Promise;
import java.util.Collections;
import org.appformer.kogito.bridge.client.pmmleditor.marshaller.PMMLEditorMarshallerApi;
import org.appformer.kogito.bridge.client.pmmleditor.marshaller.model.PMMLDocumentData;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.editors.included.DMNImportTypes;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.services.PMMLMarshallerService;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import org.uberfire.client.promise.Promises;
import org.uberfire.promise.SyncPromises;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={PMMLDocumentData.class})
public class PMMLMarshallerServiceTest {
    private static final String CONTENT = "<xml>content</xml>";
    private static final String FILENAME = "fileName.pmml";
    private static final String PATH = "test/fileName.pmml";
    private static final String UNDEFINED = "undefined";
    @Mock
    private PMMLEditorMarshallerApi pmmlEditorMarshallerApiMock;
    private Promises promises;
    private PMMLMarshallerService pmmlMarshallerService;

    @Before
    public void setup() {
        this.promises = new SyncPromises();
        this.pmmlMarshallerService = new PMMLMarshallerService(this.promises, this.pmmlEditorMarshallerApiMock);
    }

    @Test
    public void getDocumentMetadata() {
        PMMLDocumentData pmmlDocumentData = (PMMLDocumentData)PowerMockito.mock(PMMLDocumentData.class);
        PowerMockito.when((Object)pmmlDocumentData.getModels()).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.pmmlEditorMarshallerApiMock.getPMMLDocumentData(CONTENT)).thenReturn((Object)pmmlDocumentData);
        Promise returnPromise = this.pmmlMarshallerService.getDocumentMetadata(PATH, CONTENT);
        Assert.assertNotNull((Object)returnPromise);
        returnPromise.then(pmmlDocumentMetadata -> {
            Assert.assertNotNull((Object)pmmlDocumentMetadata);
            Assert.assertEquals((Object)PATH, (Object)pmmlDocumentMetadata.getPath());
            Assert.assertEquals((Object)UNDEFINED, (Object)pmmlDocumentMetadata.getName());
            Assert.assertEquals((Object)DMNImportTypes.PMML.getDefaultNamespace(), (Object)pmmlDocumentMetadata.getImportType());
            Assert.assertEquals((long)0L, (long)pmmlDocumentMetadata.getModels().size());
            return this.promises.resolve();
        }).catch_(i -> {
            Assert.fail((String)"Promise should've been resolved!");
            return this.promises.resolve();
        });
    }

    @Test
    public void getDocumentMetadataNullFile() {
        this.getDocumentMetadataInvalidContent(null, CONTENT, "PMML file required to be marshalled is empty or null");
    }

    @Test
    public void getDocumentMetadataEmptyFile() {
        this.getDocumentMetadataInvalidContent("", CONTENT, "PMML file required to be marshalled is empty or null");
    }

    @Test
    public void getDocumentMetadataNullContent() {
        this.getDocumentMetadataInvalidContent(PATH, null, "PMML file test/fileName.pmml content required to be marshalled is empty or null");
    }

    @Test
    public void getDocumentMetadataEmptyContent() {
        this.getDocumentMetadataInvalidContent(PATH, "", "PMML file test/fileName.pmml content required to be marshalled is empty or null");
    }

    public void getDocumentMetadataInvalidContent(String pmmlFile, String pmmlFileContent, String expectedMessage) {
        Promise returnPromise = this.pmmlMarshallerService.getDocumentMetadata(pmmlFile, pmmlFileContent);
        Assert.assertNotNull((Object)returnPromise);
        returnPromise.then(i -> {
            Assert.fail((String)"Promise should've been resolved!");
            return this.promises.resolve();
        }).catch_(error -> {
            Assert.assertEquals((Object)expectedMessage, (Object)error);
            return this.promises.resolve();
        });
    }
}

