/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.webapp.kogito.common.client.converters;

import elemental2.promise.IThenable;
import elemental2.promise.Promise;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.xml.namespace.QName;
import jsinterop.base.Js;
import org.appformer.kogito.bridge.client.resource.interop.ResourceListOptions;
import org.kie.workbench.common.dmn.api.definition.model.DRGElement;
import org.kie.workbench.common.dmn.api.definition.model.ItemDefinition;
import org.kie.workbench.common.dmn.api.editors.included.BaseIncludedModel;
import org.kie.workbench.common.dmn.api.editors.included.DMNImportTypes;
import org.kie.workbench.common.dmn.api.editors.included.DMNIncludedModel;
import org.kie.workbench.common.dmn.api.editors.included.DMNIncludedNode;
import org.kie.workbench.common.dmn.api.editors.included.IncludedModel;
import org.kie.workbench.common.dmn.api.editors.included.PMMLDocumentMetadata;
import org.kie.workbench.common.dmn.api.editors.included.PMMLIncludedModel;
import org.kie.workbench.common.dmn.api.editors.types.BuiltInTypeUtils;
import org.kie.workbench.common.dmn.api.graph.DMNDiagramUtils;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.DMNIncludedNodeFactory;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.DMNMarshallerImportsHelperKogito;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model.ImportedItemDefinitionPropertyConverter;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.services.DMNClientDiagramServiceImpl;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.services.PMMLMarshallerService;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITDMNElement;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITDRGElement;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITDecision;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITDefinitions;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITImport;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITInformationItem;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITInputData;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITInvocable;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITItemDefinition;
import org.kie.workbench.common.kogito.webapp.base.client.workarounds.KogitoResourceContentService;
import org.kie.workbench.common.stunner.core.client.service.ClientRuntimeError;
import org.kie.workbench.common.stunner.core.client.service.ServiceCallback;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.util.FileUtils;
import org.kie.workbench.common.stunner.core.util.StringUtils;
import org.uberfire.client.promise.Promises;

@ApplicationScoped
public class DMNMarshallerImportsHelperKogitoImpl
implements DMNMarshallerImportsHelperKogito {
    private final KogitoResourceContentService contentService;
    private final DMNClientDiagramServiceImpl diagramService;
    private final Promises promises;
    private final DMNDiagramUtils diagramUtils;
    private final DMNIncludedNodeFactory includedModelFactory;
    private final PMMLMarshallerService pmmlMarshallerService;
    private static final Logger LOGGER = Logger.getLogger(DMNMarshallerImportsHelperKogitoImpl.class.getName());
    private static final String DMN_FILES_PATTERN = "*.dmn";
    static final String PMML_FILES_PATTERN = "*.pmml";
    static final String MODEL_FILES_PATTERN = "*.{dmn,pmml}";

    @Inject
    public DMNMarshallerImportsHelperKogitoImpl(KogitoResourceContentService contentService, DMNClientDiagramServiceImpl diagramService, Promises promises, DMNDiagramUtils diagramUtils, DMNIncludedNodeFactory includedModelFactory, PMMLMarshallerService pmmlMarshallerService) {
        this.contentService = contentService;
        this.diagramService = diagramService;
        this.promises = promises;
        this.diagramUtils = diagramUtils;
        this.includedModelFactory = includedModelFactory;
        this.pmmlMarshallerService = pmmlMarshallerService;
    }

    @Override
    public Promise<Map<JSITImport, JSITDefinitions>> getImportDefinitionsAsync(Metadata metadata, List<JSITImport> imports) {
        if (!imports.isEmpty()) {
            return this.loadDMNDefinitions().then(otherDefinitions -> {
                HashMap importDefinitions = new HashMap();
                for (Map.Entry entry : otherDefinitions.entrySet()) {
                    JSITDefinitions def = (JSITDefinitions)Js.uncheckedCast(entry.getValue());
                    this.findImportByDefinitions(def, imports).ifPresent(anImport -> {
                        JSITImport foundImported = (JSITImport)Js.uncheckedCast((Object)anImport);
                        importDefinitions.put(foundImported, def);
                    });
                }
                return this.promises.resolve(importDefinitions);
            });
        }
        return this.promises.resolve(Collections.emptyMap());
    }

    Promise<Map<String, JSITDefinitions>> loadDMNDefinitions() {
        return this.contentService.getFilteredItems(DMN_FILES_PATTERN, ResourceListOptions.assetFolder()).then(list -> {
            if (((String[])list).length == 0) {
                return this.promises.resolve(Collections.emptyMap());
            }
            ConcurrentHashMap otherDefinitions = new ConcurrentHashMap();
            return this.promises.all(Arrays.asList(list), file -> this.loadDefinitionFromFile((String)file, otherDefinitions)).then(v -> this.promises.resolve((Object)otherDefinitions));
        });
    }

    @Override
    public void loadNodesFromModels(List<DMNIncludedModel> includedModels, ServiceCallback<List<DMNIncludedNode>> callback) {
        ArrayList result = new ArrayList();
        if (includedModels.isEmpty()) {
            callback.onSuccess(result);
        } else {
            this.loadDMNDefinitions().then(existingDefinitions -> this.promises.all(includedModels, model -> this.loadNodes((Map<String, JSITDefinitions>)existingDefinitions, (DMNIncludedModel)model, result)).then(p -> {
                callback.onSuccess((Object)result);
                return this.promises.resolve();
            }));
        }
    }

    private Promise<List<DMNIncludedNode>> loadNodes(Map<String, JSITDefinitions> existingDefinitions, final DMNIncludedModel model, final List<DMNIncludedNode> result) {
        String filePath = "";
        for (Map.Entry<String, JSITDefinitions> entry : existingDefinitions.entrySet()) {
            filePath = entry.getKey();
            JSITDefinitions definitions = (JSITDefinitions)Js.uncheckedCast((Object)entry.getValue());
            if (!Objects.equals(model.getNamespace(), definitions.getNamespace())) continue;
            break;
        }
        final String path = filePath;
        return this.contentService.loadFile(path).then(content -> this.promises.create((success, fail) -> this.diagramService.transform((String)content, new ServiceCallback<Diagram>(){

            public void onSuccess(Diagram item) {
                List nodes = DMNMarshallerImportsHelperKogitoImpl.this.diagramUtils.getDRGElements(item).stream().map(node -> DMNMarshallerImportsHelperKogitoImpl.this.includedModelFactory.makeDMNIncludeNode(path, (IncludedModel)model, (DRGElement)node)).collect(Collectors.toList());
                result.addAll(nodes);
                success.onInvoke(nodes);
            }

            public void onError(ClientRuntimeError error) {
                LOGGER.log(Level.SEVERE, error.getMessage());
                fail.onInvoke((Object)error);
            }
        })));
    }

    @Override
    public void loadModels(ServiceCallback<List<IncludedModel>> callback) {
        ArrayList models = new ArrayList();
        this.contentService.getFilteredItems(MODEL_FILES_PATTERN, ResourceListOptions.assetFolder()).then(items -> this.promises.all(Arrays.asList(items), file -> {
            String fileName = FileUtils.getFileName((String)file);
            if (fileName.endsWith("." + DMNImportTypes.DMN.getFileExtension())) {
                return this.contentService.loadFile(file).then(fileContent -> this.promises.create((success, failed) -> this.diagramService.transform((String)fileContent, this.getDMNDiagramCallback(fileName, models, (Promise.PromiseExecutorCallbackFn.ResolveCallbackFn<Object>)success, failed))));
            }
            if (fileName.endsWith("." + DMNImportTypes.PMML.getFileExtension())) {
                return this.contentService.loadFile(file).then(fileContent -> this.pmmlMarshallerService.getDocumentMetadata((String)file, (String)fileContent)).then(pmmlDocumentMetadata -> {
                    int modelCount = pmmlDocumentMetadata.getModels() != null ? pmmlDocumentMetadata.getModels().size() : 0;
                    models.add(new PMMLIncludedModel(fileName, "", fileName, DMNImportTypes.PMML.getDefaultNamespace(), Integer.valueOf(modelCount)));
                    return this.promises.resolve();
                });
            }
            return this.promises.reject((Object)("Error: " + fileName + " is an invalid file. Only " + DMN_FILES_PATTERN + " and " + PMML_FILES_PATTERN + " are supported"));
        }).then(v -> {
            callback.onSuccess((Object)models);
            return this.promises.resolve();
        }));
    }

    private ServiceCallback<Diagram> getDMNDiagramCallback(final String fileName, final List<IncludedModel> models, final Promise.PromiseExecutorCallbackFn.ResolveCallbackFn<Object> success, final Promise.PromiseExecutorCallbackFn.RejectCallbackFn failed) {
        return new ServiceCallback<Diagram>(){

            public void onSuccess(Diagram diagram) {
                String modelPackage = "";
                String namespace = DMNMarshallerImportsHelperKogitoImpl.this.diagramUtils.getNamespace(diagram);
                String importType = DMNImportTypes.DMN.getDefaultNamespace();
                int drgElementCount = DMNMarshallerImportsHelperKogitoImpl.this.diagramUtils.getDRGElements(diagram).size();
                int itemDefinitionCount = DMNMarshallerImportsHelperKogitoImpl.this.diagramUtils.getDefinitions(diagram) != null ? DMNMarshallerImportsHelperKogitoImpl.this.diagramUtils.getDefinitions(diagram).getItemDefinition().size() : 0;
                models.add(new DMNIncludedModel(fileName, "", fileName, namespace, importType, Integer.valueOf(drgElementCount), Integer.valueOf(itemDefinitionCount)));
                success.onInvoke((IThenable)DMNMarshallerImportsHelperKogitoImpl.this.promises.resolve());
            }

            public void onError(ClientRuntimeError error) {
                LOGGER.log(Level.SEVERE, error.getMessage());
                failed.onInvoke((Object)DMNMarshallerImportsHelperKogitoImpl.this.promises.reject((Object)error.getMessage()));
            }
        };
    }

    Promise<Void> loadDefinitionFromFile(String file, Map<String, JSITDefinitions> otherDefinitions) {
        return this.contentService.loadFile(file).then(xml -> this.promises.create((success, failure) -> {
            if (!StringUtils.isEmpty((String)xml)) {
                ServiceCallback<Object> callback = this.getCallback(file, otherDefinitions, (Promise.PromiseExecutorCallbackFn.ResolveCallbackFn<Void>)success);
                this.diagramService.getDefinitions((String)xml, callback);
            } else {
                success.onInvoke((IThenable)this.promises.resolve());
            }
        }));
    }

    private ServiceCallback<Object> getCallback(final String filePath, final Map<String, JSITDefinitions> otherDefinitions, final Promise.PromiseExecutorCallbackFn.ResolveCallbackFn<Void> success) {
        return new ServiceCallback<Object>(){

            public void onSuccess(Object item) {
                JSITDefinitions def = (JSITDefinitions)Js.uncheckedCast((Object)item);
                otherDefinitions.put(filePath, def);
                success.onInvoke((IThenable)DMNMarshallerImportsHelperKogitoImpl.this.promises.resolve());
            }

            public void onError(ClientRuntimeError error) {
                LOGGER.log(Level.SEVERE, error.getMessage());
            }
        };
    }

    private Optional<JSITImport> findImportByDefinitions(JSITDefinitions definitions, List<JSITImport> imports) {
        for (int i = 0; i < imports.size(); ++i) {
            JSITImport anImport = (JSITImport)Js.uncheckedCast((Object)imports.get(i));
            if (!Objects.equals(anImport.getNamespace(), definitions.getNamespace())) continue;
            return Optional.of(anImport);
        }
        return Optional.empty();
    }

    private Optional<JSITImport> findImportByPMMLDocument(String includedPMMLModelFile, List<JSITImport> imports) {
        for (int i = 0; i < imports.size(); ++i) {
            JSITImport anImport = (JSITImport)Js.uncheckedCast((Object)imports.get(i));
            if (!Objects.equals(anImport.getLocationURI(), includedPMMLModelFile)) continue;
            return Optional.of(anImport);
        }
        return Optional.empty();
    }

    @Override
    public Promise<Map<JSITImport, PMMLDocumentMetadata>> getPMMLDocumentsAsync(Metadata metadata, List<JSITImport> imports) {
        if (!imports.isEmpty()) {
            return this.loadPMMLDefinitions().then(otherDefinitions -> {
                HashMap importDefinitions = new HashMap();
                for (Map.Entry entry : otherDefinitions.entrySet()) {
                    PMMLDocumentMetadata def = (PMMLDocumentMetadata)entry.getValue();
                    this.findImportByPMMLDocument(FileUtils.getFileName((String)def.getPath()), imports).ifPresent(anImport -> {
                        JSITImport foundImported = (JSITImport)Js.uncheckedCast((Object)anImport);
                        importDefinitions.put(foundImported, def);
                    });
                }
                return this.promises.resolve(importDefinitions);
            });
        }
        return this.promises.resolve(Collections.emptyMap());
    }

    private Promise<Map<String, PMMLDocumentMetadata>> loadPMMLDefinitions() {
        return this.contentService.getFilteredItems(PMML_FILES_PATTERN, ResourceListOptions.assetFolder()).then(files -> {
            if (((String[])files).length == 0) {
                return this.promises.resolve(Collections.emptyMap());
            }
            HashMap definitions = new HashMap();
            return this.promises.all(Arrays.asList(files), file -> this.loadPMMLDefinitionFromFile((String)file, definitions).then(v -> this.promises.resolve((Object)definitions)));
        });
    }

    private Promise<Void> loadPMMLDefinitionFromFile(String file, Map<String, PMMLDocumentMetadata> definitions) {
        return this.contentService.loadFile(file).then(fileContent -> this.pmmlMarshallerService.getDocumentMetadata(file, (String)fileContent)).then(pmmlDocumentMetadata -> {
            definitions.put(file, (PMMLDocumentMetadata)pmmlDocumentMetadata);
            return this.promises.resolve();
        });
    }

    @Override
    public void getPMMLDocumentsMetadataFromFiles(List<PMMLIncludedModel> includedModels, ServiceCallback<List<PMMLDocumentMetadata>> callback) {
        if (includedModels == null || includedModels.isEmpty()) {
            callback.onSuccess(Collections.emptyList());
            return;
        }
        this.loadPMMLDefinitions().then(allDefinitions -> {
            Map<String, String> filesToNameMap = includedModels.stream().collect(Collectors.toMap(BaseIncludedModel::getPath, BaseIncludedModel::getModelName));
            List pmmlDocumentMetadata = allDefinitions.entrySet().stream().filter(entry -> filesToNameMap.keySet().contains(FileUtils.getFileName((String)((String)entry.getKey())))).map(entry -> new PMMLDocumentMetadata(((PMMLDocumentMetadata)entry.getValue()).getPath(), (String)filesToNameMap.get(FileUtils.getFileName((String)((String)entry.getKey()))), ((PMMLDocumentMetadata)entry.getValue()).getImportType(), ((PMMLDocumentMetadata)entry.getValue()).getModels())).collect(Collectors.toList());
            pmmlDocumentMetadata.sort(Comparator.comparing(PMMLDocumentMetadata::getName));
            callback.onSuccess(pmmlDocumentMetadata);
            return this.promises.resolve();
        });
    }

    public Map<JSITImport, String> getImportXML(Metadata metadata, List<JSITImport> imports) {
        return Collections.emptyMap();
    }

    public List<JSITDRGElement> getImportedDRGElements(Map<JSITImport, JSITDefinitions> importDefinitions) {
        ArrayList<JSITDRGElement> importedNodes = new ArrayList<JSITDRGElement>();
        for (Map.Entry<JSITImport, JSITDefinitions> entry : importDefinitions.entrySet()) {
            JSITImport anImport = (JSITImport)Js.uncheckedCast((Object)entry.getKey());
            JSITDefinitions definitions = (JSITDefinitions)Js.uncheckedCast((Object)entry.getValue());
            importedNodes.addAll(this.getDrgElementsWithNamespace(definitions, anImport));
        }
        return importedNodes;
    }

    private List<JSITDRGElement> getDrgElementsWithNamespace(JSITDefinitions definitions, JSITImport anImport) {
        ArrayList<JSITDRGElement> result = new ArrayList<JSITDRGElement>();
        List drgElements = definitions.getDrgElement();
        for (int i = 0; i < drgElements.size(); ++i) {
            JSITDRGElement drgElement = (JSITDRGElement)Js.uncheckedCast(drgElements.get(i));
            JSITDRGElement element = (JSITDRGElement)Js.uncheckedCast((Object)this.drgElementWithNamespace(drgElement, anImport));
            result.add(element);
        }
        return result;
    }

    private JSITDRGElement drgElementWithNamespace(JSITDRGElement drgElement, JSITImport anImport) {
        String namespace = anImport.getName();
        QName qname = QName.valueOf("Namespace");
        Map map = JSITDMNElement.getOtherAttributesMap((JSITDMNElement)drgElement);
        map.put(qname, anImport.getNamespace());
        drgElement.setOtherAttributes(map);
        drgElement.setName(namespace + "." + drgElement.getName());
        this.updateInformationItem(namespace, drgElement);
        return drgElement;
    }

    private void updateInformationItem(String namespace, JSITDRGElement drgElement) {
        this.getInformationItem(drgElement).ifPresent(informationItem -> {
            JSITInformationItem tInformationItem = new JSITInformationItem();
            String typeRef = informationItem.getTypeRef();
            if (!StringUtils.isEmpty((String)typeRef) && !BuiltInTypeUtils.isBuiltInType((String)typeRef)) {
                tInformationItem.setTypeRef(namespace + "." + typeRef);
                this.setInformationItem(drgElement, tInformationItem);
            }
        });
    }

    private void setInformationItem(JSITDRGElement drgElement, JSITInformationItem informationItem) {
        if (JSITDecision.instanceOf((Object)drgElement)) {
            JSITDecision decision = (JSITDecision)Js.uncheckedCast((Object)drgElement);
            decision.setVariable(informationItem);
        } else if (JSITInputData.instanceOf((Object)drgElement)) {
            JSITInputData inputData = (JSITInputData)Js.uncheckedCast((Object)drgElement);
            inputData.setVariable(informationItem);
        } else if (JSITInvocable.instanceOf((Object)drgElement)) {
            JSITInvocable invocable = (JSITInvocable)Js.uncheckedCast((Object)drgElement);
            invocable.setVariable(informationItem);
        }
    }

    private Optional<JSITInformationItem> getInformationItem(JSITDRGElement drgElement) {
        JSITInformationItem variable;
        if (JSITDecision.instanceOf((Object)drgElement)) {
            JSITDecision decision = (JSITDecision)Js.uncheckedCast((Object)drgElement);
            variable = (JSITInformationItem)Js.uncheckedCast((Object)decision.getVariable());
        } else if (JSITInputData.instanceOf((Object)drgElement)) {
            JSITInputData inputData = (JSITInputData)Js.uncheckedCast((Object)drgElement);
            variable = (JSITInformationItem)Js.uncheckedCast((Object)inputData.getVariable());
        } else if (JSITInvocable.instanceOf((Object)drgElement)) {
            JSITInvocable invocable = (JSITInvocable)Js.uncheckedCast((Object)drgElement);
            variable = (JSITInformationItem)Js.uncheckedCast((Object)invocable.getVariable());
        } else {
            return Optional.empty();
        }
        return Optional.of(variable);
    }

    public List<JSITItemDefinition> getImportedItemDefinitions(Map<JSITImport, JSITDefinitions> importDefinitions) {
        ArrayList<JSITItemDefinition> itemDefinitions = new ArrayList<JSITItemDefinition>();
        for (Map.Entry<JSITImport, JSITDefinitions> entry : importDefinitions.entrySet()) {
            JSITImport anImport = (JSITImport)Js.uncheckedCast((Object)entry.getKey());
            JSITDefinitions definitions = (JSITDefinitions)Js.uncheckedCast((Object)entry.getValue());
            List<JSITItemDefinition> items = this.getItemDefinitionsWithNamespace(definitions, anImport);
            itemDefinitions.addAll(items);
        }
        return itemDefinitions;
    }

    List<JSITItemDefinition> getItemDefinitionsWithNamespace(JSITDefinitions definitions, JSITImport anImport) {
        List itemDefinitions = definitions.getItemDefinition();
        String prefix = anImport.getName();
        ArrayList<JSITItemDefinition> result = new ArrayList<JSITItemDefinition>();
        for (int i = 0; i < itemDefinitions.size(); ++i) {
            JSITItemDefinition itemDefinition = (JSITItemDefinition)Js.uncheckedCast(itemDefinitions.get(i));
            JSITItemDefinition item = (JSITItemDefinition)Js.uncheckedCast((Object)ImportedItemDefinitionPropertyConverter.withNamespace(itemDefinition, prefix));
            result.add(item);
        }
        return result;
    }

    @Override
    public void getImportedItemDefinitionsByNamespaceAsync(String modelName, String namespace, ServiceCallback<List<ItemDefinition>> callback) {
        this.loadDMNDefinitions().then(definitions -> {
            ArrayList<ItemDefinition> result = new ArrayList<ItemDefinition>();
            for (Map.Entry entry : definitions.entrySet()) {
                JSITDefinitions definition = (JSITDefinitions)Js.uncheckedCast(entry.getValue());
                if (!Objects.equals(definition.getNamespace(), namespace)) continue;
                List items = definition.getItemDefinition();
                for (int j = 0; j < items.size(); ++j) {
                    JSITItemDefinition jsitItemDefinition = (JSITItemDefinition)Js.uncheckedCast(items.get(j));
                    ItemDefinition converted = ImportedItemDefinitionPropertyConverter.wbFromDMN(jsitItemDefinition, modelName);
                    result.add(converted);
                }
            }
            result.sort(Comparator.comparing(o -> o.getName().getValue()));
            callback.onSuccess(result);
            return this.promises.resolve(result);
        });
    }
}

