/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import jsinterop.base.Js;
import org.kie.workbench.common.dmn.api.definition.model.DRGElement;
import org.kie.workbench.common.dmn.api.property.dmn.DMNExternalLink;
import org.kie.workbench.common.dmn.api.property.dmn.DocumentationLinks;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.utils.WrapperUtils;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITDMNElement;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITDRGElement;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.kie.JSITAttachment;

class DMNExternalLinksToExtensionElements {
    DMNExternalLinksToExtensionElements() {
    }

    static void loadExternalLinksFromExtensionElements(JSITDRGElement source, DRGElement target) {
        List extensions;
        if (!Objects.isNull(source.getExtensionElements()) && !Objects.isNull(extensions = source.getExtensionElements().getAny())) {
            for (int i = 0; i < extensions.size(); ++i) {
                Object extension = extensions.get(i);
                if (!JSITAttachment.instanceOf(extension)) continue;
                JSITAttachment jsiExtension = (JSITAttachment)Js.uncheckedCast(extension);
                DMNExternalLink external = new DMNExternalLink();
                external.setDescription(jsiExtension.getName());
                external.setUrl(jsiExtension.getUrl());
                target.getLinksHolder().getValue().addLink(external);
            }
        }
    }

    static void loadExternalLinksIntoExtensionElements(DRGElement source, JSITDRGElement target) {
        if (Objects.isNull(source.getLinksHolder()) || Objects.isNull(source.getLinksHolder().getValue())) {
            return;
        }
        DocumentationLinks links = source.getLinksHolder().getValue();
        JSITDMNElement.JSIExtensionElements elements = DMNExternalLinksToExtensionElements.getOrCreateExtensionElements(target);
        DMNExternalLinksToExtensionElements.removeAllExistingLinks(elements);
        for (DMNExternalLink link : links.getLinks()) {
            JSITAttachment attachment = new JSITAttachment();
            attachment.setName(link.getDescription());
            attachment.setUrl(link.getUrl());
            JSITAttachment wrappedAttachment = WrapperUtils.getWrappedJSITAttachment(attachment);
            elements.addAny((Object)wrappedAttachment);
        }
        target.setExtensionElements(elements);
    }

    private static void removeAllExistingLinks(JSITDMNElement.JSIExtensionElements elements) {
        JSITDMNElement.JSIExtensionElements others = new JSITDMNElement.JSIExtensionElements();
        others.setAny(new ArrayList());
        List any = elements.getAny();
        for (int i = 0; i < any.size(); ++i) {
            Object extension = any.get(i);
            if (JSITAttachment.instanceOf(extension)) continue;
            others.addAny(extension);
        }
        elements.setAny(others.getAny());
    }

    private static JSITDMNElement.JSIExtensionElements getOrCreateExtensionElements(JSITDRGElement target) {
        JSITDMNElement.JSIExtensionElements toReturn;
        JSITDMNElement.JSIExtensionElements jSIExtensionElements = toReturn = Objects.isNull(target.getExtensionElements()) ? new JSITDMNElement.JSIExtensionElements() : target.getExtensionElements();
        if (!Objects.isNull(toReturn) && Objects.isNull(toReturn.getAny())) {
            toReturn.setAny(new ArrayList());
        }
        return toReturn;
    }
}

