/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.webapp.kogito.common.client.services;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONString;
import com.google.gwt.json.client.JSONValue;
import elemental2.promise.Promise;
import java.util.Map;
import java.util.Objects;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.xml.namespace.QName;
import jsinterop.base.Js;
import org.kie.workbench.common.dmn.api.DMNDefinitionSet;
import org.kie.workbench.common.dmn.api.definition.model.DMNDiagram;
import org.kie.workbench.common.dmn.api.factory.DMNDiagramFactory;
import org.kie.workbench.common.dmn.client.DMNShapeSet;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.DMNMarshallerKogitoMarshaller;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.DMNMarshallerKogitoUnmarshaller;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.MainJs;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.callbacks.DMN12MarshallCallback;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.callbacks.DMN12UnmarshallCallback;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.DMN12;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITDefinitions;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.mapper.JSIName;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.mapper.JsUtils;
import org.kie.workbench.common.stunner.core.api.DefinitionManager;
import org.kie.workbench.common.stunner.core.api.FactoryManager;
import org.kie.workbench.common.stunner.core.client.service.ClientRuntimeError;
import org.kie.workbench.common.stunner.core.client.service.ServiceCallback;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableAdapterUtils;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.DiagramParsingException;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.diagram.MetadataImpl;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.util.GraphUtils;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;
import org.kie.workbench.common.stunner.core.util.StringUtils;
import org.kie.workbench.common.stunner.kogito.api.editor.DiagramType;
import org.kie.workbench.common.stunner.kogito.api.editor.impl.KogitoDiagramResourceImpl;
import org.kie.workbench.common.stunner.kogito.client.service.AbstractKogitoClientDiagramService;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.client.promise.Promises;
import org.uberfire.commons.uuid.UUID;

@ApplicationScoped
public class DMNClientDiagramServiceImpl
extends AbstractKogitoClientDiagramService {
    private static final String DIAGRAMS_PATH = "diagrams";
    private static final String ROOT = "default://master@system/stunner/diagrams";
    private DMNMarshallerKogitoUnmarshaller dmnMarshallerKogitoUnmarshaller;
    private DMNMarshallerKogitoMarshaller dmnMarshallerKogitoMarshaller;
    private FactoryManager factoryManager;
    private DefinitionManager definitionManager;
    private DMNDiagramFactory dmnDiagramFactory;
    private Promises promises;

    public DMNClientDiagramServiceImpl() {
    }

    @Inject
    public DMNClientDiagramServiceImpl(DMNMarshallerKogitoUnmarshaller dmnMarshallerKogitoUnmarshaller, DMNMarshallerKogitoMarshaller dmnMarshallerKogitoMarshaller, FactoryManager factoryManager, DefinitionManager definitionManager, DMNDiagramFactory dmnDiagramFactory, Promises promises) {
        this.dmnMarshallerKogitoUnmarshaller = dmnMarshallerKogitoUnmarshaller;
        this.dmnMarshallerKogitoMarshaller = dmnMarshallerKogitoMarshaller;
        this.factoryManager = factoryManager;
        this.definitionManager = definitionManager;
        this.dmnDiagramFactory = dmnDiagramFactory;
        this.promises = promises;
    }

    public void transform(String fileName, String xml, ServiceCallback<Diagram> callback) {
        if (Objects.isNull(xml) || xml.isEmpty()) {
            this.doNewDiagram(this.createDiagramTitleFromFilePath(fileName), callback);
        } else {
            this.doTransformation(xml, callback);
        }
    }

    public String generateDefaultId() {
        return UUID.uuid();
    }

    public void transform(String xml, ServiceCallback<Diagram> callback) {
        this.transform(UUID.uuid(), xml, callback);
    }

    void doNewDiagram(String title, ServiceCallback<Diagram> callback) {
        Metadata metadata = this.buildMetadataInstance();
        try {
            String defSetId = BindableAdapterUtils.getDefinitionSetId(DMNDefinitionSet.class);
            Diagram diagram = this.factoryManager.newDiagram(title, defSetId, metadata);
            this.updateClientShapeSetId(diagram);
            callback.onSuccess((Object)diagram);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Metadata buildMetadataInstance() {
        String defSetId = BindableAdapterUtils.getDefinitionSetId(DMNDefinitionSet.class);
        String shapeSetId = BindableAdapterUtils.getShapeSetId(DMNShapeSet.class);
        return new MetadataImpl.MetadataImplBuilder(defSetId, this.definitionManager).setRoot(PathFactory.newPath((String)".", (String)ROOT)).setShapeSetId(shapeSetId).build();
    }

    private void updateClientShapeSetId(Diagram diagram) {
        Metadata metadata;
        if (Objects.nonNull(diagram) && Objects.nonNull(metadata = diagram.getMetadata()) && StringUtils.isEmpty((String)metadata.getShapeSetId())) {
            String shapeSetId = BindableAdapterUtils.getShapeSetId(DMNShapeSet.class);
            metadata.setShapeSetId(shapeSetId);
        }
    }

    void doTransformation(String xml, ServiceCallback<Diagram> callback) {
        Metadata metadata = this.buildMetadataInstance();
        try {
            DMN12UnmarshallCallback jsCallback = dmn12 -> {
                JSITDefinitions definitions = (JSITDefinitions)Js.uncheckedCast((Object)JsUtils.getUnwrappedElement((Object)dmn12));
                this.dmnMarshallerKogitoUnmarshaller.unmarshall(metadata, definitions).then(graph -> {
                    Node diagramNode = GraphUtils.getFirstNode((Graph)graph, DMNDiagram.class);
                    String title = ((DMNDiagram)DefinitionUtils.getElementDefinition((Element)diagramNode)).getDefinitions().getName().getValue();
                    Diagram diagram = this.dmnDiagramFactory.build(title, metadata, graph);
                    this.updateClientShapeSetId(diagram);
                    callback.onSuccess((Object)diagram);
                    return this.promises.resolve();
                });
            };
            MainJs.unmarshall((String)xml, (String)"", (DMN12UnmarshallCallback)jsCallback);
        }
        catch (Exception e) {
            GWT.log((String)e.getMessage(), (Throwable)e);
            callback.onError(new ClientRuntimeError((Throwable)new DiagramParsingException(metadata, xml)));
        }
    }

    public void getDefinitions(String xml, ServiceCallback<Object> callback) {
        DMN12UnmarshallCallback jsCallback = dmn12 -> {
            JSITDefinitions definitions = (JSITDefinitions)Js.uncheckedCast((Object)JsUtils.getUnwrappedElement((Object)dmn12));
            callback.onSuccess((Object)definitions);
        };
        MainJs.unmarshall((String)xml, (String)"", (DMN12UnmarshallCallback)jsCallback);
    }

    public Promise<String> transform(KogitoDiagramResourceImpl resource) {
        if (resource.getType() == DiagramType.PROJECT_DIAGRAM) {
            return this.promises.create((resolveOnchangeFn, rejectOnchangeFn) -> {
                if (resource.projectDiagram().isPresent()) {
                    Diagram diagram = (Diagram)resource.projectDiagram().get();
                    this.marshall(diagram, (Promise.PromiseExecutorCallbackFn.ResolveCallbackFn<String>)resolveOnchangeFn, rejectOnchangeFn);
                } else {
                    rejectOnchangeFn.onInvoke((Object)new IllegalStateException("DiagramType is PROJECT_DIAGRAM however no instance present"));
                }
            });
        }
        return this.promises.resolve((Object)resource.xmlDiagram().orElse("DiagramType is XML_DIAGRAM however no instance present"));
    }

    private void marshall(Diagram diagram, Promise.PromiseExecutorCallbackFn.ResolveCallbackFn<String> resolveOnchangeFn, Promise.PromiseExecutorCallbackFn.RejectCallbackFn rejectOnchangeFn) {
        if (Objects.isNull(diagram)) {
            return;
        }
        Graph graph = diagram.getGraph();
        if (Objects.isNull(graph)) {
            return;
        }
        DMN12MarshallCallback jsCallback = result -> {
            String xml = result;
            if (!xml.startsWith("<?xml version=\"1.0\" ?>")) {
                xml = "<?xml version=\"1.0\" ?>" + xml;
            }
            resolveOnchangeFn.onInvoke((Object)xml);
        };
        try {
            JSITDefinitions jsitDefinitions = this.dmnMarshallerKogitoMarshaller.marshall(graph);
            DMN12 dmn12 = (DMN12)Js.uncheckedCast((Object)JsUtils.newWrappedInstance());
            JsUtils.setNameOnWrapped((Object)dmn12, (JSIName)this.makeJSINameForDMN12());
            JsUtils.setValueOnWrapped((Object)dmn12, (Object)jsitDefinitions);
            JavaScriptObject namespaces = this.createNamespaces(jsitDefinitions.getOtherAttributes(), jsitDefinitions.getNamespace());
            MainJs.marshall((DMN12)dmn12, (JavaScriptObject)namespaces, (DMN12MarshallCallback)jsCallback);
        }
        catch (Exception e) {
            GWT.log((String)e.getMessage(), (Throwable)e);
            rejectOnchangeFn.onInvoke((Object)e);
        }
    }

    private JavaScriptObject createNamespaces(Map<QName, String> otherAttributes, String defaultNamespace) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(defaultNamespace, (JSONValue)new JSONString(""));
        otherAttributes.forEach((key, value) -> jsonObject.put(value, (JSONValue)new JSONString(key.getLocalPart())));
        return jsonObject.getJavaScriptObject();
    }

    private JSIName makeJSINameForDMN12() {
        JSIName jsiName = JSITDefinitions.getJSIName();
        jsiName.setPrefix("dmn");
        jsiName.setLocalPart("definitions");
        String key = "{" + jsiName.getNamespaceURI() + "}" + jsiName.getLocalPart();
        String keyString = "{" + jsiName.getNamespaceURI() + "}" + jsiName.getPrefix() + ":" + jsiName.getLocalPart();
        jsiName.setKey(key);
        jsiName.setString(keyString);
        return jsiName;
    }
}

