/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.webapp.kogito.common.client.services;

import elemental2.promise.Promise;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.appformer.kogito.bridge.client.pmmleditor.marshaller.PMMLEditorMarshallerApi;
import org.appformer.kogito.bridge.client.pmmleditor.marshaller.model.PMMLDocumentData;
import org.kie.workbench.common.dmn.api.editors.included.PMMLDocumentMetadata;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.PMMLMarshallerConverter;
import org.kie.workbench.common.stunner.core.util.StringUtils;
import org.uberfire.client.promise.Promises;

@Dependent
public class PMMLMarshallerService {
    private Promises promises;
    private PMMLEditorMarshallerApi pmmlEditorMarshallerApi;

    public PMMLMarshallerService() {
    }

    @Inject
    public PMMLMarshallerService(Promises promises, PMMLEditorMarshallerApi pmmlEditorMarshallerApi) {
        this.promises = promises;
        this.pmmlEditorMarshallerApi = pmmlEditorMarshallerApi;
    }

    public Promise<PMMLDocumentMetadata> getDocumentMetadata(String pmmlFilePath, String pmmlFileContent) {
        if (StringUtils.isEmpty((String)pmmlFilePath)) {
            return this.promises.reject((Object)"PMML file required to be marshalled is empty or null");
        }
        if (StringUtils.isEmpty((String)pmmlFileContent)) {
            return this.promises.reject((Object)("PMML file " + pmmlFilePath + " content required to be marshalled is empty or null"));
        }
        try {
            PMMLDocumentData pmmlDocumentData = this.pmmlEditorMarshallerApi.getPMMLDocumentData(pmmlFileContent);
            PMMLDocumentMetadata pmmlDocumentMetadata = PMMLMarshallerConverter.fromJSInteropToMetadata(pmmlFilePath, pmmlDocumentData);
            return this.promises.resolve((Object)pmmlDocumentMetadata);
        }
        catch (Exception e) {
            return this.promises.reject((Object)("Error during marshalling of PMML file " + pmmlFilePath + ": " + e.getMessage()));
        }
    }
}

