/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.webapp.kogito.common.client.tour;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.appformer.kogito.bridge.client.guided.tour.GuidedTourBridge;
import org.appformer.kogito.bridge.client.guided.tour.GuidedTourCustomSelectorPositionProvider;
import org.appformer.kogito.bridge.client.guided.tour.GuidedTourObserver;
import org.appformer.kogito.bridge.client.guided.tour.service.api.Tutorial;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.tour.GuidedTourBridgeInitializer;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.tour.observers.GuidedTourGraphObserver;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.tour.observers.GuidedTourGridObserver;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.tour.providers.GraphElementsPositionProviderFactory;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.tour.providers.HTMLElementsPositionProviderFactory;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.tour.tutorial.DMNTutorial;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class GuidedTourBridgeInitializerTest {
    @Mock
    private GuidedTourGraphObserver graphObserver;
    @Mock
    private GuidedTourGridObserver gridObserver;
    @Mock
    private GraphElementsPositionProviderFactory graphPositionUtils;
    @Mock
    private HTMLElementsPositionProviderFactory htmlPositionUtils;
    @Mock
    private GuidedTourBridge monitorBridge;
    @Mock
    private DMNTutorial dmnTutorial;

    @Test
    public void testInit() {
        GuidedTourCustomSelectorPositionProvider.PositionProviderFunction graphProvider = (GuidedTourCustomSelectorPositionProvider.PositionProviderFunction)Mockito.mock(GuidedTourCustomSelectorPositionProvider.PositionProviderFunction.class);
        GuidedTourCustomSelectorPositionProvider.PositionProviderFunction htmlProvider = (GuidedTourCustomSelectorPositionProvider.PositionProviderFunction)Mockito.mock(GuidedTourCustomSelectorPositionProvider.PositionProviderFunction.class);
        Tutorial tutorial = (Tutorial)Mockito.mock(Tutorial.class);
        GuidedTourBridgeInitializer bridgeInitializer = new GuidedTourBridgeInitializer(this.graphObserver, this.gridObserver, this.graphPositionUtils, this.htmlPositionUtils, this.monitorBridge, this.dmnTutorial);
        Mockito.when((Object)this.graphPositionUtils.createPositionProvider()).thenReturn((Object)graphProvider);
        Mockito.when((Object)this.htmlPositionUtils.createPositionProvider()).thenReturn((Object)htmlProvider);
        Mockito.when((Object)this.dmnTutorial.getTutorial()).thenReturn((Object)tutorial);
        bridgeInitializer.init();
        ((GuidedTourBridge)Mockito.verify((Object)this.monitorBridge)).registerPositionProvider("DMNEditorGraph", graphProvider);
        ((GuidedTourBridge)Mockito.verify((Object)this.monitorBridge)).registerPositionProvider("DMNEditorHTMLElement", htmlProvider);
        ((GuidedTourBridge)Mockito.verify((Object)this.monitorBridge)).registerObserver((GuidedTourObserver)this.graphObserver);
        ((GuidedTourBridge)Mockito.verify((Object)this.monitorBridge)).registerObserver((GuidedTourObserver)this.gridObserver);
        ((GuidedTourBridge)Mockito.verify((Object)this.monitorBridge)).registerTutorial(tutorial);
    }
}

