/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.webapp.kogito.common.client.tour.observers;

import java.util.Optional;
import java.util.stream.Stream;
import org.appformer.kogito.bridge.client.guided.tour.GuidedTourBridge;
import org.appformer.kogito.bridge.client.guided.tour.service.api.UserInteraction;
import org.jboss.errai.ioc.client.api.Disposer;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.events.EditExpressionEvent;
import org.kie.workbench.common.dmn.client.graph.DMNGraphUtils;
import org.kie.workbench.common.dmn.client.widgets.grid.model.ExpressionEditorChanged;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.tour.common.GuidedTourActions;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.tour.common.GuidedTourUtils;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.tour.observers.GuidedTourGridObserver;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class GuidedTourGridObserverTest {
    @Mock
    private DMNGraphUtils dmnGraphUtils;
    @Mock
    private GuidedTourUtils guidedTourUtils;
    @Mock
    private Disposer<GuidedTourGridObserver> disposer;
    @Mock
    private GuidedTourBridge bridge;
    @Mock
    private UserInteraction userInteraction;
    @Mock
    private Node node1;
    @Mock
    private Node node2;
    private String uuid1 = "uuid1";
    private String uuid2 = "uuid2";
    private GuidedTourGridObserverFake observer;

    @Before
    public void setup() {
        this.observer = (GuidedTourGridObserverFake)((Object)Mockito.spy((Object)((Object)new GuidedTourGridObserverFake(this.disposer))));
        Mockito.when((Object)this.node1.getUUID()).thenReturn((Object)this.uuid1);
        Mockito.when((Object)this.node2.getUUID()).thenReturn((Object)this.uuid2);
        Mockito.when((Object)this.dmnGraphUtils.getNodeStream()).thenReturn(Stream.of(this.node1, this.node2));
        Mockito.when((Object)this.guidedTourUtils.getName((Element)this.node1)).thenReturn((Object)"Decision-1");
        Mockito.when((Object)this.guidedTourUtils.getName((Element)this.node2)).thenReturn((Object)"Decision-2");
    }

    @Test
    public void testOnEditExpressionEvent() {
        EditExpressionEvent event = (EditExpressionEvent)Mockito.mock(EditExpressionEvent.class);
        Mockito.when((Object)event.getNodeUUID()).thenReturn((Object)this.uuid1);
        ((GuidedTourGridObserverFake)((Object)Mockito.doReturn((Object)this.userInteraction).when((Object)this.observer))).buildUserInteraction(GuidedTourActions.CREATED.name(), "BOXED_EXPRESSION:::Decision-1");
        this.observer.onEditExpressionEvent(event);
        ((GuidedTourBridge)Mockito.verify((Object)this.bridge)).refresh(this.userInteraction);
    }

    @Test
    public void testOnExpressionEditorChanged() {
        ExpressionEditorChanged event = new ExpressionEditorChanged(this.uuid2);
        ((GuidedTourGridObserverFake)((Object)Mockito.doReturn((Object)this.userInteraction).when((Object)this.observer))).buildUserInteraction(GuidedTourActions.UPDATED.name(), "BOXED_EXPRESSION:::Decision-2");
        this.observer.onExpressionEditorChanged(event);
        ((GuidedTourBridge)Mockito.verify((Object)this.bridge)).refresh(this.userInteraction);
    }

    class GuidedTourGridObserverFake
    extends GuidedTourGridObserver {
        GuidedTourGridObserverFake(Disposer<GuidedTourGridObserver> disposer) {
            super(disposer, GuidedTourGridObserverTest.this.dmnGraphUtils, GuidedTourGridObserverTest.this.guidedTourUtils);
        }

        protected Optional<GuidedTourBridge> getMonitorBridge() {
            return Optional.of(GuidedTourGridObserverTest.this.bridge);
        }
    }
}

