/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.webapp.kogito.common.client.included;

import elemental2.promise.Promise;
import javax.enterprise.inject.Alternative;
import javax.inject.Inject;
import org.appformer.kogito.bridge.client.pmmleditor.marshaller.PMMLEditorMarshallerApi;
import org.appformer.kogito.bridge.client.pmmleditor.marshaller.model.PMMLDocumentData;
import org.appformer.kogito.bridge.client.resource.interop.ResourceListOptions;
import org.kie.workbench.common.dmn.api.editors.included.PMMLDocumentMetadata;
import org.kie.workbench.common.dmn.client.marshaller.included.DMNMarshallerImportsContentService;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.PMMLMarshallerConverter;
import org.kie.workbench.common.kogito.webapp.base.client.workarounds.KogitoResourceContentService;
import org.kie.workbench.common.stunner.core.util.StringUtils;
import org.uberfire.client.promise.Promises;

@Alternative
public class DMNMarshallerImportsContentServiceKogitoImpl
implements DMNMarshallerImportsContentService {
    private final KogitoResourceContentService contentService;
    private final Promises promises;
    private final PMMLEditorMarshallerApi pmmlEditorMarshallerApi;
    static final String DMN_FILES_PATTERN = "*.dmn";
    static final String PMML_FILES_PATTERN = "*.pmml";
    static final String MODEL_FILES_PATTERN = "*.{dmn,pmml}";

    @Inject
    public DMNMarshallerImportsContentServiceKogitoImpl(KogitoResourceContentService contentService, Promises promises, PMMLEditorMarshallerApi pmmlEditorMarshallerApi) {
        this.contentService = contentService;
        this.promises = promises;
        this.pmmlEditorMarshallerApi = pmmlEditorMarshallerApi;
    }

    public Promise<String> loadFile(String file) {
        return this.contentService.loadFile(file);
    }

    public Promise<String[]> getModelsURIs() {
        return this.contentService.getFilteredItems(MODEL_FILES_PATTERN, ResourceListOptions.assetFolder());
    }

    public Promise<String[]> getModelsDMNFilesURIs() {
        return this.contentService.getFilteredItems(DMN_FILES_PATTERN, ResourceListOptions.assetFolder());
    }

    public Promise<String[]> getModelsPMMLFilesURIs() {
        return this.contentService.getFilteredItems(PMML_FILES_PATTERN, ResourceListOptions.assetFolder());
    }

    public Promise<PMMLDocumentMetadata> getPMMLDocumentMetadata(String pmmlFilePath) {
        if (StringUtils.isEmpty((String)pmmlFilePath)) {
            return this.promises.reject((Object)"PMML file path cannot be empty or null");
        }
        return this.loadFile(pmmlFilePath).then(pmmlFileContent -> {
            if (StringUtils.isEmpty((String)pmmlFileContent)) {
                return this.promises.reject((Object)("PMML file " + pmmlFilePath + " content required to be marshalled is empty or null"));
            }
            try {
                PMMLDocumentData pmmlDocumentData = this.pmmlEditorMarshallerApi.getPMMLDocumentData(pmmlFileContent);
                PMMLDocumentMetadata pmmlDocumentMetadata = PMMLMarshallerConverter.fromJSInteropToMetadata(pmmlFilePath, pmmlDocumentData);
                return this.promises.resolve((Object)pmmlDocumentMetadata);
            }
            catch (Exception e) {
                return this.promises.reject((Object)("Error during marshalling of PMML file " + pmmlFilePath + ": " + e.getMessage()));
            }
        });
    }
}

