/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.webapp.kogito.common.client.tour.observers;

import java.util.Optional;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.appformer.kogito.bridge.client.guided.tour.GuidedTourObserver;
import org.appformer.kogito.bridge.client.guided.tour.service.api.UserInteraction;
import org.jboss.errai.ioc.client.api.Disposer;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.tour.common.GuidedTourActions;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.tour.common.GuidedTourUtils;
import org.kie.workbench.common.stunner.core.client.canvas.event.registration.AbstractCanvasHandlerElementEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.registration.CanvasElementAddedEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.registration.CanvasElementRemovedEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.registration.CanvasElementUpdatedEvent;

@Dependent
public class GuidedTourGraphObserver
extends GuidedTourObserver<GuidedTourGraphObserver> {
    private final GuidedTourUtils guidedTourUtils;

    @Inject
    public GuidedTourGraphObserver(Disposer<GuidedTourGraphObserver> disposer, GuidedTourUtils guidedTourUtils) {
        super(disposer);
        this.guidedTourUtils = guidedTourUtils;
    }

    public void onCanvasElementAddedEvent(@Observes CanvasElementAddedEvent event) {
        this.onCanvasEvent(GuidedTourActions.CREATED.name(), this.getNodeName((AbstractCanvasHandlerElementEvent)event));
    }

    public void onCanvasElementUpdatedEvent(@Observes CanvasElementUpdatedEvent event) {
        this.onCanvasEvent(GuidedTourActions.UPDATED.name(), this.getNodeName((AbstractCanvasHandlerElementEvent)event));
    }

    public void onAbstractCanvasElementRemovedEvent(@Observes CanvasElementRemovedEvent event) {
        this.onCanvasEvent(GuidedTourActions.REMOVED.name(), this.getNodeName((AbstractCanvasHandlerElementEvent)event));
    }

    private void onCanvasEvent(String action, String target) {
        Optional monitorBridge = this.getMonitorBridge();
        monitorBridge.ifPresent(bridge -> bridge.refresh(this.buildUserInteraction(action, target)));
    }

    private String getNodeName(AbstractCanvasHandlerElementEvent event) {
        return this.guidedTourUtils.getName(event).orElse("");
    }

    UserInteraction buildUserInteraction(String action, String target) {
        UserInteraction userInteraction = new UserInteraction();
        userInteraction.setAction(action);
        userInteraction.setTarget(target);
        return userInteraction;
    }
}

