/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.webapp.kogito.common.client.tour.observers;

import java.util.Objects;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.appformer.kogito.bridge.client.guided.tour.GuidedTourObserver;
import org.appformer.kogito.bridge.client.guided.tour.service.api.UserInteraction;
import org.jboss.errai.ioc.client.api.Disposer;
import org.kie.workbench.common.dmn.client.events.EditExpressionEvent;
import org.kie.workbench.common.dmn.client.graph.DMNGraphUtils;
import org.kie.workbench.common.dmn.client.widgets.grid.model.ExpressionEditorChanged;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.tour.common.GuidedTourActions;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.tour.common.GuidedTourUtils;

public class GuidedTourGridObserver
extends GuidedTourObserver<GuidedTourGridObserver> {
    private static final String BOXED_EXPRESSION = "BOXED_EXPRESSION";
    private final DMNGraphUtils dmnGraphUtils;
    private final GuidedTourUtils guidedTourUtils;

    @Inject
    public GuidedTourGridObserver(Disposer<GuidedTourGridObserver> disposer, DMNGraphUtils dmnGraphUtils, GuidedTourUtils guidedTourUtils) {
        super(disposer);
        this.dmnGraphUtils = dmnGraphUtils;
        this.guidedTourUtils = guidedTourUtils;
    }

    public void onEditExpressionEvent(@Observes EditExpressionEvent event) {
        this.onBoxedExpressionEvent(GuidedTourActions.CREATED.name(), event.getNodeUUID());
    }

    public void onExpressionEditorChanged(@Observes ExpressionEditorChanged event) {
        this.onBoxedExpressionEvent(GuidedTourActions.UPDATED.name(), event.getNodeUUID());
    }

    private void onBoxedExpressionEvent(String action, String nodeUUID) {
        String name = this.getName(nodeUUID);
        String target = "BOXED_EXPRESSION:::" + name;
        this.getMonitorBridge().ifPresent(bridge -> bridge.refresh(this.buildUserInteraction(action, target)));
    }

    private String getName(String nodeUUID) {
        return this.dmnGraphUtils.getNodeStream().filter(node -> Objects.equals(node.getUUID(), nodeUUID)).findFirst().map(this.guidedTourUtils::getName).orElse("");
    }

    UserInteraction buildUserInteraction(String action, String target) {
        UserInteraction userInteraction = new UserInteraction();
        userInteraction.setAction(action);
        userInteraction.setTarget(target);
        return userInteraction;
    }
}

