/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.webapp.kogito.common.client.tour.providers;

import com.google.gwt.dom.client.Element;
import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.dom.ClientRect;
import elemental2.dom.HTMLElement;
import java.util.stream.Stream;
import org.appformer.kogito.bridge.client.guided.tour.GuidedTourCustomSelectorPositionProvider;
import org.appformer.kogito.bridge.client.guided.tour.service.api.Rect;
import org.jboss.errai.common.client.dom.elemental2.Elemental2DomUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.graph.DMNGraphUtils;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.tour.common.GuidedTourUtils;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.tour.providers.GraphElementsPositionProviderFactory;
import org.kie.workbench.common.stunner.client.lienzo.canvas.wires.WiresCanvas;
import org.kie.workbench.common.stunner.client.lienzo.canvas.wires.WiresCanvasView;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.graph.content.Bounds;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.impl.NodeImpl;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class GraphElementsPositionProviderFactoryTest {
    @Mock
    private DMNGraphUtils dmnGraphUtils;
    @Mock
    private GuidedTourUtils guidedTourUtils;
    @Mock
    private Elemental2DomUtil elemental2DomUtil;
    private GraphElementsPositionProviderFactory utils;

    @Before
    public void init() {
        this.utils = (GraphElementsPositionProviderFactory)Mockito.spy((Object)new GraphElementsPositionProviderFactory(this.dmnGraphUtils, this.guidedTourUtils, this.elemental2DomUtil));
    }

    @Test
    public void testGetPositionProviderFunction() {
        GuidedTourCustomSelectorPositionProvider.PositionProviderFunction providerFunction = this.utils.createPositionProvider();
        NodeImpl<View> decisionNode = this.makeNodeImpl("0000", 10.0, 10.0, 50.0, 100.0);
        String decisionNodeName = "Decision-1";
        CanvasHandler canvasHandler = (CanvasHandler)Mockito.mock(CanvasHandler.class);
        WiresCanvas canvas = (WiresCanvas)Mockito.mock(WiresCanvas.class);
        WiresCanvasView wiresCanvasView = (WiresCanvasView)Mockito.mock(WiresCanvasView.class);
        com.google.gwt.user.client.Element deprecatedElement = (com.google.gwt.user.client.Element)Mockito.mock(com.google.gwt.user.client.Element.class);
        HTMLElement htmlElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        ClientRect clientRect = this.makeClientRect(10.0, 10.0);
        Rect expected = (Rect)Mockito.mock(Rect.class);
        Mockito.when((Object)this.guidedTourUtils.asNodeImpl(decisionNode)).thenReturn(decisionNode);
        Mockito.when((Object)this.guidedTourUtils.getName(decisionNode)).thenReturn((Object)"Decision-1");
        Mockito.when((Object)this.dmnGraphUtils.getNodeStream()).thenReturn(Stream.of(decisionNode));
        Mockito.when((Object)this.dmnGraphUtils.getCanvasHandler()).thenReturn((Object)canvasHandler);
        Mockito.when((Object)canvasHandler.getCanvas()).thenReturn((Object)canvas);
        Mockito.when((Object)canvas.getView()).thenReturn((Object)wiresCanvasView);
        Mockito.when((Object)wiresCanvasView.getElement()).thenReturn((Object)deprecatedElement);
        Mockito.when((Object)this.elemental2DomUtil.asHTMLElement((Element)deprecatedElement)).thenReturn((Object)htmlElement);
        Mockito.when((Object)htmlElement.getBoundingClientRect()).thenReturn((Object)clientRect);
        Mockito.when((Object)this.utils.makeRect(20, 20, 50, 100)).thenReturn((Object)expected);
        Rect actual = providerFunction.call("Decision-1");
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testGetPositionProviderFunctionWhenParentCanvasElementCannotBeFound() {
        GuidedTourCustomSelectorPositionProvider.PositionProviderFunction providerFunction = this.utils.createPositionProvider();
        NodeImpl<View> decisionNode = this.makeNodeImpl("0000", 10.0, 10.0, 50.0, 100.0);
        String decisionNodeName = "Decision-1";
        Rect expected = (Rect)Mockito.mock(Rect.class);
        Mockito.when((Object)this.guidedTourUtils.asNodeImpl(decisionNode)).thenReturn(decisionNode);
        Mockito.when((Object)this.guidedTourUtils.getName(decisionNode)).thenReturn((Object)"Decision-1");
        Mockito.when((Object)this.dmnGraphUtils.getNodeStream()).thenReturn(Stream.of(decisionNode));
        Mockito.when((Object)this.utils.makeRect(10, 10, 50, 100)).thenReturn((Object)expected);
        Rect actual = providerFunction.call("Decision-1");
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    private ClientRect makeClientRect(double top, double left) {
        ClientRect clientRect = new ClientRect();
        clientRect.top = top;
        clientRect.left = left;
        return clientRect;
    }

    private NodeImpl<View> makeNodeImpl(String uuid, double y, double x, double height, double width) {
        NodeImpl viewNode = (NodeImpl)Mockito.spy((Object)new NodeImpl(uuid));
        View content = (View)Mockito.mock(View.class);
        Bounds bounds = (Bounds)Mockito.mock(Bounds.class);
        ((NodeImpl)Mockito.doReturn((Object)content).when((Object)viewNode)).getContent();
        Mockito.when((Object)content.getBounds()).thenReturn((Object)bounds);
        Mockito.when((Object)bounds.getY()).thenReturn((Object)y);
        Mockito.when((Object)bounds.getX()).thenReturn((Object)x);
        Mockito.when((Object)bounds.getHeight()).thenReturn((Object)height);
        Mockito.when((Object)bounds.getWidth()).thenReturn((Object)width);
        return viewNode;
    }
}

