/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.webapp.kogito.common.client.tour.providers;

import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.dom.ClientRect;
import elemental2.dom.Element;
import elemental2.dom.HTMLDocument;
import org.appformer.kogito.bridge.client.guided.tour.service.api.Rect;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.tour.providers.HTMLElementsPositionProviderFactory;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class HTMLElementsPositionProviderFactoryTest {
    private HTMLElementsPositionProviderFactory utils;
    @Mock
    private HTMLDocument document;

    @Before
    public void init() {
        this.utils = (HTMLElementsPositionProviderFactory)Mockito.spy((Object)new HTMLElementsPositionProviderFactory());
        ((HTMLElementsPositionProviderFactory)Mockito.doReturn((Object)this.document).when((Object)this.utils)).document();
    }

    @Test
    public void testGetPositionProviderFunction() {
        String selector = ".my-button--inside-of-iframe";
        Element element = (Element)Mockito.mock(Element.class);
        ClientRect clientRect = (ClientRect)Mockito.mock(ClientRect.class);
        Rect expected = (Rect)Mockito.mock(Rect.class);
        clientRect.bottom = 60.0;
        clientRect.top = 10.0;
        clientRect.left = 10.0;
        clientRect.right = 110.0;
        clientRect.height = 50.0;
        clientRect.width = 100.0;
        Mockito.when((Object)this.document.querySelector(".my-button--inside-of-iframe")).thenReturn((Object)element);
        Mockito.when((Object)element.getBoundingClientRect()).thenReturn((Object)clientRect);
        ((HTMLElementsPositionProviderFactory)Mockito.doReturn((Object)expected).when((Object)this.utils)).makeRect(60, 10, 10, 110, 50, 100);
        Rect actual = this.utils.createPositionProvider().call(".my-button--inside-of-iframe");
        Assert.assertEquals((Object)expected, (Object)actual);
    }
}

