/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.webapp.kogito.common.client.tour.common;

import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.tour.common.GuidedTourUtils;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.controls.actions.TextPropertyProvider;
import org.kie.workbench.common.stunner.core.client.canvas.controls.actions.TextPropertyProviderFactory;
import org.kie.workbench.common.stunner.core.client.canvas.event.registration.AbstractCanvasHandlerElementEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.registration.CanvasElementAddedEvent;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.impl.EdgeImpl;
import org.kie.workbench.common.stunner.core.graph.impl.NodeImpl;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class GuidedTourUtilsTest {
    @Mock
    private TextPropertyProviderFactory textPropertyProviderFactory;
    private GuidedTourUtils utils;

    @Before
    public void setup() {
        this.utils = new GuidedTourUtils(this.textPropertyProviderFactory);
    }

    @Test
    public void getNameWithAbstractCanvasHandlerElementEvent() {
        String expectedName = "name";
        NodeImpl node = new NodeImpl("uuid");
        CanvasHandler canvasHandler = (CanvasHandler)Mockito.mock(CanvasHandler.class);
        TextPropertyProvider textPropertyProvider = (TextPropertyProvider)Mockito.mock(TextPropertyProvider.class);
        CanvasElementAddedEvent event = new CanvasElementAddedEvent(canvasHandler, (Element)node);
        Mockito.when((Object)this.textPropertyProviderFactory.getProvider((Element)node)).thenReturn((Object)textPropertyProvider);
        Mockito.when((Object)textPropertyProvider.getText((Element)node)).thenReturn((Object)"name");
        Optional actualName = this.utils.getName((AbstractCanvasHandlerElementEvent)event);
        Assert.assertTrue((boolean)actualName.isPresent());
        Assert.assertEquals((Object)"name", actualName.get());
    }

    @Test
    public void testGetNodeWhenElementIsNotNodeImpl() {
        EdgeImpl edge = new EdgeImpl("uuid");
        CanvasHandler canvasHandler = (CanvasHandler)Mockito.mock(CanvasHandler.class);
        CanvasElementAddedEvent event = new CanvasElementAddedEvent(canvasHandler, (Element)edge);
        Assert.assertFalse((boolean)this.utils.getName((AbstractCanvasHandlerElementEvent)event).isPresent());
    }

    @Test
    public void testGetNameWithNodeImpl() {
        NodeImpl node = new NodeImpl("uuid");
        TextPropertyProvider textPropertyProvider = (TextPropertyProvider)Mockito.mock(TextPropertyProvider.class);
        String expectedNodeName = "Decision-1";
        Mockito.when((Object)this.textPropertyProviderFactory.getProvider((Element)node)).thenReturn((Object)textPropertyProvider);
        Mockito.when((Object)textPropertyProvider.getText((Element)node)).thenReturn((Object)"Decision-1");
        String actualNodeName = this.utils.getName(node);
        Assert.assertEquals((Object)"Decision-1", (Object)actualNodeName);
    }

    @Test
    public void testAsNodeImpl() {
        NodeImpl node = new NodeImpl("uuid");
        Assert.assertEquals((Object)node, (Object)this.utils.asNodeImpl((Element)node));
    }

    @Test
    public void testAsNodeImplWithEdge() {
        Assert.assertNull((Object)this.utils.asNodeImpl((Element)new EdgeImpl("uuid")));
    }
}

