/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.webapp.kogito.common.client.services;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.kie.workbench.common.dmn.api.editors.types.DMNSimpleTimeZone;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.services.TimeZonesProvider;
import org.mockito.Mockito;

public class TimeZonesProviderTest {
    private List<DMNSimpleTimeZone> timeZones;

    @Before
    public void setup() {
        TimeZonesProvider timeZonesProvider = (TimeZonesProvider)Mockito.spy((Object)new TimeZonesProvider());
        ((TimeZonesProvider)Mockito.doCallRealMethod().when((Object)timeZonesProvider)).getTimeZones();
        ((TimeZonesProvider)Mockito.doReturn((Object)new String[]{"A", "B"}).when((Object)timeZonesProvider)).getNames();
        ((TimeZonesProvider)Mockito.doReturn((Object)10.0).when((Object)timeZonesProvider)).getOffset("A");
        ((TimeZonesProvider)Mockito.doReturn((Object)-20.0).when((Object)timeZonesProvider)).getOffset("B");
        ((TimeZonesProvider)Mockito.doReturn((Object)"+10.0").when((Object)timeZonesProvider)).getOffsetString("A");
        ((TimeZonesProvider)Mockito.doReturn((Object)"-20.0").when((Object)timeZonesProvider)).getOffsetString("B");
        this.timeZones = timeZonesProvider.getTimeZones();
    }

    @Test
    public void testGetTimeZones() {
        Assertions.assertThat(this.timeZones).hasSize(2);
        Assertions.assertThat((String)this.timeZones.get(0).getId()).isEqualTo("A");
        Assertions.assertThat((String)this.timeZones.get(1).getId()).isEqualTo("B");
    }

    @Test
    public void testGetOffset() {
        Assertions.assertThat(this.timeZones).hasSize(2);
        Assertions.assertThat((double)this.timeZones.get(0).getOffset()).isEqualTo(10.0);
        Assertions.assertThat((double)this.timeZones.get(1).getOffset()).isEqualTo(-20.0);
    }

    @Test
    public void testGetOffsetString() {
        Assertions.assertThat(this.timeZones).hasSize(2);
        Assertions.assertThat((String)this.timeZones.get(0).getOffsetString()).isEqualTo("+10.0");
        Assertions.assertThat((String)this.timeZones.get(1).getOffsetString()).isEqualTo("-20.0");
    }
}

