/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.webapp.kogito.common.client.editor;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.ProvidesResize;
import com.google.gwt.user.client.ui.RequiresResize;
import elemental2.dom.DomGlobal;
import elemental2.dom.HTMLElement;
import elemental2.promise.Promise;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.enterprise.event.Event;
import org.jboss.errai.common.client.ui.ElementWrapperWidget;
import org.kie.workbench.common.dmn.client.commands.general.NavigateToExpressionEditorCommand;
import org.kie.workbench.common.dmn.client.docks.navigator.DecisionNavigatorDock;
import org.kie.workbench.common.dmn.client.editors.drd.DRDNameChanger;
import org.kie.workbench.common.dmn.client.editors.expressions.ExpressionEditorView;
import org.kie.workbench.common.dmn.client.editors.included.IncludedModelsPage;
import org.kie.workbench.common.dmn.client.editors.included.common.IncludedModelsContext;
import org.kie.workbench.common.dmn.client.editors.search.DMNEditorSearchIndex;
import org.kie.workbench.common.dmn.client.editors.search.DMNSearchableElement;
import org.kie.workbench.common.dmn.client.editors.types.DataTypePageTabActiveEvent;
import org.kie.workbench.common.dmn.client.editors.types.DataTypesPage;
import org.kie.workbench.common.dmn.client.editors.types.listview.common.DataTypeEditModeToggleEvent;
import org.kie.workbench.common.dmn.client.events.EditExpressionEvent;
import org.kie.workbench.common.dmn.client.session.DMNSession;
import org.kie.workbench.common.dmn.client.widgets.codecompletion.MonacoFEELInitializer;
import org.kie.workbench.common.dmn.webapp.common.client.docks.preview.PreviewDiagramDock;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.tour.GuidedTourBridgeInitializer;
import org.kie.workbench.common.kogito.client.editor.MultiPageEditorContainerPresenter;
import org.kie.workbench.common.kogito.client.editor.MultiPageEditorContainerView;
import org.kie.workbench.common.stunner.client.widgets.editor.StunnerEditor;
import org.kie.workbench.common.stunner.client.widgets.presenters.session.SessionDiagramPresenter;
import org.kie.workbench.common.stunner.client.widgets.presenters.session.SessionPresenter;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.util.CanvasFileExport;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.core.client.components.layout.LayoutHelper;
import org.kie.workbench.common.stunner.core.client.components.layout.OpenDiagramLayoutExecutor;
import org.kie.workbench.common.stunner.core.client.i18n.ClientTranslationService;
import org.kie.workbench.common.stunner.core.client.service.ClientRuntimeError;
import org.kie.workbench.common.stunner.core.client.service.ServiceCallback;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;
import org.kie.workbench.common.stunner.core.client.session.impl.AbstractSession;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.documentation.DocumentationPage;
import org.kie.workbench.common.stunner.core.documentation.DocumentationView;
import org.kie.workbench.common.stunner.core.graph.processing.layout.LayoutExecutor;
import org.kie.workbench.common.stunner.forms.client.event.RefreshFormPropertiesEvent;
import org.kie.workbench.common.stunner.kogito.client.docks.DiagramEditorPropertiesDock;
import org.kie.workbench.common.stunner.kogito.client.service.KogitoClientDiagramService;
import org.kie.workbench.common.widgets.client.search.common.EditorSearchIndex;
import org.kie.workbench.common.widgets.client.search.component.SearchBarComponent;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartTitleDecoration;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.promise.Promises;
import org.uberfire.client.views.pfly.multipage.MultiPageEditorSelectedPageEvent;
import org.uberfire.client.workbench.widgets.multipage.Page;
import org.uberfire.ext.editor.commons.client.BaseEditorView;
import org.uberfire.ext.editor.commons.client.menu.MenuItems;
import org.uberfire.lifecycle.GetContent;
import org.uberfire.lifecycle.GetPreview;
import org.uberfire.lifecycle.IsDirty;
import org.uberfire.lifecycle.OnClose;
import org.uberfire.lifecycle.OnFocus;
import org.uberfire.lifecycle.OnLostFocus;
import org.uberfire.lifecycle.OnMayClose;
import org.uberfire.lifecycle.OnOpen;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.lifecycle.SetContent;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.model.menu.Menus;

public abstract class AbstractDMNDiagramEditor
extends MultiPageEditorContainerPresenter<Diagram> {
    public static final String PERSPECTIVE_ID = "AuthoringPerspective";
    public static final String EDITOR_ID = "DMNDiagramEditor";
    public static final int DATA_TYPES_PAGE_INDEX = 2;
    protected final StunnerEditor stunnerEditor;
    protected final SessionManager sessionManager;
    protected final SessionCommandManager<AbstractCanvasHandler> sessionCommandManager;
    protected final DocumentationView documentationView;
    protected final ClientTranslationService translationService;
    protected final Event<RefreshFormPropertiesEvent> refreshFormPropertiesEvent;
    protected final DecisionNavigatorDock decisionNavigatorDock;
    protected final DiagramEditorPropertiesDock diagramPropertiesDock;
    protected final PreviewDiagramDock diagramPreviewAndExplorerDock;
    protected final LayoutHelper layoutHelper;
    protected final OpenDiagramLayoutExecutor openDiagramLayoutExecutor;
    protected final DataTypesPage dataTypesPage;
    protected final DMNEditorSearchIndex editorSearchIndex;
    protected final SearchBarComponent<DMNSearchableElement> searchBarComponent;
    protected final KogitoClientDiagramService diagramServices;
    protected final MonacoFEELInitializer feelInitializer;
    protected final CanvasFileExport canvasFileExport;
    protected final Promises promises;
    protected final IncludedModelsPage includedModelsPage;
    protected final IncludedModelsContext includedModelContext;
    protected final GuidedTourBridgeInitializer guidedTourBridgeInitializer;
    protected final DRDNameChanger drdNameChanger;

    public AbstractDMNDiagramEditor(View view, PlaceManager placeManager, MultiPageEditorContainerView containerView, StunnerEditor stunnerEditor, DMNEditorSearchIndex editorSearchIndex, SearchBarComponent<DMNSearchableElement> searchBarComponent, SessionManager sessionManager, SessionCommandManager<AbstractCanvasHandler> sessionCommandManager, DocumentationView documentationView, ClientTranslationService translationService, Event<RefreshFormPropertiesEvent> refreshFormPropertiesEvent, DecisionNavigatorDock decisionNavigatorDock, DiagramEditorPropertiesDock diagramPropertiesDock, PreviewDiagramDock diagramPreviewAndExplorerDock, LayoutHelper layoutHelper, OpenDiagramLayoutExecutor openDiagramLayoutExecutor, DataTypesPage dataTypesPage, KogitoClientDiagramService diagramServices, MonacoFEELInitializer feelInitializer, CanvasFileExport canvasFileExport, Promises promises, IncludedModelsPage includedModelsPage, IncludedModelsContext includedModelContext, GuidedTourBridgeInitializer guidedTourBridgeInitializer, DRDNameChanger drdNameChanger) {
        super((BaseEditorView)view, placeManager, containerView);
        this.stunnerEditor = stunnerEditor;
        this.sessionManager = sessionManager;
        this.sessionCommandManager = sessionCommandManager;
        this.documentationView = documentationView;
        this.translationService = translationService;
        this.refreshFormPropertiesEvent = refreshFormPropertiesEvent;
        this.decisionNavigatorDock = decisionNavigatorDock;
        this.diagramPropertiesDock = diagramPropertiesDock;
        this.diagramPreviewAndExplorerDock = diagramPreviewAndExplorerDock;
        this.layoutHelper = layoutHelper;
        this.openDiagramLayoutExecutor = openDiagramLayoutExecutor;
        this.dataTypesPage = dataTypesPage;
        this.editorSearchIndex = editorSearchIndex;
        this.searchBarComponent = searchBarComponent;
        this.diagramServices = diagramServices;
        this.feelInitializer = feelInitializer;
        this.canvasFileExport = canvasFileExport;
        this.promises = promises;
        this.includedModelsPage = includedModelsPage;
        this.includedModelContext = includedModelContext;
        this.guidedTourBridgeInitializer = guidedTourBridgeInitializer;
        this.drdNameChanger = drdNameChanger;
    }

    @OnStartup
    public void onStartup(PlaceRequest place) {
        this.init(place);
        this.stunnerEditor.setReadOnly(this.isReadOnly());
        this.decisionNavigatorDock.init(PERSPECTIVE_ID);
        this.diagramPropertiesDock.init(PERSPECTIVE_ID);
        this.diagramPreviewAndExplorerDock.init(PERSPECTIVE_ID);
        this.guidedTourBridgeInitializer.init();
    }

    protected Supplier<Diagram> getContentSupplier() {
        return () -> ((StunnerEditor)this.stunnerEditor).getDiagram();
    }

    protected Integer getCurrentContentHash() {
        return this.stunnerEditor.getCurrentContentHash();
    }

    public void addDocumentationPage(Diagram diagram) {
        Optional.ofNullable(this.documentationView.isEnabled()).filter(Boolean.TRUE::equals).ifPresent(enabled -> {
            String label = this.translationService.getValue("Documentation");
            this.addPage((Page)new DocumentationPage(this.documentationView.initialize(diagram), label, () -> {}, () -> Objects.equals(2, this.getSelectedTabIndex())));
        });
    }

    private void setupSessionHeaderContainer() {
        SessionDiagramPresenter presenter = this.stunnerEditor.getPresenter();
        this.drdNameChanger.setSessionPresenterView(presenter.getView());
        presenter.getView().setSessionHeaderContainer(this.getWidget(this.drdNameChanger.getElement()));
    }

    private void setupEditorSearchIndex() {
        this.editorSearchIndex.setCurrentAssetHashcodeSupplier(() -> ((StunnerEditor)this.stunnerEditor).getCurrentContentHash());
        this.editorSearchIndex.setIsDataTypesTabActiveSupplier(this.getIsDataTypesTabActiveSupplier());
    }

    Supplier<Boolean> getIsDataTypesTabActiveSupplier() {
        return () -> {
            int selectedPageIndex = this.getWidget().getMultiPage().selectedPage();
            return selectedPageIndex == 2;
        };
    }

    void setupSearchComponent() {
        HTMLElement element = this.searchBarComponent.getView().getElement();
        this.searchBarComponent.init((EditorSearchIndex)this.editorSearchIndex);
        this.getWidget().getMultiPage().addTabBarWidget(this.getWidget(element));
    }

    protected ElementWrapperWidget<?> getWidget(HTMLElement element) {
        return ElementWrapperWidget.getWidget((HTMLElement)element);
    }

    public void onDataTypePageNavTabActiveEvent(DataTypePageTabActiveEvent event) {
        this.getWidget().getMultiPage().selectPage(2);
    }

    public void open(final Diagram diagram, final SessionPresenter.SessionPresenterCallback callback) {
        final AbstractSession currentSession = !this.stunnerEditor.isClosed() ? (AbstractSession)this.stunnerEditor.getSession() : null;
        this.layoutHelper.applyLayout(diagram, (LayoutExecutor)this.openDiagramLayoutExecutor);
        this.feelInitializer.initializeFEELEditor();
        this.stunnerEditor.open(diagram, new SessionPresenter.SessionPresenterCallback(){

            public void afterCanvasInitialized() {
                callback.afterCanvasInitialized();
            }

            public void onOpen(Diagram diagram2) {
                callback.onOpen(diagram2);
            }

            public void afterSessionOpened() {
                callback.afterSessionOpened();
            }

            public void onSuccess() {
                AbstractDMNDiagramEditor.this.initialiseKieEditorForSession(diagram);
                AbstractDMNDiagramEditor.this.setupSessionHeaderContainer();
                callback.onSuccess();
                if (null != currentSession) {
                    currentSession.close();
                }
            }

            public void onError(ClientRuntimeError error) {
                callback.onError(error);
            }
        });
    }

    public void initialiseKieEditorForSession(Diagram diagram) {
        this.resetEditorPages();
        this.onDiagramLoad();
        this.resetContentHash();
        this.addDocumentationPage(diagram);
        this.getBaseEditorView().hideBusyIndicator();
        this.getWidget().getMultiPage().addPage((Page)this.dataTypesPage);
        if (this.includedModelContext.isIncludedModelChannel()) {
            this.getWidget().getMultiPage().addPage((Page)this.includedModelsPage);
        }
        this.setupEditorSearchIndex();
        this.setupSearchComponent();
    }

    protected void onDiagramLoad() {
    }

    @OnOpen
    public void onOpen() {
    }

    @OnClose
    public void onClose() {
        this.stunnerEditor.close();
        this.decisionNavigatorDock.destroy();
        this.decisionNavigatorDock.resetContent();
        this.diagramPropertiesDock.destroy();
        this.diagramPreviewAndExplorerDock.destroy();
        this.dataTypesPage.disableShortcuts();
    }

    @OnFocus
    public void onFocus() {
        this.stunnerEditor.focus();
        this.dataTypesPage.onFocus();
        this.dataTypesPage.enableShortcuts();
    }

    @OnLostFocus
    public void onLostFocus() {
        this.stunnerEditor.lostFocus();
        this.dataTypesPage.onLostFocus();
    }

    @WorkbenchPartTitleDecoration
    public IsWidget getTitle() {
        return super.getTitle();
    }

    @WorkbenchPartTitle
    public String getTitleText() {
        return "";
    }

    @WorkbenchMenu
    public void getMenus(Consumer<Menus> menusConsumer) {
        menusConsumer.accept(super.getMenus());
    }

    protected void buildMenuBar() {
    }

    protected void makeMenuBar() {
    }

    @WorkbenchPartView
    public IsWidget asWidget() {
        return super.asWidget();
    }

    @OnMayClose
    public boolean onMayClose() {
        return super.mayClose();
    }

    public void onDataTypeEditModeToggle(DataTypeEditModeToggleEvent event) {
        this.scheduleOnDataTypeEditModeToggleCallback(event);
    }

    protected void scheduleOnDataTypeEditModeToggleCallback(DataTypeEditModeToggleEvent event) {
        DomGlobal.setTimeout((DomGlobal.SetTimeoutCallbackFn)this.getOnDataTypeEditModeToggleCallback(event), (double)250.0, (Object[])new Object[0]);
    }

    protected DomGlobal.SetTimeoutCallbackFn getOnDataTypeEditModeToggleCallback(DataTypeEditModeToggleEvent event) {
        return e -> {
            if (event.isEditModeEnabled()) {
                this.disableMenuItem(MenuItems.SAVE);
            } else {
                this.enableMenuItem(MenuItems.SAVE);
            }
        };
    }

    protected void onMultiPageEditorSelectedPageEvent(MultiPageEditorSelectedPageEvent event) {
        this.searchBarComponent.disableSearch();
    }

    protected void onRefreshFormPropertiesEvent(RefreshFormPropertiesEvent event) {
        this.searchBarComponent.disableSearch();
    }

    protected void onEditExpressionEvent(EditExpressionEvent event) {
        this.searchBarComponent.disableSearch();
        if (AbstractDMNDiagramEditor.isSameSession(this.stunnerEditor.getSession(), event.getSession())) {
            DMNSession session = (DMNSession)this.sessionManager.getCurrentSession();
            ExpressionEditorView.Presenter expressionEditor = session.getExpressionEditor();
            this.sessionCommandManager.execute((Object)session.getCanvasHandler(), (Command)new NavigateToExpressionEditorCommand(expressionEditor, (SessionPresenter)this.stunnerEditor.getPresenter(), this.sessionManager, this.sessionCommandManager, this.refreshFormPropertiesEvent, event.getNodeUUID(), event.getHasExpression(), event.getHasName(), event.isOnlyVisualChangeAllowed()));
        }
    }

    private static boolean isSameSession(ClientSession s1, ClientSession s2) {
        return null != s1 && null != s2 && s1.equals(s2);
    }

    @GetContent
    public Promise getContent() {
        if (this.stunnerEditor.isXmlEditorEnabled()) {
            return this.promises.resolve((Object)this.stunnerEditor.getXmlEditorView().getContent());
        }
        return this.diagramServices.transform(this.stunnerEditor.getDiagram());
    }

    @IsDirty
    public boolean isDirty() {
        return super.isDirty();
    }

    @SetContent
    public Promise setContent(String path, String value) {
        this.stunnerEditor.close();
        Promise promise = this.promises.create((success, failure) -> {
            this.getBaseEditorView().showLoading();
            this.diagramServices.transform(path, value, (ServiceCallback)new ServiceCallback<Diagram>(){

                public void onSuccess(Diagram diagram) {
                    AbstractDMNDiagramEditor.this.open(diagram, new SessionPresenter.SessionPresenterCallback(){

                        public void onSuccess() {
                            success.onInvoke(null);
                        }

                        public void onError(ClientRuntimeError error) {
                            AbstractDMNDiagramEditor.this.onEditorError(error);
                            failure.onInvoke((Object)error);
                        }
                    });
                }

                public void onError(ClientRuntimeError error) {
                    AbstractDMNDiagramEditor.this.onEditorError(error);
                    failure.onInvoke((Object)error);
                }
            });
        });
        return promise;
    }

    private void onEditorError(ClientRuntimeError error) {
        this.getBaseEditorView().hideBusyIndicator();
        this.stunnerEditor.handleError(error);
        this.resetEditorPages();
    }

    public void resetContentHash() {
        this.setOriginalContentHash(this.stunnerEditor.getCurrentContentHash());
    }

    @GetPreview
    public Promise getPreview() {
        CanvasHandler canvasHandler = this.stunnerEditor.getCanvasHandler();
        if (canvasHandler != null) {
            return Promise.resolve((Object)this.canvasFileExport.exportToSvg((AbstractCanvasHandler)canvasHandler));
        }
        return Promise.resolve((Object)"");
    }

    public static interface View
    extends BaseEditorView,
    RequiresResize,
    ProvidesResize,
    IsWidget {
        public void setWidget(IsWidget var1);
    }
}

