/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.showcase.client.editor;

import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.dom.HTMLElement;
import javax.enterprise.event.Event;
import org.assertj.core.api.Assertions;
import org.jboss.errai.common.client.ui.ElementWrapperWidget;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.types.listview.common.DataTypeEditModeToggleEvent;
import org.kie.workbench.common.dmn.showcase.client.editor.DMNDiagramEditor;
import org.kie.workbench.common.dmn.showcase.client.navigator.DMNVFSService;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.editor.BaseDMNDiagramEditor;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.editor.BaseDMNDiagramEditorTest;
import org.kie.workbench.common.stunner.core.client.service.ServiceCallback;
import org.kie.workbench.common.stunner.kogito.client.PromiseMock;
import org.kie.workbench.common.stunner.kogito.client.editor.DiagramEditorCore;
import org.kie.workbench.common.widgets.client.menu.FileMenuBuilder;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.promise.Promises;
import org.uberfire.ext.editor.commons.client.file.popups.CopyPopUpPresenter;
import org.uberfire.ext.editor.commons.client.file.popups.DeletePopUpPresenter;
import org.uberfire.ext.editor.commons.client.file.popups.RenamePopUpPresenter;
import org.uberfire.ext.editor.commons.client.menu.BasicFileMenuBuilderImpl;
import org.uberfire.ext.editor.commons.client.menu.RestoreVersionCommandProvider;
import org.uberfire.ext.widgets.common.client.common.BusyIndicatorView;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.util.URIUtil;
import org.uberfire.workbench.events.NotificationEvent;
import org.uberfire.workbench.model.menu.MenuItem;

@RunWith(value=GwtMockitoTestRunner.class)
public class DMNDiagramEditorTest
extends BaseDMNDiagramEditorTest {
    private final String FILE_NAME = "file name.dmn";
    private final String CONTENT = "xml-content-of-dmn-file";
    @Mock
    private MenuItem saveMenuItem;
    @Mock
    private DeletePopUpPresenter deletePopUpPresenter;
    @Mock
    private CopyPopUpPresenter copyPopUpPresenter;
    @Mock
    private RenamePopUpPresenter renamePopUpPresenter;
    @Mock
    private BusyIndicatorView busyIndicatorView;
    @Mock
    private RestoreVersionCommandProvider restoreVersionCommandProvider;
    private BasicFileMenuBuilderImpl basicFileMenuBuilder;
    @Mock
    private DMNVFSService vfsService;
    @Mock
    private Promises promises;
    @Captor
    private ArgumentCaptor<Command> commandArgumentCaptor;
    @Captor
    private ArgumentCaptor<ServiceCallback<String>> serviceCallbackArgumentCaptor;
    @Captor
    private ArgumentCaptor<Path> pathArgumentCaptor;

    public void setup() {
        super.setup();
        this.basicFileMenuBuilder = new BasicFileMenuBuilderImpl(this.deletePopUpPresenter, this.copyPopUpPresenter, this.renamePopUpPresenter, this.busyIndicatorView, (Event)this.notificationEventSourceMock, this.restoreVersionCommandProvider);
        ((FileMenuBuilder)Mockito.doAnswer(i -> {
            this.basicFileMenuBuilder.addSave(this.saveMenuItem);
            return this.fileMenuBuilder;
        }).when((Object)this.fileMenuBuilder)).addSave((Command)Matchers.any(Command.class));
        ((FileMenuBuilder)Mockito.doAnswer(i -> this.basicFileMenuBuilder.build()).when((Object)this.fileMenuBuilder)).build();
    }

    protected BaseDMNDiagramEditor getEditor() {
        return new DMNDiagramEditor(this.view, this.fileMenuBuilder, this.placeManager, this.multiPageEditorContainerView, (Event)this.changeTitleWidgetEventSourceMock, (Event)this.notificationEventSourceMock, (Event)this.onDiagramFocusEventSourceMock, this.xmlEditorView, (ManagedInstance)this.sessionEditorPresenters, (ManagedInstance)this.sessionViewerPresenters, this.dmnEditorMenuSessionItems, this.errorPopupPresenter, this.diagramClientErrorHandler, this.clientTranslationService, this.documentationView, this.editorSearchIndex, this.searchBarComponent, this.sessionManager, this.sessionCommandManager, (Event)this.refreshFormPropertiesEventSourceMock, this.decisionNavigatorDock, this.diagramPropertiesDock, this.diagramPreviewDock, this.layoutHelper, this.layoutExecutor, this.dataTypesPage, this.includedModelsPage, this.importsPageProvider, this.clientDiagramService, this.vfsService, this.promises){

            protected PlaceRequest getPlaceRequest() {
                return DMNDiagramEditorTest.this.place;
            }

            protected ElementWrapperWidget<?> getWidget(HTMLElement element) {
                return DMNDiagramEditorTest.this.searchBarComponentWidget;
            }

            protected void scheduleOnDataTypeEditModeToggleCallback(DataTypeEditModeToggleEvent event) {
                this.getOnDataTypeEditModeToggleCallback(event).onInvoke(new Object[]{event});
            }
        };
    }

    @Test
    public void testOnStartup() {
        super.testOnStartup();
        ((BaseDMNDiagramEditor)Mockito.verify((Object)this.editor)).setContent((String)Matchers.eq((Object)""));
    }

    @Test
    public void testOnDataTypeEditModeToggleEnabled() {
        super.testOnDataTypeEditModeToggleEnabled();
        ((MenuItem)Mockito.verify((Object)this.saveMenuItem)).setEnabled(Matchers.eq((boolean)false));
    }

    @Test
    public void testOnDataTypeEditModeToggleDisabled() {
        super.testOnDataTypeEditModeToggleDisabled();
        ((MenuItem)Mockito.verify((Object)this.saveMenuItem)).setEnabled(Matchers.eq((boolean)true));
    }

    @Test
    public void testDoSave() {
        PromiseMock promise = new PromiseMock();
        ((BaseDMNDiagramEditor)Mockito.doReturn((Object)promise.asPromise()).when((Object)this.editor)).getContent();
        promise.then(() -> "xml-content-of-dmn-file");
        this.openDiagram();
        Mockito.reset((Object[])new DiagramEditorCore.View[]{this.view});
        ((FileMenuBuilder)Mockito.verify((Object)this.fileMenuBuilder)).addSave((Command)this.commandArgumentCaptor.capture());
        Command command = (Command)this.commandArgumentCaptor.getValue();
        Assertions.assertThat((Object)command).isNotNull();
        command.execute();
        ((DMNVFSService)Mockito.verify((Object)this.vfsService)).saveFile((Path)this.pathArgumentCaptor.capture(), (String)Matchers.eq((Object)"xml-content-of-dmn-file"), (ServiceCallback)this.serviceCallbackArgumentCaptor.capture());
        Path path = (Path)this.pathArgumentCaptor.getValue();
        Assertions.assertThat((Comparable)path).isNotNull();
        Assertions.assertThat((Comparable)path).isEqualTo((Object)this.metadata.getPath());
        ServiceCallback serviceCallback = (ServiceCallback)this.serviceCallbackArgumentCaptor.getValue();
        Assertions.assertThat((Object)serviceCallback).isNotNull();
        serviceCallback.onSuccess((Object)"xml-content-of-dmn-file");
        ((BaseDMNDiagramEditor)Mockito.verify((Object)this.editor)).resetContentHash();
        ((EventSourceMock)Mockito.verify((Object)this.notificationEventSourceMock)).fire(Matchers.any(NotificationEvent.class));
        ((DiagramEditorCore.View)Mockito.verify((Object)this.view)).hideBusyIndicator();
    }

    protected void openDiagram() {
        this.place.addParameter("fileName", "file name.dmn");
        super.openDiagram();
        Path path = this.metadata.getPath();
        Assertions.assertThat((Comparable)path).isNotNull();
        Assertions.assertThat((String)path.getFileName()).isEqualTo((Object)"file name.dmn");
        Assertions.assertThat((String)path.toURI()).isEqualTo((Object)("default://master@system/stunner/diagrams/" + URIUtil.encode((String)"file name.dmn")));
    }
}

