/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.showcase.client.navigator;

import java.util.Map;
import org.assertj.core.api.Assertions;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.showcase.client.navigator.DMNVFSService;
import org.kie.workbench.common.stunner.core.client.service.ServiceCallback;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.VFSService;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.mvp.PlaceRequest;

@RunWith(value=MockitoJUnitRunner.class)
public class DMNVFSServiceTest {
    private final String FILE_NAME = "fileName.dmn";
    private final String CONTENT = "xml-content-of-dmn-file";
    @Mock
    private PlaceManager placeManager;
    @Mock
    private Caller<VFSService> vfsServiceCaller;
    @Mock
    private VFSService vfsService;
    @Mock
    private Path path;
    @Mock
    private ServiceCallback<String> callback;
    @Captor
    private ArgumentCaptor<RemoteCallback<String>> remoteCallbackStringArgumentCaptor;
    @Captor
    private ArgumentCaptor<RemoteCallback<Path>> remoteCallbackPathArgumentCaptor;
    @Captor
    private ArgumentCaptor<PlaceRequest> placeRequestArgumentCaptor;
    private DMNVFSService dmnvfsService;

    @Before
    public void setup() {
        this.dmnvfsService = new DMNVFSService(this.placeManager, this.vfsServiceCaller);
        Mockito.when((Object)this.vfsServiceCaller.call((RemoteCallback)Matchers.any(RemoteCallback.class))).thenReturn((Object)this.vfsService);
        Mockito.when((Object)this.path.getFileName()).thenReturn((Object)"fileName.dmn");
    }

    @Test
    public void testNewFile() {
        this.dmnvfsService.newFile();
        ((PlaceManager)Mockito.verify((Object)this.placeManager)).goTo((PlaceRequest)this.placeRequestArgumentCaptor.capture());
        PlaceRequest placeRequest = (PlaceRequest)this.placeRequestArgumentCaptor.getValue();
        Assertions.assertThat((Map)placeRequest.getParameters()).hasSize(1);
        Assertions.assertThat((String)placeRequest.getParameter("fileName", "")).isNotBlank();
    }

    @Test
    public void testOpenFile() {
        this.dmnvfsService.openFile(this.path);
        ((Caller)Mockito.verify(this.vfsServiceCaller)).call((RemoteCallback)this.remoteCallbackStringArgumentCaptor.capture());
        ((VFSService)Mockito.verify((Object)this.vfsService)).readAllString((Path)Matchers.eq((Object)this.path));
        RemoteCallback remoteCallback = (RemoteCallback)this.remoteCallbackStringArgumentCaptor.getValue();
        Assertions.assertThat((Object)remoteCallback).isNotNull();
        remoteCallback.callback((Object)"xml-content-of-dmn-file");
        ((PlaceManager)Mockito.verify((Object)this.placeManager)).goTo((PlaceRequest)this.placeRequestArgumentCaptor.capture());
        PlaceRequest placeRequest = (PlaceRequest)this.placeRequestArgumentCaptor.getValue();
        Assertions.assertThat((Map)placeRequest.getParameters()).hasSize(2);
        Assertions.assertThat((String)placeRequest.getParameter("fileName", "")).isEqualTo("fileName.dmn");
        Assertions.assertThat((String)placeRequest.getParameter("content", "")).isEqualTo("xml-content-of-dmn-file");
    }

    @Test
    public void testSaveFile() {
        this.dmnvfsService.saveFile(this.path, "xml-content-of-dmn-file", this.callback);
        ((Caller)Mockito.verify(this.vfsServiceCaller)).call((RemoteCallback)this.remoteCallbackPathArgumentCaptor.capture());
        ((VFSService)Mockito.verify((Object)this.vfsService)).write((Path)Matchers.eq((Object)this.path), (String)Matchers.eq((Object)"xml-content-of-dmn-file"));
        RemoteCallback remoteCallback = (RemoteCallback)this.remoteCallbackPathArgumentCaptor.getValue();
        Assertions.assertThat((Object)remoteCallback).isNotNull();
        remoteCallback.callback((Object)this.path);
        ((ServiceCallback)Mockito.verify(this.callback)).onSuccess(Matchers.eq((Object)"xml-content-of-dmn-file"));
    }
}

