/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.kogito.webapp.base.client.workarounds;

import elemental2.promise.Promise;
import java.util.Arrays;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.appformer.kogito.bridge.client.resource.ResourceContentService;
import org.appformer.kogito.bridge.client.resource.interop.ResourceListOptions;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.uberfire.client.promise.Promises;

@ApplicationScoped
public class KogitoResourceContentService {
    private ResourceContentService resourceContentService;
    private Promises promises;

    private KogitoResourceContentService() {
    }

    @Inject
    public KogitoResourceContentService(ResourceContentService resourceContentService, Promises promises) {
        this.resourceContentService = resourceContentService;
        this.promises = promises;
    }

    public void loadFile(String fileUri, RemoteCallback<String> callback, ErrorCallback<Object> errorCallback) {
        this.resourceContentService.get(fileUri).then(fileContent -> {
            callback.callback(fileContent);
            return this.promises.resolve();
        }).catch_(error -> {
            errorCallback.error((Object)("Error " + error), new Throwable("Failed to load file " + fileUri));
            return null;
        });
    }

    public void getAllItems(RemoteCallback<List<String>> callback, ErrorCallback<Object> errorCallback) {
        this.getFilteredItems("*", callback, errorCallback);
    }

    public void getFilteredItems(String pattern, RemoteCallback<List<String>> callback, ErrorCallback<Object> errorCallback) {
        this.resourceContentService.list(pattern).then(fileList -> {
            callback.callback(Arrays.asList(fileList));
            return this.promises.resolve();
        }).catch_(error -> {
            errorCallback.error((Object)("Error " + error), new Throwable("Failed to retrieve files with pattern " + pattern));
            return null;
        });
    }

    public Promise<String[]> getFilteredItems(String pattern, ResourceListOptions options) {
        return this.resourceContentService.list(pattern, options);
    }

    public Promise<String> loadFile(String fileUri) {
        return this.resourceContentService.get(fileUri);
    }
}

