/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.kogito.webapp.base.client.perspectives;

import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.kie.workbench.common.kogito.webapp.base.client.editor.KogitoScreen;
import org.kie.workbench.common.kogito.webapp.base.client.perspectives.AuthoringPerspective;
import org.kie.workbench.common.kogito.webapp.base.client.perspectives.PerspectiveConfiguration;
import org.uberfire.client.workbench.panels.impl.AbstractWorkbenchPanelPresenter;
import org.uberfire.client.workbench.panels.impl.MultiListWorkbenchPanelPresenter;
import org.uberfire.client.workbench.panels.impl.StaticWorkbenchPanelPresenter;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.workbench.model.PartDefinition;
import org.uberfire.workbench.model.PerspectiveDefinition;

public class AuthoringPerspectiveTest {
    private static final String TESTING_IDENTIFIER = "TESTING_IDENTIFIER";
    private static final PlaceRequest TESTING_REQUEST = new DefaultPlaceRequest("TESTING_IDENTIFIER");
    private static final String RUNNING_IDENTIFIER = "RUNNING_IDENTIFIER";
    private static final PlaceRequest RUNNING_REQUEST = new DefaultPlaceRequest("RUNNING_IDENTIFIER");

    @Test
    public void buildTestingPerspective() {
        AuthoringPerspective perspective = new AuthoringPerspective();
        perspective.perspectiveConfiguration = new TestingPerspectiveConfiguration();
        perspective.kogitoScreen = this.getKogitoScreen(TESTING_REQUEST);
        PerspectiveDefinition perspectiveDefinition = perspective.buildPerspective();
        Assert.assertNotNull((Object)perspectiveDefinition);
        Assert.assertEquals((Object)MultiListWorkbenchPanelPresenter.class.getName(), (Object)perspectiveDefinition.getRoot().getPanelType());
        Assert.assertEquals((Object)"Authoring", (Object)perspectiveDefinition.getName());
        Set parts = perspectiveDefinition.getRoot().getParts();
        Assert.assertEquals((long)1L, (long)parts.size());
        PartDefinition part = (PartDefinition)parts.iterator().next();
        Assert.assertNotNull((Object)part.getPlace());
        Assert.assertTrue((boolean)(part.getPlace() instanceof DefaultPlaceRequest));
        Assert.assertEquals((Object)TESTING_IDENTIFIER, (Object)part.getPlace().getIdentifier());
    }

    @Test
    public void buildRuntimePerspective() {
        AuthoringPerspective perspective = new AuthoringPerspective();
        perspective.perspectiveConfiguration = new PerspectiveConfiguration();
        perspective.kogitoScreen = this.getKogitoScreen(RUNNING_REQUEST);
        PerspectiveDefinition perspectiveDefinition = perspective.buildPerspective();
        Assert.assertNotNull((Object)perspectiveDefinition);
        Assert.assertEquals((Object)StaticWorkbenchPanelPresenter.class.getName(), (Object)perspectiveDefinition.getRoot().getPanelType());
        Assert.assertEquals((Object)"Authoring", (Object)perspectiveDefinition.getName());
        Set parts = perspectiveDefinition.getRoot().getParts();
        Assert.assertEquals((long)1L, (long)parts.size());
        PartDefinition part = (PartDefinition)parts.iterator().next();
        Assert.assertNotNull((Object)part.getPlace());
        Assert.assertTrue((boolean)(part.getPlace() instanceof DefaultPlaceRequest));
        Assert.assertEquals((Object)RUNNING_IDENTIFIER, (Object)part.getPlace().getIdentifier());
    }

    private KogitoScreen getKogitoScreen(PlaceRequest placeRequest) {
        return () -> placeRequest;
    }

    private static class TestingPerspectiveConfiguration
    extends PerspectiveConfiguration {
        private TestingPerspectiveConfiguration() {
        }

        public Class<? extends AbstractWorkbenchPanelPresenter> getPerspectivePanelType() {
            return MultiListWorkbenchPanelPresenter.class;
        }
    }
}

