/*
 * Copyright 2016 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.kie.workbench.common.screens.datasource.management.client.resources.i18n;

import org.jboss.errai.ui.shared.api.annotations.TranslationKey;

public interface DataSourceManagementConstants {

    @TranslationKey( defaultValue = "" )
    String DataSourceDefEditor_InvalidNameMessage = "DataSourceDefEditor.InvalidNameMessage";

    @TranslationKey( defaultValue = "" )
    String DataSourceDefEditor_InvalidConnectionURLMessage = "DataSourceDefEditor.InvalidConnectionURLMessage";

    @TranslationKey( defaultValue = "" )
    String DataSourceDefEditor_InvalidUserMessage = "DataSourceDefEditor.InvalidUserMessage";

    @TranslationKey( defaultValue = "" )
    String DataSourceDefEditor_InvalidPasswordMessage = "DataSourceDefEditor.InvalidPasswordMessage";

    @TranslationKey( defaultValue = "" )
    String DataSourceDefEditor_DriverRequiredMessage = "DataSourceDefEditor.DriverRequiredMessage";

    @TranslationKey( defaultValue = "" )
    String DataSourceDefEditor_AllFieldsRequiresValidation = "DataSourceDefEditor.AllFieldsRequiresValidation";

    @TranslationKey( defaultValue = "" )
    String DataSourceDefEditor_LoadDriversErrorMessage = "DataSourceDefEditor.LoadDriversErrorMessage";

    @TranslationKey( defaultValue = "" )
    String DataSourceDefEditor_ConnectionTestSuccessfulMessage = "DataSourceDefEditor.ConnectionTestSuccessfulMessage";

    @TranslationKey( defaultValue = "" )
    String DataSourceDefEditor_ConnectionTestFailedMessage = "DataSourceDefEditor.ConnectionTestFailedMessage";

    @TranslationKey( defaultValue = "" )
    String DataSourceDefEditor_DataSourceHasBeenReferencedForDeleteMessage = "DataSourceDefEditor.DataSourceHasBeenReferencedForDeleteMessage";

    @TranslationKey( defaultValue = "" )
    String DataSourceDefEditor_DataSourceHasBeenReferencedForSaveMessage = "DataSourceDefEditor.DataSourceHasBeenReferencedForSaveMessage";

    @TranslationKey( defaultValue = "" )
    String NewDataSourceDefWizard_title = "NewDataSourceDefWizard.title";

    @TranslationKey( defaultValue = "" )
    String NewDataSourceDefWizard_DataSourceCreatedMessage = "NewDataSourceDefWizard.DataSourceCreatedMessage";

    @TranslationKey( defaultValue = "" )
    String NewDataSourceDefWizard_DataSourceCreateErrorMessage = "NewDataSourceDefWizard.DataSourceCreateErrorMessage";

    @TranslationKey( defaultValue = "" )
    String NewDataSourceDefWizard_FileExistsErrorMessage = "NewDataSourceDefWizard.FileExistsErrorMessage";

    @TranslationKey( defaultValue = "")
    String NewDataSourceDefWizard_WizardStartErrorMessage = "NewDataSourceDefWizard.WizardStartErrorMessage";

    @TranslationKey( defaultValue = "" )
    String DataSourceDefPage_pagetTitle = "DataSourceDefPageViewImpl.pageTitle";

    @TranslationKey( defaultValue = "" )
    String DriverDefEditor_InvalidNameMessage = "DriverDefEditor.InvalidNameMessage";

    @TranslationKey( defaultValue = "" )
    String DriverDefEditor_InvalidDriverClassMessage = "DriverDefEditor.InvalidDriverClassMessage";

    @TranslationKey( defaultValue = "" )
    String DriverDefEditor_InvalidGroupIdMessage = "DriverDefEditor.InvalidGroupIdMessage";

    @TranslationKey( defaultValue = "" )
    String DriverDefEditor_InvalidArtifactIdMessage = "DriverDefEditor.InvalidArtifactIdMessage";

    @TranslationKey( defaultValue = "" )
    String DriverDefEditor_InvalidVersionMessage = "DriverDefEditor.InvalidVersionMessage";

    @TranslationKey( defaultValue = "" )
    String DriverDefEditor_DriverHasDependantsForSaveMessage = "DriverDefEditor.DriverHasDependantsForSaveMessage";

    @TranslationKey( defaultValue = "" )
    String DriverDefEditor_DriverHasDependantsForDeleteMessage = "DriverDefEditor.DriverHasDependantsForDeleteMessage";

    @TranslationKey( defaultValue = "" )
    String NewDriverDefWizard_title = "NewDriverDefWizard.title";

    @TranslationKey( defaultValue = "" )
    String NewDriverDefWizard_DriverCreatedMessage = "NewDriverDefWizard.DriverCreatedMessage";

    @TranslationKey( defaultValue = "" )
    String NewDriverDefWizard_DriverCreateErrorMessage = "NewDriverDefWizard.DriverCreateErrorMessage";

    @TranslationKey( defaultValue = "" )
    String DriverDefDefPageViewImpl_pageTitle = "DriverDefDefPageViewImpl.pageTitle";

    @TranslationKey( defaultValue = "" )
    String DataSourceSelector_Title = "DataSourceSelector.Title";

    @TranslationKey( defaultValue = "" )
    String DataSourceSelector_NoAvailableDataSourcesMessage = "DataSourceSelector.NoAvailableDataSourcesMessage";

    @TranslationKey( defaultValue = "" )
    String DataSourceSelector_DataSourceColumn = "DataSourceSelector.DataSourceColumn";

    @TranslationKey( defaultValue = "" )
    String DataSourceSelector_SelectButton = "DataSourceSelector.SelectButton";

    @TranslationKey( defaultValue = "" )
    String DataSourceSelector_DataSourcesLoadError = "DataSourceSelector.DataSourcesLoadError";

    @TranslationKey( defaultValue = "" )
    String DataSourceDefExplorerScreen_Title = "DataSourceDefExplorerScreen.Title";

    @TranslationKey( defaultValue = "" )
    String DataSourceDefExplorerScreen_Refresh = "DataSourceDefExplorerScreen.Refresh";

    @TranslationKey( defaultValue = "" )
    String DatabaseStructureExplorerViewImpl_schemasTitle = "DatabaseStructureExplorerViewImpl.schemasTitle";

    @TranslationKey( defaultValue = "" )
    String DatabaseStructureExplorerViewImpl_defaultSchema = "DatabaseStructureExplorerViewImpl.defaultSchema";

    @TranslationKey( defaultValue = "" )
    String DatabaseStructureExplorerViewImpl_dataSourceTitle = "DatabaseStructureExplorerViewImpl.dataSourceTitle";

    @TranslationKey( defaultValue = "" )
    String DatabaseSchemaExplorerViewImpl_loadingDbSchemas = "DatabaseSchemaExplorerViewImpl.loadingDbSchemas";

    @TranslationKey( defaultValue = "" )
    String DatabaseSchemaExplorerViewImpl_schemasListEmpty = "DatabaseSchemaExplorerViewImpl.schemasListEmpty";

    @TranslationKey( defaultValue = "" )
    String DatabaseSchemaExplorerViewImpl_schemaNameColumn = "DatabaseSchemaExplorerViewImpl.schemaNameColumn";

    @TranslationKey( defaultValue = "" )
    String DatabaseSchemaExplorerViewImpl_actionColumn = "DatabaseSchemaExplorerViewImpl.actionColumn";

    @TranslationKey( defaultValue = "" )
    String DatabaseSchemaExplorerViewImpl_schemaOpenAction = "DatabaseSchemaExplorerViewImpl.schemaOpenAction";

    @TranslationKey( defaultValue = "" )
    String DatabaseObjectExplorerViewImpl_loadingDbObjects = "DatabaseObjectExplorerViewImpl.loadingDbObjects";

    @TranslationKey( defaultValue = "" )
    String DatabaseObjectExplorerViewImpl_loadingDbSchemas = "DatabaseObjectExplorerViewImpl.loadingDbSchemas";

    @TranslationKey( defaultValue = "" )
    String DatabaseObjectExplorerViewImpl_namePatternHelp = "DatabaseObjectExplorerViewImpl.namePatternHelp";

    @TranslationKey( defaultValue = "" )
    String DatabaseObjectExplorerViewImpl_dbObjectNameColumn = "DatabaseObjectExplorerViewImpl.dbObjectNameColumn";

    @TranslationKey( defaultValue = "" )
    String DatabaseObjectExplorerViewImpl_dbObjectsListEmpty = "DatabaseObjectExplorerViewImpl.dbObjectsListEmpty";

    @TranslationKey( defaultValue = "" )
    String DatabaseObjectExplorerViewImpl_dbObjectTypeColumn = "DatabaseObjectExplorerViewImpl.dbObjectTypeColumn";

    @TranslationKey( defaultValue = "" )
    String DatabaseObjectExplorerViewImpl_dbObjectOpen = "DatabaseObjectExplorerViewImpl.dbObjectOpen";

    @TranslationKey( defaultValue = "" )
    String DatabaseObjectExplorerViewImpl_dbObjectActionColumn = "DatabaseObjectExplorerViewImpl.dbObjectActionColumn";

    @TranslationKey( defaultValue = "" )
    String DatabaseStructureExplorerScreen_title = "DatabaseStructureExplorerScreen.title";
}