/*
 * Copyright 2016 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.kie.workbench.common.stunner.client.lienzo.components.palette;

import org.kie.workbench.common.stunner.client.lienzo.components.palette.view.LienzoPaletteView;
import org.kie.workbench.common.stunner.core.client.components.glyph.DefinitionGlyphTooltip;
import org.kie.workbench.common.stunner.core.client.components.palette.model.GlyphPaletteItem;
import org.kie.workbench.common.stunner.core.client.components.palette.model.HasPaletteItems;

import java.util.List;

public interface LienzoGlyphItemsPalette<I extends HasPaletteItems<? extends GlyphPaletteItem>, V extends LienzoPaletteView>
        extends LienzoPalette<I, V> {

    interface GlyphTooltipCallback {

        boolean onShowTooltip( DefinitionGlyphTooltip<?> glyphTooltip,
                               final GlyphPaletteItem item,
                               double mouseX,
                               double mouseY,
                               double itemX,
                               double itemY );

    }

    LienzoGlyphItemsPalette<I, V> setShapeSetId( String shapeSetId );

    List<GlyphPaletteItem> getItems();

    GlyphPaletteItem getItem( int pos );

    LienzoGlyphItemsPalette<I, V> onShowGlyTooltip( GlyphTooltipCallback callback );

}
