/*
 * Copyright 2016 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.kie.workbench.common.stunner.core.factory.impl;

import org.kie.workbench.common.stunner.core.factory.graph.ElementFactory;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.content.Bounds;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.graph.content.view.BoundImpl;
import org.kie.workbench.common.stunner.core.graph.content.view.BoundsImpl;

public abstract class AbstractElementFactory<C, D extends Definition<C>, T extends Element<D>>
        implements ElementFactory<C, D, T> {

    protected AbstractElementFactory() {
    }

    @Override
    public boolean accepts( final Object definition ) {
        return true;
    }

    // TODO: Dummy bounds - In addition see GraphUtils#updateBounds methods.
    protected Bounds buildBounds() {
        return new BoundsImpl( new BoundImpl( 0d, 0d ), new BoundImpl( 30d, 30d ) );
    }

}
