/*
 * Copyright 2016 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kie.workbench.common.stunner.core.graph.command.impl;

import org.jboss.errai.common.client.api.annotations.MapsTo;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;

import java.util.logging.Logger;

/**
 * A Command to delete graph a child node.
 * Does not take care about node'edges neither children nodes.
 */
@Portable
public final class DeleteNodeCommand extends DeregisterNodeCommand {

    private static Logger LOGGER = Logger.getLogger( DeleteNodeCommand.class.getName() );

    public DeleteNodeCommand( @MapsTo( "uuid" ) String uuid ) {
       super( uuid );
    }

    public DeleteNodeCommand( final Node<?, Edge> node ) {
        super( node );
    }

    @Override
    public CommandResult<RuleViolation> undo( GraphCommandExecutionContext context ) {
        final AddNodeCommand undoCommand = new AddNodeCommand( getRemoved() );
        return undoCommand.execute( context );
    }

    @Override
    public String toString() {
        return "DeleteNodeCommand [candidate=" + uuid + "]";
    }

}
