/*
 * Copyright 2016 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.kie.workbench.common.stunner.core.processors.shape;

import org.kie.workbench.common.stunner.core.client.AbstractBindableShapeSet;
import org.kie.workbench.common.stunner.core.processors.AbstractBindableAdapterGenerator;
import org.uberfire.annotations.processors.exceptions.GenerationException;

import javax.annotation.processing.Messager;
import java.util.HashMap;
import java.util.Map;

public class BindableShapeSetGenerator extends AbstractBindableAdapterGenerator {

    @Override
    protected String getTemplatePath() {
        return "BindableShapeSet.ftl";
    }

    public StringBuffer generate( String packageName,
                                  String className,
                                  String defSetClassName,
                                  String shapeFactoryClassName,
                                  Messager messager ) throws GenerationException {
        Map<String, Object> root = new HashMap<String, Object>();
        root.put( "packageName",
                packageName );
        root.put( "className",
                className );
        root.put( "generatedByClassName",
                BindableShapeSetGenerator.class.getName() );
        root.put( "parentClassName",
                AbstractBindableShapeSet.class.getName() );
        root.put( "defSetClass",
                defSetClassName );
        root.put( "shapeFactoryClassName",
                shapeFactoryClassName );
        //Generate code
        return writeTemplate( packageName, className, root, messager );
    }

}
