/*
 * Copyright 2016 Red Hat, Inc. and/or its affiliates.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package org.kie.workbench.common.widgets.client.resources.i18n;

import org.jboss.errai.ui.shared.api.annotations.TranslationKey;

public interface KieWorkbenchWidgetsConstants {

    @TranslationKey( defaultValue = "Create new")
    String NewResourceViewPopupTitle = "NewResourceViewImpl.popupTitle";

    @TranslationKey( defaultValue = "Name:")
    String NewResourceViewItemNameSubheading = "NewResourceViewImpl.itemNameSubheading";

    @TranslationKey( defaultValue = "Missing name for new resource. Please enter.")
    String NewResourceViewFileNameIsMandatory = "NewResourceViewImpl.fileNameIsMandatory";

    @TranslationKey( defaultValue = "Resource Name" )
    String NewResourceViewResourceName = "NewResourceViewImpl.resourceName";

    @TranslationKey( defaultValue = "Package" )
    String NewResourceViewPackageName = "NewResourceViewImpl.packageName";

    @TranslationKey( defaultValue = "Name..." )
    String NewResourceViewResourceNamePlaceholder = "NewResourceViewImpl.resourceNamePlaceholder";

    @TranslationKey( defaultValue = "Path in which to create new resource is missing. Please enter.")
    String NewResourceViewMissingPath = "NewResourceViewImpl.MissingPath";
}
