/*
 * Copyright 2017 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.kie.workbench.common.forms.adf.service.definitions.elements;

import java.util.HashMap;
import java.util.Map;

import org.kie.workbench.common.forms.model.FieldDataType;
import org.kie.workbench.common.forms.model.FieldType;

/**
 * Definition of a FormElement that represents a field on the form.
 */
public class FieldElement extends AbstractFormElement {

    private Class<? extends FieldType> preferredType = FieldType.class;

    private FieldDataType typeInfo;

    private String labelKey;

    private boolean required = false;

    private boolean readOnly = false;

    private String binding;

    private Map<String, String> params = new HashMap<>();

    public FieldElement(String name,
                        String binding,
                        FieldDataType typeInfo) {
        this.name = name;
        this.binding = binding;
        this.typeInfo = typeInfo;
    }

    public String getBinding() {
        return binding;
    }

    public FieldDataType getTypeInfo() {
        return typeInfo;
    }

    public Class<? extends FieldType> getPreferredType() {
        return preferredType;
    }

    public void setPreferredType(Class<? extends FieldType> preferredType) {
        this.preferredType = preferredType;
    }

    public String getLabelKey() {
        return labelKey;
    }

    public void setLabelKey(String labelKey) {
        this.labelKey = labelKey;
    }

    public boolean isRequired() {
        return required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public boolean isReadOnly() {
        return readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public Map<String, String> getParams() {
        return params;
    }

    public void setParams(Map<String, String> params) {
        this.params = params;
    }
}
