/*
 * Copyright 2017 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.kie.workbench.common.stunner.client.widgets.palette.categories;

import org.jboss.errai.common.client.dom.CSSStyleDeclaration;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.kie.workbench.common.stunner.client.widgets.palette.PaletteWidget;
import org.kie.workbench.common.stunner.client.widgets.palette.categories.group.DefinitionPaletteGroupWidget;
import org.kie.workbench.common.stunner.client.widgets.palette.categories.items.DefinitionPaletteItemWidget;
import org.kie.workbench.common.stunner.client.widgets.palette.factory.icons.IconRenderer;
import org.kie.workbench.common.stunner.core.client.components.palette.Palette;
import org.mockito.Mock;

import static org.mockito.Mockito.*;

public class AbstractPaletteRenderingTest {

    @Mock
    protected PaletteWidget.IconRendererProvider iconRendererProvider;

    @Mock
    protected Palette.ItemMouseDownCallback itemMouseDownCallback;

    @Mock
    protected IconRenderer iconRenderer;

    protected void init() {
        when(iconRendererProvider.getCategoryIconRenderer(any())).thenReturn(iconRenderer);
        when(iconRendererProvider.getDefinitionIconRenderer(any())).thenReturn(iconRenderer);
    }

    protected DefinitionPaletteGroupWidget getDefinitionPaletteGroupWidget() {
        DefinitionPaletteGroupWidget widget = mock(DefinitionPaletteGroupWidget.class);
        HTMLElement view = mock(HTMLElement.class);
        when(widget.getElement()).thenReturn(view);
        return widget;
    }

    protected DefinitionPaletteItemWidget getDefinitionPaletteItemWidget() {
        DefinitionPaletteItemWidget widget = mock(DefinitionPaletteItemWidget.class);
        HTMLElement view = mock(HTMLElement.class);
        CSSStyleDeclaration style = mock(CSSStyleDeclaration.class);
        when(view.getStyle()).thenReturn(style);
        when(widget.getElement()).thenReturn(view);
        return widget;
    }
}
