/*
 * Copyright 2017 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.kie.workbench.common.stunner.svg.client.shape.view;

import com.ait.lienzo.client.core.shape.Shape;
import org.kie.workbench.common.stunner.core.client.shape.ShapeState;
import org.kie.workbench.common.stunner.core.client.shape.view.HasControlPoints;
import org.kie.workbench.common.stunner.core.client.shape.view.HasEventHandlers;
import org.kie.workbench.common.stunner.core.client.shape.view.HasFillGradient;
import org.kie.workbench.common.stunner.core.client.shape.view.HasSize;
import org.kie.workbench.common.stunner.core.client.shape.view.HasTitle;

/**
 * A Shape View type for SVG representations which adds
 * mutable capabilities on top of an {@link SVGBasicShapeView}.
 * @param <T> The SVGShapeView type.
 */
public interface SVGShapeView<T extends SVGShapeView>
        extends
        SVGBasicShapeView<T>,
        HasTitle<T>,
        HasControlPoints<T>,
        HasEventHandlers<T, Shape<?>>,
        HasFillGradient<T>,
        HasSize<T> {

    /**
     * An SVG shape view can contain visual definition states
     * as for the different shape states,
     */
    boolean applyState(final ShapeState shapeState);
}