/*
 * Copyright 2017 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.kie.workbench.common.stunner.cm.client.command.canvas;

import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.shape.MutationContext;
import org.kie.workbench.common.stunner.core.graph.Node;

public class CaseManagementAddNodeCanvasCommand extends org.kie.workbench.common.stunner.core.client.canvas.command.AddCanvasNodeCommand {

    public CaseManagementAddNodeCanvasCommand(final Node candidate,
                                              final String shapeSetId) {
        super(candidate,
              shapeSetId);
    }

    @Override
    @SuppressWarnings("unchecked")
    protected boolean registerCandidate(final AbstractCanvasHandler context) {
        context.register(getShapeSetId(),
                         getCandidate());
        context.updateElementProperties(getCandidate(),
                                        MutationContext.STATIC);
        return true;
    }
}
