/*
 * Copyright 2017 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.kie.workbench.common.stunner.core.rule.context.impl;

import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.rule.RuleEvaluationContext;
import org.kie.workbench.common.stunner.core.rule.context.NodeDockingContext;

class NodeDockingContextImpl
        extends AbstractGraphEvaluationContext
        implements NodeDockingContext {

    private final Element<? extends Definition<?>> parent;
    private final Node<? extends Definition<?>, ? extends Edge> candidate;

    NodeDockingContextImpl(final String name,
                           final Graph<?, ? extends Node> graph,
                           final Element<? extends Definition<?>> parent,
                           final Node<? extends Definition<?>, ? extends Edge> candidate) {
        super(name,
              graph);
        this.parent = parent;
        this.candidate = candidate;
    }

    @Override
    public Element<? extends Definition<?>> getParent() {
        return parent;
    }

    @Override
    public Node<? extends Definition<?>, ? extends Edge> getCandidate() {
        return candidate;
    }

    @Override
    public boolean isDefaultDeny() {
        return true;
    }

    @Override
    public Class<? extends RuleEvaluationContext> getType() {
        return NodeDockingContext.class;
    }
}
