/*
 * Copyright 2017 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.kie.workbench.common.stunner.project.diagram.impl;

import org.jboss.errai.common.client.api.annotations.MapsTo;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.kie.workbench.common.stunner.core.diagram.AbstractDiagram;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.content.definition.DefinitionSet;
import org.kie.workbench.common.stunner.project.diagram.ProjectDiagram;
import org.kie.workbench.common.stunner.project.diagram.ProjectMetadata;

@Portable
public class ProjectDiagramImpl extends AbstractDiagram<Graph, ProjectMetadata> implements ProjectDiagram {

    public ProjectDiagramImpl(final @MapsTo("name") String name,
                              final @MapsTo("graph") Graph<DefinitionSet, ?> graph,
                              final @MapsTo("metadata") ProjectMetadata metadata) {
        super(name,
              graph,
              metadata);
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProjectDiagramImpl)) {
            return false;
        }
        ProjectDiagramImpl that = (ProjectDiagramImpl) o;
        return getGraph() != null && getGraph().equals(that.getGraph());
    }

    /**
     * Currently diagram's name and metadata are not updated, just rely on the graph instance.
     * Improve this later if necessary.
     */
    @Override
    public int hashCode() {
        return getGraph().hashCode();
    }
}
